package org.eaglei.datatools.etl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.configuration.reloading.FileChangedReloadingStrategy;
import org.apache.commons.configuration.tree.xpath.XPathExpressionEngine;
import org.eaglei.datatools.interim.cores.Mapping;
import org.eaglei.datatools.interim.cores.Mapping.MappingType;
import org.eaglei.datatools.interim.cores.Mapping.SourceType;

public abstract class Mappings {
	
	
		public Map<String,Mapping> getMappings(String path) throws ConfigurationException {
			
			XMLConfiguration config= new XMLConfiguration(path);
	        config.setReloadingStrategy(new FileChangedReloadingStrategy());
	        config.setExpressionEngine(new XPathExpressionEngine());
			Map<String,Mapping> mappingMap = new HashMap<String,Mapping>();
			List<HierarchicalConfiguration> classConfigLst=config.configurationsAt("/mapping");
			Iterator<HierarchicalConfiguration> classIter = classConfigLst.iterator();
			while(classIter.hasNext())
			{
				HierarchicalConfiguration classConfig = classIter.next();
				String className=classConfig.getString("//@identifier");
				Mapping classMapping = new Mapping(MappingType.CLASS, SourceType.TAB,
						className, classConfig.getString("//@targetrdfNamespace"),classConfig.getString("//@targetidentifier"));
				 
				List<HierarchicalConfiguration> hirConfig=classConfig.configurationsAt("//propertymapping");
				Iterator<HierarchicalConfiguration> hirItr = hirConfig.iterator();
				while(hirItr.hasNext())
				{
					HierarchicalConfiguration columnConfig = hirItr.next();
					classMapping.addMapping(columnConfig.getString("//@identifier"), columnConfig.getString("//@targetrdfNamespace"),columnConfig.getString("//@targetidentifier"));	
				}
				mappingMap.put(className,classMapping);
			}
			
			
			
			return mappingMap;
			


	}

		public abstract Map<String,Mapping> getMappings() throws ConfigurationException ;
			
		
}
