package org.eaglei.datatools.etl.server;

import java.io.File;
import java.net.URL;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.datatools.config.DatatoolsConfiguration;
import org.eaglei.datatools.jena.RESTRepositoryProviderFactory;
import org.eaglei.datatools.provider.RepositoryProvider;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIURI;

public class RDFtoRepoService {

	private static RDFtoRepoService instance = null;
	private DatatoolsConfiguration config;
	RepositoryProvider repoProvider;
	private static final String DEFAULT_CONFIGURATION = "etl-datatools.prop";
	private static final Log logger = LogFactory.getLog(RDFtoRepoService.class);

	private RDFtoRepoService() throws Exception {
	
		config = getConfiguration();

		repoProvider = new RESTRepositoryProviderFactory()
				.createRepositoryProvider(config);
	}

	public RepositoryProvider getRepositoryProvider() {
		return repoProvider;
	}

	public DatatoolsConfiguration getDatatoolsConfiguration() {
		return config;
	}

	public static RDFtoRepoService getInstance() throws Exception {
		if (instance == null) {
			instance = new RDFtoRepoService();
		}
		return instance;
	}

	public boolean pushtoRepo(String rdfString) throws Exception {
		repoProvider.uploadInstances(rdfString);
		return true;
	}

	public List<EIURI> getNewInstancesFromRepo(int countofInstances)
			throws Exception {
		return repoProvider.getNewInstanceID(countofInstances);
	}




    private DatatoolsConfiguration getConfiguration() throws Exception
       {

           final URL configURL = this.getClass().getClassLoader().getResource(DEFAULT_CONFIGURATION);
           if (configURL == null) {
        	   logger.error("Could not locate " + DEFAULT_CONFIGURATION + " on classpath");
               throw new Exception("Could not locate " + DEFAULT_CONFIGURATION + " on classpath");
           }
           try {
               final File configFile = new File(configURL.toURI());
               logger.debug("loading configuration file: " + configFile);
               return new DatatoolsConfiguration(configFile);
           } catch (Exception e) {
        	   logger.error("Error loading configuration from " + configURL + " " + e);
               throw new Exception(e);
           }  
       }

	public void deleteRepo() throws Exception
	{
	


	            logger.debug("Deleting an instance:http://dev.alaska.eagle-i.net/i/*");
	            EIURI euuri = EIURI.create("http://dev.alaska.eagle-i.net/i/*");
	          EIInstance temp_ei = repoProvider.getInstance(euuri);
	            repoProvider.deleteInstance(temp_ei);
	            logger.debug("delete succeeded");
	       
	}
    
}
