/**
 * @author Sravan Cheriyala
 * 
 *   304 ,305,326(spreasheet hardcoded) lines are hardcoded .
 *   
 *   
 * 
 */

package org.eaglei.datatools.etl.server;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.swing.table.DefaultTableModel;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.eaglei.datatools.etl.utils.BasicUtils;
import org.eaglei.datatools.etl.utils.JenaUtils;
import org.eaglei.datatools.excel.ExcelParserException;
import org.eaglei.datatools.excel.ExcelUtils;
import org.eaglei.datatools.jena.SPARQLQueryUtil;
import org.eaglei.datatools.model.AnnotationFormModel;
import org.eaglei.datatools.provider.RepositoryProvider;
import org.eaglei.model.EIURI;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;

public class RdfMaker {

	private static final long serialVersionUID = 1L;
	private static Model prefixModel = null;
	private static HashMap predefinedMetaMap = null;
	private int count = 0;
	String[][] globalColumnsAry;
	private static final Log logger = LogFactory.getLog(RdfMaker.class);
	private String template;
	private String repo;
	private String directory;
	private String oputputdirectory;
	private static RDFtoRepoService rdftorepo;
	private String order;

	public static void main(String args[]) throws Exception {
		RdfMaker rdfmaker = new RdfMaker();
		// rdftorepo.getInstance().deleteRepo();
		try {
			if (args.length > 0) {
				for (int i = 0; i < args.length - 1; i++) {
					if (args[i].equals("-t")) {
						i = i + 1;
						rdfmaker.template = args[i];
					} else if (args[i].equals("-d")) {
						i = i + 1;
						rdfmaker.directory = args[i];
					} else if (args[i].equals("-o")) {
						i = i + 1;
						rdfmaker.oputputdirectory = args[i];
					}

				}
				if (rdfmaker.template.equals("boyerslab")) {
					rdfmaker.rdfToRepoByExcelStream(rdfmaker.directory,
							"src/main/resources/etl/cores_v3/map");
				}
			} else {
				rdfmaker.rdfToRepoByExcelStream(
						"src/main/resources/etl/cores_v3",
						"src/main/resources/etl/cores_v3/map");
			}

		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

	}

	public int getCount() {
		return count;
	}

	public RdfMaker() throws Exception {
		super();
		globalColumnsAry = new String[2][];
		template = new String();
		repo = new String();
		directory = new String();
		rdftorepo = RDFtoRepoService.getInstance();
		// initialize predefined prefix definition
		int count = Configure.prefixArray.length;
		HashMap predefinedPrefixes = new HashMap();
		for (int row = 0; row < count; row++) {
			predefinedPrefixes.put(Configure.prefixArray[row][0],
					Configure.prefixArray[row][1]);
		}
		prefixModel = ModelFactory.createDefaultModel();
		prefixModel.setNsPrefixes(predefinedPrefixes);

		// initialize predefined RDF123 spreadsheet metadata definition
		count = Configure.metaArray.length;
		predefinedMetaMap = new HashMap();
		for (int row = 0; row < count; row++) {
			predefinedMetaMap.put(Configure.metaArray[row][0],
					Configure.metaArray[row][1]);
		}

		// TODO Auto-generated constructor stub
	}

	/**
	 * save content from buffered inputstream into byteoutputstream
	 * 
	 * @param bInput
	 * @return
	 * @throws IOException
	 */

	public boolean rdfToRepoByExcelStream(final String excelFolder,
			final String mapFolder) throws Exception {

		/* map files */
		File mapdirectory = new File(mapFolder);
		String[] lstMapFiles = mapdirectory.list();
		Map<String, InputStream> mapIns = new HashMap<String, InputStream>();

		/* excel files */
		File excelDirectory = new File(excelFolder);

		String[] lstFiles = excelDirectory.list();

		for (String str : lstFiles) {

			try {
				if (!str.contains(".xlsx")) {
					logger.info(str + "is not Excel file ...Ignoring");
					continue;
				}
				for (String mapstr : lstMapFiles) {
					if (mapstr.contains(".svn")) {
						continue;
					}

					try {
						FileInputStream fis = new FileInputStream(mapFolder
								+ "/" + mapstr);
						mapIns.put(mapstr.replace(".rdf", ""), fis);
					} catch (FileNotFoundException e) {
						throw e;
					}

				}
				File dirfile = new File(excelFolder + "/" + str);
				if (dirfile.isDirectory()) {
					logger.info(excelFolder + "/" + str
							+ "is directory ...Ignoring");
					continue;

				}

				else {
					logger.info("processing file :" + excelFolder + "/" + str);
				}

				InputStream is = new BufferedInputStream(new FileInputStream(
						excelFolder + "/" + str));
				Map<String, DefaultTableModel> defaultModelMap = ExcelToTableModel(is);

				DefaultTableModel tableModel = defaultModelMap
						.get("INSTRUMENT");
				FileOutputStream fvec = new FileOutputStream(
						"src/test/resources/vector.txt");
				PrintWriter prrvec = new PrintWriter(fvec);
				prrvec.println(tableModel.getDataVector().toString());

				Map<String, Model> retMap = generateRDFGraph(defaultModelMap,
						mapIns);
				/*
				 * logger.info("pusing into repo started..."); Iterator<String>
				 * iter = retMap.keySet().iterator();
				 */
				/*
				 * while (iter.hasNext()) {
				 * 
				 * String tab = iter.next(); Model rdfModel = retMap.get(tab);
				 * StringWriter swriter = new StringWriter();
				 * 
				 * rdfModel.write(swriter, "N-TRIPLE");
				 * System.out.println(swriter.toString()); if (oputputdirectory
				 * != null) { FileOutputStream fout = new FileOutputStream(
				 * oputputdirectory + "/" + tab + ".rdf"); PrintWriter prr = new
				 * PrintWriter(fout); rdfModel.write(prr); }
				 * rdftorepo.pushtoRepo(swriter.toString()); if
				 * (oputputdirectory != null) { FileOutputStream fout = new
				 * FileOutputStream( oputputdirectory + "/" + tab + ".rdf");
				 * PrintWriter prr = new PrintWriter(fout); rdfModel.write(prr);
				 * } logger.info(tab + " pushed into repo"); }
				 */

				/*
				 * FileInputStream fis = new FileInputStream(mapFolder + "/" +
				 * str); mapIns.put(str.replace(".rdf", ""), fis);
				 */
			} catch (FileNotFoundException e) {
				throw e;
			}

		}
		return true;
	}

	protected static ByteArrayOutputStream download(BufferedInputStream bInput)
			throws IOException {
		ByteArrayOutputStream bytearray = new ByteArrayOutputStream();
		long bytenum = 0;
		final int BUFFER_SIZE = 8192;
		byte[] buffer = new byte[BUFFER_SIZE];
		int nRead;
		while ((nRead = bInput.read(buffer, 0, BUFFER_SIZE)) != -1) {
			bytearray.write(buffer, 0, nRead);

			bytenum += nRead;
			if (bytenum > Configure.MAX_SIZE)
				throw new OutOfMemoryError(
						"Oversized document: we only accept a upper limit of byte "
								+ Configure.MAX_SIZE + ".");
		}

		return bytearray;

	}

	public Map<String, Model> generateRDFGraph(
			Map<String, DefaultTableModel> tableModelMap,
			Map<String, InputStream> mapStreamMap) throws Exception {

		String[] keySetAry = order.split("#");
		Map<String, Model> retMap = new HashMap<String, Model>();
		int loopVar = 0;
		for (String keyStr : keySetAry) {
			DefaultTableModel tableModel = tableModelMap.get(keyStr
					.toUpperCase());
			InputStream mapStream = mapStreamMap.get(keyStr.toLowerCase());
			if (mapStream == null) {
				continue;
			}
			Model mapModel = null;
			Model rdfModel = null;

			rdfModel = ModelFactory.createDefaultModel();
			rdfModel.setNsPrefix("rdf123", (String) prefixModel
					.getNsPrefixMap().get("rdf123"));

			if (!keyStr.equalsIgnoreCase("LAB")) {
				continue;
			}

			// RDF base
			// String base = request.getRequestURL().toString() + "?" +
			// // request.getQueryString();

			String base = rdftorepo.getDatatoolsConfiguration()
					.getDatatoolsRepositoryNamespace();
			// String spreadsheetURL = "http://localhost/spreadsheerurl";
			// Map base
			String mapBase = null;

			// base = request.getRequestURL() + "?" + request.getQueryString() +
			// "/";
			// setBase(mapModel.getNsPrefixURI("base"));
			// rdfModel.setNsPrefix("", base);
			// prefixMap = mapModel.getNsPrefixMap();
			// if (excelInputStream != null) {

			/*
			 * Resource parentSubject = rdfModel.createResource("http://alaska"
			 * + EAGLE_I_DATA_URI_FRAGMENT); Property parentProperty =
			 * rdfModel.createProperty(rdfModel
			 * .expandPrefix("rdf123:hasSource"));
			 */

			// Literal objectLiteral =
			// rdfModel.createLiteral(gidParam==null?spreadsheetURL:spreadsheetURL+"&?gid="+gidParam);

			/*
			 * Resource parentObject = rdfModel.createResource(spreadsheetURL,
			 * rdfModel.createResource(rdfModel
			 * .expandPrefix("rdf123:Spreadsheet")));
			 * rdfModel.add(parentSubject, parentProperty, parentObject);
			 */

			// }

			Resource mapURIResource = null;

			HashMap metaMap = new HashMap();

			int metaBaseRow = 0;
			int metaBaseCol = 0;
			int colCount = tableModel.getColumnCount();
			int rowCount = tableModel.getRowCount();
			boolean find = false;
			for (int row = Configure.baseRow; row <= rowCount - 1; row++) {

				for (int col = Configure.baseCol; col <= colCount - 1; col++) {
					String cell = (String) tableModel.getValueAt(row, col);

					// if cell is not empty
					if (cell != null) {
						if (cell.trim().equalsIgnoreCase("rdf123:metadata")) {
							metaBaseRow = row;
							metaBaseCol = col;
							find = true;
							break;
						}

					}
				}
				if (find)
					break;
			}

			int metaRow = metaBaseRow + 1;
			int metaCol = metaBaseCol;
			while ((metaRow <= metaBaseRow + 8) && (metaCol < colCount - 1)) {
				String cell = (String) tableModel.getValueAt(metaRow, metaCol);
				if (!cell.trim().equals("")) {
					String valueCell = (String) tableModel.getValueAt(metaRow,
							metaCol + 1);
					if (!valueCell.trim().equals(""))
						metaMap.put(cell.trim(), valueCell.trim());
				} else
					break;
				metaRow++;
			}

			String mapURI = (String) metaMap.get("map file");

			String syntax = "RDF/XML";

			mapModel = ModelFactory.createDefaultModel();
			mapModel.read(mapStream, null, syntax);

			mapModel.removeNsPrefix("");
			rdfModel.setNsPrefixes(mapModel.getNsPrefixMap());

			// String rdf123 = mapModel.getNsPrefixURI("rdf123");

			boolean hasRowHead = true;
			int startRow = Configure.baseRow;
			int endRow = tableModel.getRowCount() - 1;
			int startCol = 1;

			Rdf123Expression rdf123Exp = new Rdf123Expression(tableModel,
					rdfModel.getNsPrefixMap(), startCol, base);
			// System.out.println(mapModel.toString());
			if (hasRowHead)
				startRow++;

			// for (int row = SharpTools.baseRow + 1; row <=
			// tableModel.getRowCount() - 1; row++) {
			List<EIURI> eiurilst = null;

			if (endRow - startRow >= 1) {

				eiurilst = rdftorepo
						.getNewInstancesFromRepo((endRow - startRow) + 1);

			}

			// System.out.println(mapModel.toString());

			count = 0;
			for (int row = startRow; row <= endRow; row++) {
				Map<String, String> mapInstanceExp = new HashMap<String, String>();
				// list the statements in the graph\

				int columnCount = tableModel.getColumnCount();
				boolean blankRow = true;
				for (int column = 0; column <= columnCount - 1; column++) {
					if (tableModel.getValueAt(row, column) != null) {
						if (!tableModel.getValueAt(row, column).equals("")) {
							blankRow = false;
							break;
						}
					}

				}

				if (blankRow) {
					continue;
				}

				StmtIterator mapIter = mapModel.listStatements();

				// print out the predicate, subject and object of each statement
				boolean checkforInstance = false;
				boolean foundInstance = false;
				Resource prevSubject = null;
				Property prevPredicate = null;
				RDFNode prevObject = null;
				Resource prevSubjectMap = null;
				RDFNode prevObjectMap = null;

				while (mapIter.hasNext()) {
					foundInstance = false;
					Statement stmtMap = mapIter.nextStatement(); // get next
					// statement
					Resource subjectMap = stmtMap.getSubject(); // get the
					// subject

					Property predicateMap = stmtMap.getPredicate(); // get the
					// predicate
					RDFNode objectMap = stmtMap.getObject(); // get the object

					/*if (objectMap.toString().equals(
							"Ex:e+ont+ei:ERO_0000004+$10")) {
						System.out.print("sravan");
					}*/

					Resource subject = null;
					Property predicate = null;
					RDFNode[] objectAry = new RDFNode[20];

					if (subjectMap.isAnon()) {
						subject = rdfModel.createResource(new AnonId(subjectMap
								.getId().toString()
								+ row));

					} else if (subjectMap.getURI().startsWith(Configure.EX)) {

						if (subjectMap.getURI().startsWith(Configure.EX + "e")) {

							if (subjectMap.getURI().startsWith(
									Configure.EX + "e+$0")) {
								if (eiurilst != null) {
									EIURI eiuri = eiurilst.get(count);
									subject = rdfModel.createResource(eiuri
											.toString());
								}
							} else if (subjectMap.getURI().matches(
									Configure.EX + "e\\+\\$\\d")
									&& !subjectMap.getURI().startsWith(
											Configure.EX + "e+$0")) {

								// List<EIURI> lstEIURI =
								// rdftorepo.getNewInstancesFromRepo(1);
								// EIURI eiuri= lstEIURI.get(0);
								Resource objectResourceForQuery = null;

								if (objectMap.isResource()) {
									objectResourceForQuery = (Resource) objectMap;
								}
								if (predicateMap
										.hasURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type")) {
									checkforInstance = true;
								}
								if (objectResourceForQuery == null) {

									if (foundInstance) {
										foundInstance = false;
										continue;
									} else if (prevSubjectMap != null
											&& prevSubjectMap.getURI().equals(
													subjectMap.getURI())) {
										subject = pushIfNewInstance(rdfModel,
												mapInstanceExp, subjectMap);
										prevSubjectMap = null;
										prevObjectMap = null;
									}

									else if (prevSubjectMap != null
											&& prevObjectMap != null
											&& !prevSubjectMap.getURI().equals(
													subjectMap.getURI())
											&& !prevObjectMap.isResource()) {
										checkForAlreadyModelAndAdd(rdfModel,
												prevSubject, prevPredicate,
												prevObject, subjectMap);
										checkforInstance = true;
										prevSubject = pushIfNewInstance(
												rdfModel, mapInstanceExp,
												subjectMap);
										prevSubjectMap = subjectMap;
										prevObjectMap = objectMap;
									}

									else {
										checkforInstance = true;
										List<EIURI> lstEIURI = rdftorepo
												.getNewInstancesFromRepo(1);
										EIURI neweiuri = lstEIURI.get(0);
										prevSubject = checkSubjectandAddMode(
												rdfModel, mapInstanceExp,
												subjectMap, neweiuri);
										prevSubjectMap = subjectMap;
										prevObjectMap = objectMap;
										;
									}

								} else {

									if (checkforInstance) {
										String[] strSplit = subjectMap.getURI()
												.split("\\+");
										EIURI eiuri = EIURI
												.create(mapModel
														.expandPrefix(objectResourceForQuery
																.getURI()));
										String literal = rdf123Exp.evaluate(
												strSplit[1], row);
										if (literal != null) {
											literal = literal.replace("?",
													"\\?").replace("+", "\\+")
													.replace("*", "\\*")
													.replace("(", "\\(")
													.replace(")", "//)");
										}

										String query = SPARQLQueryUtil
												.getInstance()
												.getEIResourcesByLabelQuery(
														eiuri, literal);

										logger.info(query);

										RepositoryProvider provider = rdftorepo
												.getRepositoryProvider();
										String instance = provider.query(query);
										String[] instanceURI = getInstanceURI(instance);

										if (instanceURI != null) {
											mapInstanceExp.put(subjectMap
													.getURI(), instanceURI[0]);

											subject = rdfModel
													.createResource(instanceURI[0]);
											foundInstance = true;
										} else {

											if (literal != null) {
												ResIterator iter = rdfModel
														.listSubjectsWithProperty(
																predicateMap,
																objectMap);

												boolean found = false;
												Resource foundResource = null;
												while (iter.hasNext()) {

													found = true;
													foundResource = iter.next();

												}
												if (found) {

													mapInstanceExp.put(subjectMap.getURI(),foundResource.getURI());
													subject = rdfModel.createResource(foundResource.getURI());
													foundInstance = true;
												}

												else {
													subject = pushIfNewInstance(rdfModel,mapInstanceExp,subjectMap);
												}
											}

										}
										checkforInstance = false;
										prevSubjectMap = subjectMap;
										prevObjectMap = objectMap;

									}

									else {
										subject = pushIfNewInstance(rdfModel,mapInstanceExp, subjectMap);
									}

								}

							}

							else if (subjectMap.getURI().matches(
									Configure.EX
											+ "e\\+ont\\+[^\\+]*?\\+\\$\\d+")) {

								/* case 3 */

								if (mapInstanceExp.get(subjectMap.getURI()) == null) {

									String[] strSplit = subjectMap.getURI()
											.split("\\+");
									String label = rdf123Exp.evaluate(
											strSplit[3], row);
									if (label != null) {
										label = label.replace("?", "\\?")
												.replace("+", "\\+").replace(
														"*", "\\*").replace(
														"(", "\\(").replace(
														")", "//)");
									}
									String uritoQuery = mapModel
											.expandPrefix(strSplit[2]);
									EIURI eiuri = EIURI.create(uritoQuery);
									String query = SPARQLQueryUtil
											.getInstance()
											.getEIResourcesByLabelQuery(eiuri,
													label);

									// logger.info(query);

									RepositoryProvider provider = rdftorepo
											.getRepositoryProvider();
									String instance = provider.query(query);
									String[] instanceURI = getInstanceURI(instance);

									if (instanceURI != null) {
										mapInstanceExp.put(subjectMap.getURI(),
												instanceURI[0]);

										subject = rdfModel
												.createResource(instanceURI[0]);
									} else {

										String ontologyURI = checkOntology(
												rdf123Exp, row, label,
												uritoQuery, mapModel);

										if (ontologyURI == null) {

											if (label != null) {
												ResIterator iter = rdfModel
														.listSubjectsWithProperty(
																predicateMap,
																objectMap);

												boolean found = false;
												Resource foundResource = null;
												while (iter.hasNext()) {

													found = true;
													foundResource = iter.next();

												}
												if (found) {

													mapInstanceExp
															.put(
																	subjectMap
																			.getURI(),
																	foundResource
																			.getURI());

													subject = rdfModel
															.createResource(foundResource
																	.getURI());
													foundInstance = true;
												}

												else {

													subject = pushIfNewInstance(
															rdfModel,
															mapInstanceExp,
															subjectMap);

													/*
													 * subject =
													 * pushIfNewInstance(
													 * rdfModel, mapInstanceExp,
													 * subjectMap);
													 */
												}
											}

											// continue;
										} else {

											subject = rdfModel
													.createResource(ontologyURI);
											mapInstanceExp
													.put(subjectMap.getURI(),
															subject.getURI());

										}

									}
								} else {

									subject = rdfModel
											.createResource(mapInstanceExp.get(
													subjectMap.getURI())
													.toString());
								}

							}

						}

						else if (subjectMap.getURI().startsWith(
								Configure.EX + "ont")) {
							String[] splitStr = subjectMap.getURI()
									.split("\\+");
							String[] splitNamespace = splitStr[1].split(":");
							String rootURI = mapModel.expandPrefix(splitStr[1]);
							String id = splitNamespace[1];

							String subclassLabel = rdf123Exp.evaluate(
									splitStr[2], row);
							String instanceURI = checkOntology(rdf123Exp, row,
									subclassLabel, rootURI, mapModel);
							if (instanceURI != null)
								subject = rdfModel.createResource(instanceURI);
							else {

								/*
								 * subject = pushIfNewInstance(rdfModel,
								 * mapInstanceExp, subjectMap);
								 */
								continue;
							}
						} else if ((!subjectMap.getURI().startsWith(
								Configure.EX + "e") && !subjectMap.getURI()
								.matches(Configure.EX + "ont"))
								|| subjectMap.getURI().startsWith(Configure.EX)) {
							String result = rdf123Exp.evaluate(subjectMap
									.getURI().substring(Configure.EX.length()),
									row);
							// if (result != null) result.replace('$', ' ');
							if (result != null) {
								if (!BasicUtils.isValidURL(result)) {
									if (!JenaUtils.isValidRDFId(result)) {
										result = result.replace(' ', '_');
										if (!JenaUtils.isValidRDFId(result)) {
											continue;
										}
									}

									result = toURI(base, result);
								}

								/*
								 * if (!JenaUtils.isValidRDFId(result)) { result
								 * = result.replace(' ','_'); if
								 * (!JenaUtils.isValidRDFId(result)) { continue;
								 * } }
								 * 
								 * if (!BasicUtils.isValidURL(result)) result =
								 * base + result;
								 */
								subject = rdfModel.createResource(result);
							} else
								continue;

						}
					} else if (subjectMap.getURI().equals(mapBase)) {
						if (mapBase.equals(Configure.BASE)) {
							if (mapURIResource != null) {
								subject = mapURIResource;
							} else {
								mapURIResource = rdfModel
										.createResource(rdfModel
												.createResource(rdfModel
														.expandPrefix("rdf123:Map")));
								// mapURI = rdfModel.createResource();
								subject = mapURIResource;
								rdfModel
										.add(
												rdfModel.createResource(base),
												rdfModel
														.createProperty(rdfModel
																.expandPrefix("rdf123:hasMap")),
												mapURIResource);
							}
						} else {
							if (mapURIResource != null) {
								subject = mapURIResource;
							} else {
								mapURIResource = rdfModel.createResource(
										mapURI,
										rdfModel.createResource(rdfModel
												.expandPrefix("rdf123:Map")));
								// mapURI = rdfModel.createResource(mapBase);
								subject = mapURIResource;
								rdfModel
										.add(
												rdfModel.createResource(base),
												rdfModel
														.createProperty(rdfModel
																.expandPrefix("rdf123:hasMap")),
												mapURIResource);
							}
						}
					} else {
						subject = subjectMap;
					}

					if (predicateMap.getURI().startsWith(Configure.EX)) {
						String result = rdf123Exp
								.evaluate(predicateMap.getURI().substring(
										Configure.EX.length()), row);
						// if (result != null) result.replace('$', ' ');
						if (result != null) {
							if (!BasicUtils.isValidURL(result)) {
								if (!JenaUtils.isValidRDFId(result)) {
									result = result.replace(' ', '_');
									if (!JenaUtils.isValidRDFId(result)) {
										continue;
									}
								}

								result = toURI(base, result);
							}

							if (checkforInstance) {
								prevPredicate = rdfModel.createProperty(result);
							} else {
								predicate = rdfModel.createProperty(result);
							}

						} else
							continue;
					} else {

						if (checkforInstance) {
							prevPredicate = predicateMap;
						} else {
							predicate = predicateMap;
						}
					}

					if (objectMap instanceof Resource) {
						Resource objectResource = (Resource) objectMap;

						if (objectResource.isAnon()) {
							RDFNode object = rdfModel
									.createResource(new AnonId(objectResource
											.getId().toString()
											+ row));
							objectAry[0] = object;
						} else {

							if (objectResource.getURI().startsWith(
									Configure.EX + "e")) {

								if (objectResource.getURI().matches(
										Configure.EX + "e\\+\\$\\d")
										|| objectResource
												.getURI()
												.matches(
														Configure.EX
																+ "e\\+ont\\+[^\\+]*?\\+\\$\\d+")) {

									/*
									 * RDFtoRepoService rdftorepo =
									 * RDFtoRepoService .getInstance();
									 */

									// List<EIURI> lstEIURI =
									// rdftorepo.getNewInstancesFromRepo(1);
									// EIURI eiuri= lstEIURI.get(0);

									/*
									 * String[] strSplit =
									 * objectResource.getURI() .split("\\+");
									 * EIURI eiuri = EIURI .create(mapModel
									 * .expandPrefix(predicateMap .getURI()));
									 * String query = SPARQLQueryUtil
									 * .getInstance()
									 * .getEIResourcesByLabelQuery( eiuri,
									 * rdf123Exp.evaluate( strSplit[1], row));
									 * 
									 * RepositoryProvider provider = rdftorepo
									 * .getRepositoryProvider(); String instance
									 * = provider.query(query); String[]
									 * instanceURI = getInstanceURI(instance);
									 * if (instanceURI != null) {
									 * 
									 * int i = 0; for (String instaceStr :
									 * instanceURI) { RDFNode object = rdfModel
									 * .createResource(instaceStr); objectAry[i]
									 * = object; }
									 * 
									 * } else {
									 */

									if (checkforInstance) {
										String strEiURI = mapInstanceExp
												.get(objectResource.getURI());
										prevObject = rdfModel
												.createResource(strEiURI);
									} else {
										String strEiURI = mapInstanceExp
												.get(objectResource.getURI());
										if (strEiURI != null) {
											RDFNode object = rdfModel
													.createResource(strEiURI);

											objectAry[0] = object;

										} else {

											/*
											 * String[] strSplit =
											 * objectResource.getURI()
											 * .split("\\+"); EIURI eiuri =
											 * EIURI .create(mapModel
											 * .expandPrefix(predicateMap
											 * .getURI())); String query =
											 * SPARQLQueryUtil .getInstance()
											 * .getEIResourcesByLabelQuery(
											 * eiuri, rdf123Exp.evaluate(
											 * strSplit[1], row));
											 * 
											 * RepositoryProvider provider =
											 * rdftorepo
											 * .getRepositoryProvider(); String
											 * instance = provider.query(query);
											 * String[] instanceURI =
											 * getInstanceURI(instance);
											 */

											List<EIURI> lstEIURI = rdftorepo
													.getNewInstancesFromRepo(1);
											EIURI neweiuri = lstEIURI.get(0);
											mapInstanceExp.put(objectResource
													.getURI(), neweiuri
													.toString());

											RDFNode object = rdfModel
													.createResource(neweiuri
															.toString());
											objectAry[0] = object;
										}

									}

									// }

								}

							} else if (objectResource.getURI().matches(
									Configure.EX + "ont\\+[^\\+]*?\\+\\$\\d+")) {
								boolean retBoolean = true;
								if (predicate != null) {
									retBoolean = ontProcess(keyStr, mapModel,
											rdfModel, rdf123Exp, row,
											mapInstanceExp, objectAry,
											objectResource.toString(),
											predicate);
								} else {
									retBoolean = ontProcess(keyStr, mapModel,
											rdfModel, rdf123Exp, row,
											mapInstanceExp, objectAry,
											objectResource.toString(),
											prevPredicate);
								}
								if (!retBoolean) {
									if (predicate != null) {
										predicate = rdfModel
												.createProperty("http://eagle-i.org/ont/dt/temporary/"
														+ predicate
																.getLocalName());
									} else {
										predicate = rdfModel
												.createProperty("http://eagle-i.org/ont/dt/temporary/"
														+ prevPredicate
																.getLocalName());
									}

								}

							}

							else if (objectResource.getURI().startsWith(
									Configure.EX)
									&& !objectResource.getURI().matches("ont")) {

								String result = rdf123Exp.evaluate(
										objectResource.getURI().substring(
												Configure.EX.length()), row);
								// String result =
								// rdf123Exp.evaluate(getLocalName(objectResource.getURI()),
								// row);
								// if (result != null) result.replace('$', ' ');
								if (result != null) {

									StmtIterator propertyIter = objectResource
											.listProperties();

									if (propertyIter.hasNext()) {
										if (!BasicUtils.isValidURL(result)) {
											if (!JenaUtils.isValidRDFId(result)) {
												result = result.replace(' ',
														'_');
												if (!JenaUtils
														.isValidRDFId(result)) {
													continue;
												}
											}

											result = toURI(base, result);
										}
										RDFNode object = rdfModel
												.createResource(result);
										objectAry[0] = object;

									} else {
										if (BasicUtils.isValidURL(result)) {
											RDFNode object = rdfModel
													.createResource(result);
											objectAry[0] = object;
										}

										else {
											RDFNode object = rdfModel
													.createLiteral(result);
											objectAry[0] = object;
										}

									}

								} else
									continue;
							} else {
								RDFNode object = rdfModel
										.createResource(objectResource.getURI());
								objectAry[0] = object;
							}

						}
					} else {

						Literal objectLiteral = (Literal) objectMap;
						RDFDatatype dataType = objectLiteral.getDatatype();

						if (objectLiteral.toString().matches(
								Configure.EX + "ont\\+[^\\+]*?\\+\\$\\d+")) {

							boolean retBoolean = true;

							if (predicate != null) {
								retBoolean = ontProcess(keyStr, mapModel,
										rdfModel, rdf123Exp, row,
										mapInstanceExp, objectAry,
										objectLiteral.toString(), predicate);
							} else {
								retBoolean = ontProcess(keyStr, mapModel,
										rdfModel, rdf123Exp, row,
										mapInstanceExp, objectAry,
										objectLiteral.toString(), prevPredicate);
							}
							if (!retBoolean) {
								if (predicate != null) {
									predicate = rdfModel
											.createProperty("http://eagle-i.org/ont/dt/temporary/"
													+ predicate.getLocalName());
								} else {
									predicate = rdfModel
											.createProperty("http://eagle-i.org/ont/dt/temporary/"
													+ prevPredicate
															.getLocalName());
								}

							}

						}

						else {
							if (dataType == null) {
								if (objectLiteral.getString().startsWith(
										Configure.EX)) {
									String localName = objectLiteral
											.getString().substring(
													Configure.EX.length());
									if (localName.endsWith("^^string")) {
										String expression = localName
												.substring(0, localName
														.length() - 8);
										String result = rdf123Exp.evaluate(
												expression, row);
										if (result != null) {

											if (checkforInstance) {
												prevObject = rdfModel
														.createTypedLiteral(
																result,
																XSDDatatype.XSDstring);
											}

											else {
												RDFNode object = rdfModel
														.createTypedLiteral(
																result,
																XSDDatatype.XSDstring);
												objectAry[0] = object;
											}

										} else
											continue;

									} else if (localName.endsWith("^^decimal")) {
										String expression = localName
												.substring(0, localName
														.length() - 9);
										String result = rdf123Exp.evaluate(
												expression, row);
										if (result != null) {
											RDFNode object = rdfModel
													.createTypedLiteral(
															result,
															XSDDatatype.XSDdecimal);
											objectAry[0] = object;
										} else
											continue;

									} else if (localName.endsWith("^^integer")) {
										String expression = localName
												.substring(0, localName
														.length() - 9);
										String result = rdf123Exp.evaluate(
												expression, row);
										if (result != null) {
											RDFNode object = rdfModel
													.createTypedLiteral(
															result,
															XSDDatatype.XSDinteger);
											objectAry[0] = object;
										} else
											continue;

									} else if (localName.endsWith("^^float")) {
										String expression = localName
												.substring(0, localName
														.length() - 7);
										String result = rdf123Exp.evaluate(
												expression, row);
										if (result != null) {
											RDFNode object = rdfModel
													.createTypedLiteral(
															result,
															XSDDatatype.XSDfloat);
											objectAry[0] = object;
										} else
											continue;

									} else if (localName.endsWith("^^boolean")) {
										String expression = localName
												.substring(0, localName
														.length() - 9);
										String result = rdf123Exp.evaluate(
												expression, row);
										if (result != null) {
											RDFNode object = rdfModel
													.createTypedLiteral(
															result,
															XSDDatatype.XSDboolean);
											objectAry[0] = object;
										} else
											continue;

									} else if (localName.endsWith("^^time")) {
										String expression = localName
												.substring(0, localName
														.length() - 6);
										String result = rdf123Exp.evaluate(
												expression, row);
										if (result != null) {
											RDFNode object = rdfModel
													.createTypedLiteral(result,
															XSDDatatype.XSDtime);
											objectAry[0] = object;
										} else
											continue;

									} else if (localName.endsWith("^^anyURI")) {
										String expression = localName
												.substring(0, localName
														.length() - 8);
										String result = rdf123Exp.evaluate(
												expression, row);
										if (result != null) {
											RDFNode object = rdfModel
													.createTypedLiteral(
															result,
															XSDDatatype.XSDanyURI);
											objectAry[0] = object;
										} else
											continue;

									} else if (localName.endsWith("^^double")) {
										String expression = localName
												.substring(0, localName
														.length() - 8);
										String result = rdf123Exp.evaluate(
												expression, row);
										if (result != null) {
											RDFNode object = rdfModel
													.createTypedLiteral(
															result,
															XSDDatatype.XSDdouble);
											objectAry[0] = object;
										} else
											continue;

									} else if (localName.endsWith("^^int")) {
										String expression = localName
												.substring(0, localName
														.length() - 5);
										String result = rdf123Exp.evaluate(
												expression, row);
										if (result != null) {
											RDFNode object = rdfModel
													.createTypedLiteral(result,
															XSDDatatype.XSDint);
											objectAry[0] = object;
										} else
											continue;

									} else if (localName.endsWith("^^long")) {
										String expression = localName
												.substring(0, localName
														.length() - 6);
										String result = rdf123Exp.evaluate(
												expression, row);
										if (result != null) {
											RDFNode object = rdfModel
													.createTypedLiteral(result,
															XSDDatatype.XSDlong);
											objectAry[0] = object;
										} else
											continue;

									} else if (localName.endsWith("^^short")) {
										String expression = localName
												.substring(0, localName
														.length() - 7);
										String result = rdf123Exp.evaluate(
												expression, row);
										if (result != null) {
											RDFNode object = rdfModel
													.createTypedLiteral(
															result,
															XSDDatatype.XSDshort);
											objectAry[0] = object;
										} else
											continue;

									} else if (localName
											.endsWith("^^positiveInteger")) {
										String expression = localName
												.substring(0, localName
														.length() - 17);
										String result = rdf123Exp.evaluate(
												expression, row);
										if (result != null) {
											RDFNode object = rdfModel
													.createTypedLiteral(
															result,
															XSDDatatype.XSDpositiveInteger);
											objectAry[0] = object;
										} else
											continue;

									} else if (localName
											.endsWith("^^negativeInteger")) {
										String expression = localName
												.substring(0, localName
														.length() - 17);
										String result = rdf123Exp.evaluate(
												expression, row);
										if (result != null) {
											RDFNode object = rdfModel
													.createTypedLiteral(
															result,
															XSDDatatype.XSDnegativeInteger);
											objectAry[0] = object;
										} else
											continue;

									} else if (localName.endsWith("^^byte")) {
										String expression = localName
												.substring(0, localName
														.length() - 6);
										String result = rdf123Exp.evaluate(
												expression, row);
										if (result != null) {
											RDFNode object = rdfModel
													.createTypedLiteral(result,
															XSDDatatype.XSDbyte);
											objectAry[0] = object;
										} else
											continue;

									} else if (localName.endsWith("^^dateTime")) {
										String expression = localName
												.substring(0, localName
														.length() - 10);
										String result = rdf123Exp.evaluate(
												expression, row);
										if (result != null) {
											RDFNode object = rdfModel
													.createTypedLiteral(
															result,
															XSDDatatype.XSDdateTime);
											objectAry[0] = object;

										} else
											continue;

									} else if (localName.endsWith("^^token")) {
										String expression = localName
												.substring(0, localName
														.length() - 7);
										String result = rdf123Exp.evaluate(
												expression, row);
										if (result != null) {
											RDFNode object = rdfModel
													.createTypedLiteral(
															result,
															XSDDatatype.XSDtoken);
											objectAry[0] = object;

										} else
											continue;

									} else if (localName.endsWith("^^language")) {
										String expression = localName
												.substring(0, localName
														.length() - 10);
										String result = rdf123Exp.evaluate(
												expression, row);
										if (result != null) {
											RDFNode object = rdfModel
													.createTypedLiteral(
															result,
															XSDDatatype.XSDlanguage);
											objectAry[0] = object;
										} else
											continue;

									} else if (localName.endsWith("^^date")) {
										String expression = localName
												.substring(0, localName
														.length() - 6);
										String result = rdf123Exp.evaluate(
												expression, row);
										if (result != null) {
											RDFNode object = rdfModel
													.createTypedLiteral(result,
															XSDDatatype.XSDdate);
											objectAry[0] = object;
										} else
											continue;

									} else {
										String expression = localName;
										String result = rdf123Exp.evaluate(
												expression, row);
										if (result != null) {
											if (BasicUtils.isValidURL(result)) {

												if (checkforInstance) {
													prevObject = rdfModel
															.createResource(result);
												}

												else {
													RDFNode object = rdfModel
															.createResource(result);
													objectAry[0] = object;
												}

											}

											else {
												if (checkforInstance) {
													prevObject = rdfModel
															.createResource(result);
												}

												else {
													RDFNode object = rdfModel
															.createResource(result);
													objectAry[0] = object;
												}
											}

										} else
											continue;
									}

								} else {

									if (checkforInstance) {
										prevObject = objectMap;
									} else {
										RDFNode object = objectMap;
										objectAry[0] = object;
									}

								}

							} else {
								// object = rdfModel.createTypedLiteral(result,
								// XSDDatatype.XSDdate);
								if (checkforInstance) {
									prevObject = objectMap;

								} else {
									RDFNode object = objectMap;
									objectAry[0] = object;
								}

							}
						}

					}

					if (subject != null
							&& !foundInstance
							&& prevSubjectMap != null
							&& prevSubject != null
							&& prevPredicate != null
							&& prevObject != null
							&& prevSubjectMap.getURI().equals(
									subjectMap.getURI())) {

						checkForAlreadyModelAndAdd(rdfModel, prevSubject,
								prevPredicate, prevObject, subjectMap);

						checkforInstance = false;
						foundInstance = false;
						/*
						 * prevSubject = null; prevPredicate = null;
						 * prevObject=null;
						 */

					}

					/*
					 * else if(!checkforInstance && prevSubject!=null) {
					 * rdfModel.add(prevSubject, prevPredicate, prevObject);
					 * 
					 * prevSubject = null; prevPredicate = null;
					 * prevObject=null; }
					 */

					if (!checkforInstance && !foundInstance) {
						for (RDFNode objectNode : objectAry) {
							if (objectNode != null) {

								checkForAlreadyModelAndAdd(rdfModel, subject,
										predicate, objectNode, subjectMap);
							}

						}

					}
					/*
					 * else if(subjectMap.getURI().matches("Ex:e+$0")){ for
					 * (RDFNode objectNode : objectAry) { if (objectNode !=
					 * null) {
					 * 
					 * checkForAlreadyModelAndAdd(rdfModel, subject, predicate,
					 * objectNode); }
					 * 
					 * } }
					 */

				}
				count++;

			}

			/*
			 * ServletOutputStream outStream = response.getOutputStream(); //
			 * PrintWriter writer = response.getOutputStream();
			 * 
			 * if (syn == null || syn.equalsIgnoreCase("XML")) {
			 * response.setContentType(Configure.contentTypeXML); //
			 * response.setContentType(Joseki.contentTypeXML);
			 * outStream.println("<?xml version=\"1.0\"?>"); // StringWriter sw
			 * = new StringWriter(); if ((endRow - startRow + 1) * colCount <
			 * Configure.PRETTY_SIZE) rdfModel.write(outStream,
			 * "RDF/XML-ABBREV", base); else rdfModel.write(outStream,
			 * "RDF/XML", base); } else {
			 * response.setContentType(Configure.contentTypeTextPlain);
			 * rdfModel.write(outStream, syn, base); }
			 * 
			 * // writer.println(sw.toString()); outStream.flush();
			 * outStream.close();
			 */

			if (count % 50 == 0)
				System.gc();
			// rdfModel.write(prr, "N-TRIPLE");
			// retModel[loopVar] = rdfModel;
			retMap.put(keyStr, rdfModel);
			/*
			 * if (keyStr.equals("INSTRUMENT")) {
			 * 
			 * 
			 * * List<EIInstance> lstEIInstance =
			 * EIInstanceFactory.INSTANCE.create(rdfModel);
			 * RDFtoRepoService.getInstance().pushtoRepo(lstEIInstance);
			 * 
			 * 
			 * RDFtoRepoService rdftorepo = RDFtoRepoService.getInstance();
			 * StringWriter swriter = new StringWriter();
			 * rdfModel.write(swriter, "N-TRIPLE");
			 * 
			 * rdftorepo.pushtoRepo(swriter.toString());
			 * 
			 * }
			 */

			/*
			 * if (keyStr.equals("INSTRUMENT")) { RDFtoRepoService rdftorepo =
			 * RDFtoRepoService.getInstance(); StringWriter swriter = new
			 * StringWriter(); rdfModel.write(swriter);
			 * 
			 * 
			 * rdftorepo.pushtoRepo(swriter.toString(), 300); }
			 */
			logger.info("pushing " + keyStr + "to repo");
			StringWriter swriter = new StringWriter();

			rdfModel.write(swriter, "N-TRIPLE");
			rdftorepo.pushtoRepo(swriter.toString());

			if (oputputdirectory != null) {
				FileOutputStream fout = new FileOutputStream(oputputdirectory
						+ "/" + keyStr + ".rdf");
				PrintWriter prr = new PrintWriter(fout);
				rdfModel.write(prr);
			}
			logger.info(keyStr + " pushed into repo");
			loopVar++;
		}

		return retMap;

	}

	private boolean ontProcess(String keyStr, Model mapModel, Model rdfModel,
			Rdf123Expression rdf123Exp, int row,
			Map<String, String> mapInstanceExp, RDFNode[] objectAry,
			String objectResourceURI, Property predicate) throws Exception {
		try {
			String[] splitStr = objectResourceURI.split("\\+");

			String rootURI = mapModel.expandPrefix(splitStr[1]);

			String subclassLabel = rdf123Exp.evaluate(splitStr[2], row);

			String result = checkOntology(rdf123Exp, row, subclassLabel,
					rootURI, mapModel);
			boolean retBoolean = false;

			if (result != null) {
				RDFNode object = rdfModel.createResource(result);

				objectAry[0] = object;
				retBoolean = true;
				return retBoolean;
			} else {
				// List<EIURI> lstEIURI = rdftorepo.getNewInstancesFromRepo(1);
				// EIURI neweiuri = lstEIURI.get(0);

				mapInstanceExp.put(objectResourceURI,
						"http://eagle-i.org/ont/dt/temporary/"
								+ predicate.getLocalName());

				RDFNode object = rdfModel.createLiteral(subclassLabel);
				objectAry[0] = object;
				retBoolean = false;
				return retBoolean;
			}

		} catch (ArrayIndexOutOfBoundsException e) {
			logger.debug(keyStr + "----" + objectResourceURI);
			throw e;
		}

	}

	private void checkForAlreadyModelAndAdd(Model rdfModel, Resource subject,
			Property predicate, RDFNode objectNode, Resource subjectMap) {

		ResIterator iter = rdfModel.listSubjectsWithProperty(predicate,
				objectNode);
		boolean found = false;

		while (iter.hasNext()) {
			found = true;
			break;
		}
		if ((!found && subject != null && objectNode != null
				&& predicate != null && subjectMap != null)
				|| subjectMap.getURI().equals("Ex:e+$0")) {

			logger.debug("added" + subject.toString() + "--"
					+ predicate.toString() + "---" + objectNode.toString());
			rdfModel.add(subject, predicate, objectNode);
		}

	}

	private Resource pushIfNewInstance(Model rdfModel,
			Map<String, String> mapInstanceExp, Resource subjectMap)
			throws Exception {
		Resource subject;
		List<EIURI> lstEIURI = rdftorepo.getNewInstancesFromRepo(1);
		EIURI neweiuri = lstEIURI.get(0);
		subject = checkSubjectandAddMode(rdfModel, mapInstanceExp, subjectMap,
				neweiuri);
		return subject;
	}

	private Resource checkSubjectandAddMode(Model rdfModel,
			Map<String, String> mapInstanceExp, Resource subjectMap,
			EIURI neweiuri) {

		String uri = mapInstanceExp.get(subjectMap.getURI());
		if (uri == null) {
			Resource subject;
			mapInstanceExp.put(subjectMap.getURI(), neweiuri.toString());

			subject = rdfModel.createResource(neweiuri.toString());
			return subject;
		} else {
			Resource subject;
			subject = rdfModel.createResource(uri);
			return subject;
		}

	}

	private String checkOntology(Rdf123Expression rdf123Exp, int row,
			String label, String URI, Model mapModel) throws Exception {
		AnnotationFormModel anntModel = AnnotationFormModel.getInstance();

		String result = anntModel.findSubclassByLabel(URI, label);
		return result;
	}

	public Map<String, DefaultTableModel> ExcelToTableModel(
			InputStream excelInputStream) throws Exception {

		Workbook wb;
		boolean rdfmetadatafound = false;

		try {

			wb = WorkbookFactory.create(excelInputStream);

		} catch (FileNotFoundException e) {
			throw new ExcelParserException(e);
		} catch (InvalidFormatException e) {
			throw new ExcelParserException("Expecting an Excel file", e);
		} catch (IOException e) {
			throw new ExcelParserException(e);
		} finally {
			try {
				if (excelInputStream != null)
					excelInputStream.close();
			} catch (IOException e) {/* can't do anything */
			}
		}

		Map<String, DefaultTableModel> tableModelMap = new HashMap<String, DefaultTableModel>();
		int numBerOFSheets = wb.getNumberOfSheets();

		for (int sheetNum = 0; sheetNum <= numBerOFSheets - 1; sheetNum++) {
			Sheet sheet = wb.getSheetAt(sheetNum);
			// System.out.println(sheet.getSheetName());
			int rowcount = sheet.getLastRowNum();
			int colcount;

			if (sheet.getRow(1) == null) {
				continue;
			} else {
				colcount = sheet.getRow(1).getLastCellNum();
			}

			DefaultTableModel tableModel = new DefaultTableModel(rowcount + 1,
					colcount + 1);

			for (int row = Configure.baseRow; row < rowcount; row++) {
				tableModel.setValueAt(String.valueOf(row + 1), row, 0);
			}

			for (int row = Configure.baseRow; row < rowcount; row++)
				for (int col = Configure.baseCol; col < colcount + 1; col++)
					tableModel.setValueAt(new String(""), row, col);

			double startRow = 0;
			double endRow = 0;
			Iterator<Row> rowIter = sheet.rowIterator();

			while (rowIter.hasNext()) {
				Row row = rowIter.next();
				Iterator<Cell> cellIter = row.cellIterator();
				while (cellIter.hasNext()) {
					Cell cell = cellIter.next();
					int rowNum = row.getRowNum();
					int colNum = cell.getColumnIndex();

				}
				break;
			}

			boolean startRowFlag = false;
			boolean endRowFlag = false;
			boolean globalColumns = false;
			boolean globalColumnsValues = false;
			boolean rowhead = false;
			boolean rdfmetadata = false;

			int rowheadStart = 0;

			int loopVarIncrement = 0;
			int loopVarLimit = 1;

			while (loopVarIncrement <= loopVarLimit || loopVarLimit == 1) {

				Row row = sheet.getRow(loopVarIncrement);
				if (row == null)
					break;
				Iterator<Cell> cellIter = row.cellIterator();
				while (cellIter.hasNext()) {
					/*
					 * to fetch the startrow and end row so that we parse only
					 * those rows
					 */
					Cell cell = cellIter.next();
					int rowNum = row.getRowNum();

					int colNum;
					if (startRowFlag) {
						startRow = cell.getNumericCellValue();
						startRowFlag = false;
					}

					else if (endRowFlag) {
						endRow = cell.getNumericCellValue();

						endRowFlag = false;
					} else if (globalColumns) {
						globalColumnsAry[0] = cell.getStringCellValue().split(
								";");
						globalColumns = false;

					} else if (globalColumnsValues) {
						globalColumnsAry[1] = cell.getStringCellValue().split(
								";");
						globalColumnsValues = false;

						tableModel.setColumnCount(tableModel.getColumnCount()
								+ globalColumnsAry[0].length);

					} else if (rowhead) {
						rowheadStart = (int) cell.getNumericCellValue();
						tableModel.setColumnCount(sheet.getRow(rowheadStart)
								.getLastCellNum() + 1);
						if (endRow == 0)
							endRow = rowheadStart;
						rowhead = false;
					} else if (rdfmetadata) {
						loopVarLimit = loopVarLimit * 8;
						rdfmetadata = false;
					}

					if (cell.getCellType() == Cell.CELL_TYPE_STRING
							&& cell.getStringCellValue().equals("start row")) {
						startRowFlag = true;

					}

					else if (cell.getCellType() == Cell.CELL_TYPE_STRING
							&& cell.getStringCellValue().equals("end row")) {

						endRowFlag = true;
					}

					else if (cell.getCellType() == Cell.CELL_TYPE_STRING
							&& cell.getStringCellValue().equalsIgnoreCase(
									"globalcolumns")) {
						globalColumns = true;
					}

					else if (cell.getCellType() == Cell.CELL_TYPE_STRING
							&& cell.getStringCellValue().equalsIgnoreCase(
									"globalcolumnsvalues")) {
						globalColumnsValues = true;
					} else if (cell.getCellType() == Cell.CELL_TYPE_STRING
							&& cell.getStringCellValue().equalsIgnoreCase(
									"row head")) {
						rowhead = true;
					} else if (cell.getCellType() == Cell.CELL_TYPE_STRING
							&& cell.getStringCellValue().equalsIgnoreCase(
									"rdf123:metadata")) {
						rdfmetadata = true;
						rdfmetadatafound = true;
					}
				}
				loopVarIncrement++;
			}

			if (!rdfmetadatafound) {

				Map<String, String> rowConfigMap = RowConfiguration
						.getRowInfoMap(
								"C:\\workspace\\tools\\src\\main\\resources\\etl\\cores_v3\\map",
								sheet.getSheetName());
				startRow = Integer.parseInt(rowConfigMap.get("startrow"));

				rowheadStart = Integer.parseInt(rowConfigMap
						.get("rowheadstart"));
				order = rowConfigMap.get("order");
			}
			int i = (int) startRow - 1;
			endRow = sheet.getPhysicalNumberOfRows();
			while (i <= endRow - 1) {

				Row row = sheet.getRow(i);

				if (row == null)
					break;

				if (ExcelUtils.isBlankRow(row)) {
					i++;
					continue;
				}

				Iterator<Cell> cellIter = row.cellIterator();
				while (cellIter.hasNext()) {
					Cell cell = cellIter.next();

					if (i >= 343) {
						if (cell.getCellType() == Cell.CELL_TYPE_STRING
								|| cell.getCellType() == 2) {

						} else {

						}
					}

					int rowNum = row.getRowNum();

					int colNum;

					if (rowheadStart > 0 && rowNum >= rowheadStart
							&& globalColumnsAry[0] != null) {
						colNum = cell.getColumnIndex()
								+ globalColumnsAry[0].length - 1;
					} else {
						colNum = cell.getColumnIndex();
					}

					/* to fetch the globalcolumns and globalvalues */

					addCell(tableModel, cell, rowNum, colNum);

				}

				if (globalColumnsAry[0] != null) {
					if (i == rowheadStart && globalColumnsAry[0].length > 0) {
						int y = 0;
						for (String s : globalColumnsAry[0]) {
							addCell(tableModel, s, i, y);
							y++;
						}

					} else if (i > rowheadStart && globalColumnsAry[1] != null) {
						int y = 0;
						for (String s : globalColumnsAry[1]) {
							addCell(tableModel, s, i, y);
							y++;
						}
					}
				}

				i++;

			}

			tableModelMap.put(sheet.getSheetName(), tableModel);

		}
		return tableModelMap;

	}

	private void addCell(DefaultTableModel tableModel, Cell cell, int rowNum,
			int colNum) {
		try {

			tableModel.setValueAt(cell.getStringCellValue() + "", rowNum,
					colNum + Configure.baseCol);

		} catch (ArrayIndexOutOfBoundsException e) {
			throw e;
		}

		catch (Exception e) {

			tableModel.setValueAt(

			(int) cell.getNumericCellValue() + "", rowNum, colNum
					+ Configure.baseCol);
		}
	}

	private void addCell(DefaultTableModel tableModel, String cellValue,
			int rowNum, int colNum) {

		tableModel.setValueAt(cellValue, rowNum, colNum + Configure.baseCol);

	}

	private String toURI(String base, String localname) {
		if (base.endsWith("/"))
			return base + localname;
		else
			return base + "#" + localname;
	}

	public static String[] getInstanceURI(String xmlString) {

		if (xmlString != null) {
			java.util.regex.Pattern instancePattern = java.util.regex.Pattern
					.compile("<uri>([^<]*?)</uri>");

			java.util.regex.Matcher match = instancePattern.matcher(xmlString);
			String[] instanceStr = null;
			while (match.find()) {
				int count = match.groupCount();
				instanceStr = new String[count];
				for (int i = 1; i <= count; i++) {
					instanceStr[i - 1] = match.group(i);
				}

			}
			return instanceStr;
		} else {
			return null;
		}

	}

}
