// The MIT License
//
// Copyright (c) 2005 Michael Grove
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
// IN THE SOFTWARE.

package org.eaglei.datatools.etl.utils;

/**
 * <p>Title: Bookmark</p>
 * <p>Description: A bookmarked location on the web.  Bookmarks have a type, currently either an image or an ontology, but others can be added.</p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>Company: Mindswap (http://www.mindswap.org)</p>
 * @author Michael Grove
 * @version 1.0
 */
public class Bookmark
{
    /**
     * Image Bookmark type const
     */
    public static final int BOOKMARK_IMAGE = 0;

    /**
     * Ontology bookmark type const
     */
    public static final int BOOKMARK_ONTOLOGY = 1;

    private int mType;
    private String mURL;
    private String mLabel;

    /**
     * Create a new bookmark
     * @param type int the type
     * @param label String the label
     * @param url String the url to bookmark
     */
    public Bookmark(int type, String label, String url)
    {
        mType = type;
        mLabel = label;
        mURL = url;
    }

    /**
     * Get the label of this Bookmark
     * @return String the label
     */
    public String getLabel() {
        return mLabel;
    }

    /**
     * Get the URL of this bookmark
     * @return String the url
     */
    public String getURL() {
        return mURL;
    }

    /**
     * Get the type of the bookmark
     * @return int the bookmark type
     */
    public int getType() {
        return mType;
    }

    /**
     * Returns the string representation of this bookmark, which is the label associated with it
     * @return String
     */
    public String toString() {
        return getLabel();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Bookmark)
        {
            Bookmark bm = (Bookmark)obj;
            return bm.getType() == getType() && bm.getURL().equals(getURL());
        }
        else return false;
    }

    public int hashCode() {
        return getType() + getURL().hashCode();
    }
}
