package org.eaglei.datatools.etl.utils;

import java.util.Vector;

/**
 * <p>Title: </p>
 *
 * <p>Description: </p>
 *
 * <p>Copyright: Copyright (c) 2005</p>
 *
 * <p>Company: MIndswap (http://www.mindswap.org)</p>
 *
 * @author Michael Grove
 * @version 1.0
 */
public class ByStringTokenizer {
    private Vector mTokens;
    private int mIndex;

    public ByStringTokenizer(String str, String[] delims) {
      this(str,delims,true,true);
    } // cons

    public ByStringTokenizer(String str, String[] delims, boolean returnDelims) {
      this(str,delims,returnDelims,true);
    } // cons

    public ByStringTokenizer(String str, String[] delims, boolean returnDelims, boolean favorLarger) {
      mTokens = new Vector();
      mIndex = 0;
      int startIndex = 0;
      int currIndex = 0;

      while (currIndex < str.length())
      {
        int curr = -1;
        for (int i = 0; i < delims.length; i++)
        {
          if (str.regionMatches(currIndex,delims[i],0,delims[i].length()))
            if (curr == -1)
              curr = i;
            else if (favorLarger && delims[curr].length() < delims[i].length())
              curr = i;
            else if (!favorLarger && delims[i].length() < delims[curr].length())
              curr = i;
        }
        if (curr != -1) // we found a token
        {
          String st = str.substring(startIndex,currIndex);
          currIndex += delims[curr].length()-1;
          startIndex = currIndex+1;
          mTokens.addElement(st);
          if (returnDelims)
            mTokens.addElement(delims[curr]);
        }
        else if (curr == -1 && currIndex+1 == str.length())
        {
          String st = str.substring(startIndex,str.length());
          mTokens.add(st);
          startIndex = currIndex+1;
        }
        currIndex++;
      }
    } // cons

    protected int hasDelim(String str, String[] delims)
    {
      int curr = -1;
      for (int i = 0; i < delims.length; i++)
        if (str.endsWith(delims[i]))
          if (curr == -1 || delims[curr].length() < delims[i].length())
            curr = i;
      return curr;
    } // hasDelim

    public Object nextElement()
    {
      return mTokens.elementAt(mIndex++);
    } // nextElement

    public boolean hasMoreElements()
    {
      return mIndex < mTokens.size();
    } // hasMoreElements()

    protected boolean isWhiteSpace(String str)
    {
      return (str.equals(" ") || str.equals("\n") || str.equals("\t") || str.equals("\r"));
    } // isWhiteSpace

    public String nextSkipWhiteSpace()
    {
      String currToken = nextToken();
      while (hasMoreTokens() && (currToken.length() == 0 || isWhiteSpace(currToken)))
        currToken = nextToken();
      return currToken.trim();
    } // nextSkipWhiteSpace

    public String next() { return nextToken(); }

    public int getIndex() { return mIndex; }
    public String nextToken() { return nextElement().toString(); }
    public boolean hasMoreTokens() { return hasMoreElements(); }
    public int countTokens() { return mTokens.size(); }
    public void pushBack(int num) { mIndex -= num; }
    public void reset() { mIndex = 0; }
}
