package org.eaglei.datatools.etl.utils;

/**
 * <p>Title: </p>
 *
 * <p>Description: </p>
 *
 * <p>Copyright: Copyright (c) 2005</p>
 *
 * <p>Company: MIndswap (http://www.mindswap.org)</p>
 *
 * @author Michael Grove
 * @version 1.0
 */
public class CodeTokenizer extends ByStringTokenizer
{
    private String mCommentStart;
    private String mCommentEnd;

    public CodeTokenizer(String str, String[] delims) {
        super(str,delims,true,true);
    }

    public CodeTokenizer(String str, String[] delims, boolean returnDelims) {
        super(str,delims,returnDelims,true);
    }

  public CodeTokenizer(String str, String[] delims, boolean returnDelims, boolean favorLarger) {
      super(str,delims,returnDelims,favorLarger);
  }

  public void setCommentStyle(String start, String end)
  {
      mCommentStart = start;
      mCommentEnd = end;
  }

  public String nextSkipWhiteSpace()
  {
      String currToken = nextToken();
      while (hasMoreTokens() && (currToken.length() == 0 || isWhiteSpace(currToken) || currToken.equals(mCommentStart)))
      {
          if (currToken.equals(mCommentStart))
              while (!currToken.equals(mCommentEnd))
                  currToken = nextToken();
          currToken = nextToken();
      }
      return currToken.trim();
  }
}
