package org.eaglei.datatools.etl.utils;

import java.util.StringTokenizer;
import java.util.Set;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Iterator;

import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Model;

import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.OWL;

/**
 * <p>Title: </p>
 *
 * <p>Description: </p>
 *
 * <p>Copyright: Copyright (c) 2005</p>
 *
 * <p>Company: MIndswap (http://www.mindswap.org)</p>
 *
 * @author Michael Grove
 * @version 1.0
 */
public class NewUtils {
    /**
     * Given a string of delimited integers, return an int array.<br><br>
     *
     * @param str     String of delimited integers
     * @param delims String of delimiters used in the list, for example: ",;:"
     * @return int array whose contents reflect the list of integers in the parameter str
     * @throws java.lang.NumberFormatException if the string contents elements other than integers in the list
     */
    public static int[] readDelimitedIntegers(String theString, String theDelims) throws NumberFormatException
    {
        int[] aIntList = null;
        if (theString == null || theString.equals(""))
            return new int[0];
        StringTokenizer toke = new StringTokenizer(theString,theDelims);
        while (toke.hasMoreTokens())
        {
            String num = toke.nextToken();
            int col = -1;
            try {
                if (num.indexOf("-") != -1)
                {
                    StringTokenizer st = new StringTokenizer(num,"-");
                    int startInt = Integer.parseInt(st.nextToken());
                    int endInt = Integer.parseInt(st.nextToken());
                    for (int i = startInt; i <= endInt; i++)
                        aIntList = addToIntArray(i,aIntList);
                }
                else
                {
                    col = Integer.parseInt(num);
                    aIntList = addToIntArray(col,aIntList);
                }
            }
            catch (NumberFormatException nfe) {
                System.out.println("Invalid format in exclude param.  Type \"int,int ... \" expected.");
                throw nfe;
            }
        }
        return aIntList;
    }

    /**
     * Removes an int to an int array.<br><br>
     *
     * @param elem     int to be removed
     * @param intList array to which elem will be removed
     * @return The array with the parameter removed.
     */
     public static int[] removeFromIntArray(int theElem, int[] theIntList)
     {
         int[] temp = null;
         if (theIntList == null || theIntList.length == 0)
         {
             temp = theIntList;
         }
         else if (theIntList.length == 1)
         {
             temp = new int[0];
         }
         else
         {
             boolean found = false;
             for (int i = 0; i < theIntList.length; i++)
             {
                 if (theIntList[i] == theElem) {
                     found = true;
                 }
             }

             if (!found)
                 temp = theIntList;
             else
             {
                 temp = new int[theIntList.length-1];
                 int aIndex = 0;

                 for (int i = 0; i < theIntList.length; i++)
                 {
                     if (theIntList[i] != theElem) {
                         temp[aIndex] = theIntList[i];
                         aIndex++;
                     }
                 }
             }
         }
         return temp;
     }

    /**
     * Adds an int to an int array.<br><br>
     *
     * @param elem     int to be added
     * @param intList array to which elem will be added
     * @return The array with the parameter added to the end.
     */
     public static int[] addToIntArray(int theElem, int[] theIntList)
     {
         int[] temp = null;
         if (theIntList == null)
         {
             temp = new int[1];
             temp[0] = theElem;
         }
         else
         {
             temp = new int[theIntList.length+1];
             System.arraycopy(theIntList,0,temp,0,theIntList.length);
             temp[theIntList.length] = theElem;
         }
         return temp;
     }

     /**
      * Returns true or false depending on whether or not the specified string is in the array.<br><br>
      *
      * @param theElem     int to search for
      * @param theArray    int array to search through
      * @return true if elem is in array, false otherwise
      */
     public static boolean isInArray(int theElem, int[] theArray)
     {
         if (theArray == null)
             return false;
         for (int i = 0; i < theArray.length; i++)
             if (theArray[i] == theElem)
                 return true;
         return false;
     } // isInArray

     /**
      * Given a string, replace all occurances of one string with another.<br><br>
      *
      * @param host     parent string
      * @param oldchar  String to remove
      * @param newchar  String to insert in the place of oldchar in the String host
      * @return copy of host with all occurances of param oldchar replaced with param newchar
      */
     public static String replace(String theHost, String theOldString, String theNewString)
     {
         int index = 0;
         while (theHost.indexOf(theOldString,index) != -1) // diff, no index
         {
             index = theHost.indexOf(theOldString,index);
             theHost = theHost.substring(0,index)+theNewString+theHost.substring(index+theOldString.length(),theHost.length());
             index += theNewString.length(); // diff absent
         }
         return theHost;
     } // replace

     public static Iterator listClasses(Model theModel) {
         Set classes = new HashSet();
         ResIterator rIter = theModel.listSubjects();
         while (rIter.hasNext())
         {
             Resource aRes = (Resource)rIter.next();

             if (aRes.isAnon() || JenaUtils.isLanguageTerm(aRes))
                 continue;

             Set aTypes = JenaUtils.getTypes(aRes,false);
             if (aTypes.contains(RDFS.Class) || aTypes.contains(OWL.Class)) {
                 classes.add(aRes);
             }
         }
         rIter.close();

         return classes.iterator();
     }

     public static Iterator listProperties(Model theModel) {
         Set classes = new HashSet();
         ResIterator rIter = theModel.listSubjects();
         while (rIter.hasNext())
         {
             Resource aRes = (Resource)rIter.next();

             if (aRes.isAnon() || JenaUtils.isLanguageTerm(aRes))
                 continue;

             Set aTypes = JenaUtils.getTypes(aRes,false);
             if (aTypes.contains(RDF.Property) || aTypes.contains(OWL.DatatypeProperty) || aTypes.contains(OWL.ObjectProperty)) {
                 classes.add(aRes);
             }
         }
         rIter.close();

         return classes.iterator();
     }

     public static Set collectResourcesFromRDFList(Resource theList)
     {
         LinkedHashSet aSet = new LinkedHashSet();
//        if (theList.canAs(Seq.class))
//        {
//            Seq aSeq = (Seq)theList.as(Seq.class);
//            NodeIterator nIter = aSeq.iterator();
//            while (nIter.hasNext())
//                aSet.add(nIter.next());
//            nIter.close();
//        }
//        else
         {
             // TODO try casting it as a rdf:Bag??
             Resource rest, first;
             rest = first = null;
             rest = theList;

             if (rest == null || !rest.hasProperty(RDF.first)) // empty list
                 return aSet;

             do {
                  first = rest.getProperty(RDF.first).getResource();
                  rest = rest.getProperty(RDF.rest).getResource();
                  aSet.add(first);
             }
             while (!rest.equals(RDF.nil));
         }
         return aSet;
     }
}
