// The MIT License
//
// Copyright (c) 2005 Michael Grove
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
// IN THE SOFTWARE.

package org.eaglei.datatools.etl.utils;

/**
 *
 * <p>Title: Pair</p>
 *
 * <p>Description: A pair of objects</p>
 *
 * <p>Copyright: Copyright (c) 2006</p>
 *
 * <p>Company: Mindswap (http://www.mindswap.org)</p>
 *
 * @author Michael Grove
 * @version 1.0
 */
public class Pair {
    public Object mFirst;
    public Object mSecond;

    public Pair(Object f, Object s)
    {
        mFirst = f;
        mSecond = s;
    } // cons

    /**
     * Returns the string representation of this pair, which is equivalent to the toString() function
     * on the first element
     * @return String
     */
    public String toString() { return mFirst.toString(); }

    /**
     * Determines if two Pair's are equal, both objects in the pair must be equivalent for two pairs to be equal
     * @param obj Object the object to compare to
     * @return boolean true if they are equal, false if not
     */
    public boolean equals(Object obj) {
        if (obj instanceof Pair)
        {
            Pair p = (Pair)obj;
            return p.mFirst.equals(mFirst) && p.mSecond.equals(mSecond);
        }
        else return false;
    }
}
