// The MIT License
//
// Copyright (c) 2005 Michael Grove
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
// IN THE SOFTWARE.

package org.eaglei.datatools.etl.utils;

import java.util.Comparator;

import com.hp.hpl.jena.rdf.model.Resource;

import com.hp.hpl.jena.vocabulary.RDFS;

/**
 *
 * <p>Title: ResourceComparator</p>
 *
 * <p>Description: A comparator for sorting a collection of jena resources by their labe and/or their friendly name.</p>
 *
 * <p>Copyright: Copyright (c) 2004</p>
 *
 * <p>Company: Mindswap (http://www.mindswap.org)</p>
 *
 * @author Michael Grove
 * @version 1.0
 */
public class ResourceComparator implements Comparator {

    public int compare(Object a, Object b) {
        if (a!=null) {
            if(b!=null) {
                /*
                   TODO: should also take into account whether or not to use
                   the label of the resource etc.
                 */
                if (a instanceof Resource && b instanceof Resource)
                {
                    Resource res1 = (Resource)a;
                    Resource res2 = (Resource)b;

                    String one = null;
                    String two = null;

                    if (res1.isAnon())
                    {
                        if (res1.hasProperty(RDFS.label))
                            one = JenaUtils.getLabel(res1).toLowerCase();
                        else return +1;
                    }
                    else {
                        if (res1.hasProperty(RDFS.label))
                            one = JenaUtils.getLabel(res1).toLowerCase();
                        else one = res1.getLocalName().toLowerCase();
                    }

                    if (res2.isAnon())
                    {
                        if (res2.hasProperty(RDFS.label))
                            two = JenaUtils.getLabel(res2).toLowerCase();
                        else return -1;
                    }
                    else {
                        if (res2.hasProperty(RDFS.label))
                            two = JenaUtils.getLabel(res2).toLowerCase();
                        else two = res2.getLocalName().toLowerCase();
                    }

                    return one.compareTo(two);
                }
                else return 0;
            } else {
                return +1;
            }
        } else {
            return -1;
        }

    }
}
