// The MIT License
//
// Copyright (c) 2005 Michael Grove
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
// IN THE SOFTWARE.

package org.eaglei.datatools.etl.utils;

import java.net.Authenticator;
import java.net.PasswordAuthentication;

/**
 * <p>Title: StaticAuthenticator</p>
 * <p>Description: An authenticator which does not prompt the user for user/pw information, but has them statically set.  This is used to gain access to protected resources over HTTP.</p>
 * <p>Copyright: Copyright (c) 2005</p>
 * <p>Company: Mindswap (http://www.mindswap.org)</p>
 * @author Michael Grove
 * @version 1.0
 */
public class StaticAuthenticator extends Authenticator {
    private String mUser;
    private String mPassword;

    /**
     * Create a new StaticAuthenticator with the specified user and password
     * @param username String
     * @param password String
     */
    public StaticAuthenticator(String username, String password) {
        mUser = username;
        mPassword = password;
    }

    protected PasswordAuthentication getPasswordAuthentication() {
        return new PasswordAuthentication(mUser, mPassword.toCharArray());
    }

    /**
     * Returns the user name for this Authenticator
     * @return String the user name
     */
    public String getUser() {
        return mUser;
    }

    /**
     * Returns the password for this Authenticator
     * @return String the password
     */
    public String getPassword() {
        return mPassword;
    }
}
