package org.eaglei.datatools.jena;

import static org.eaglei.datatools.model.DataToolsOntConstants.DC_URI;
import static org.eaglei.datatools.model.DataToolsOntConstants.RDFS_URI;
import static org.eaglei.datatools.model.DataToolsOntConstants.RDF_URI;

import java.io.IOException;
import java.io.StringWriter;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIURI;
import org.eaglei.model.jena.JenaEIOntModel;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;

/**
 * 
 * @author Ricardo De Lima
 * 
 *         May 12, 2010
 * 
 *         Center for Biomedical Informatics (CBMI)
 * @link https://cbmi.med.harvard.edu/
 * 
 * 
 */

//TODO: this class remains to be refactored
// we essentially need to provide a SPARQL and a EIInstance view of the queries so
// this may change in the future and we can keep the SPARQL queries and move the actual querying to
// each RepoProvider 

public class SPARQLQueryUtil {
    
    private static final Log logger = LogFactory.getLog(MemoryRepositoryProvider.class);

    
    private static SPARQLQueryUtil instance;
    
    private SPARQLQueryUtil() {
        
    }
    
    public static SPARQLQueryUtil getInstance() {
        if(instance == null) {
           instance = new SPARQLQueryUtil();
        }
        return instance;
     }

    
    /**
     * Returns the a sparql query that asks the repo for the URI of a resource of type rootURI with a label 
     * @param rootURI
     * @param label
     * @return the SPARQL query string
     */
    
    
    public String getEIResourcesByLabelQuery(final EIURI rootURI, final String label) {
    	final StringBuilder sparql = new StringBuilder();
    	sparql.append("PREFIX rdf: <");
        sparql.append(RDF_URI);
        sparql.append("> ");
        sparql.append("PREFIX rdfs: <");
        sparql.append(RDFS_URI);
        sparql.append("> ");
        sparql.append("SELECT ?resource WHERE {?resource rdf:type <");
        sparql.append(rootURI.toString());
        sparql.append("> . ");
        sparql.append("?resource rdfs:label ?o ");
        //Ignore case
        sparql.append("FILTER regex(str(?o), \"" + label + "\", \"i\").}");
    	return sparql.toString();
    	
    	//The query should be (substitute type and label but keep <> and "" )
    	//SELECT ?resource  WHERE { ?resource a <type> . ?resource rdfs:label ?o FILTER regex(?o, "label", "i").}
    	
    }
    
    
    /*
     * returns the SPARQL query
     */

    //TODO rename getEIResourcesForUserQuery
    //TODO convert to construct query
    public String getAllEIResourcesForUserQuery(final String user) {
        
        final List<EIClass> eiClasses = JenaEIOntModel.INSTANCE.getTopLevelClasses();
        final StringBuilder sparql = new StringBuilder();
        // sparql.append("PREFIX eagle-i: <");
        // sparql.append(EAGLE_I_URI);
        // sparql.append("> ");
        sparql.append("PREFIX rdf: <");
        sparql.append(RDF_URI);
        sparql.append("> ");
        sparql.append("PREFIX dc: <");
        sparql.append(DC_URI);
        sparql.append("> ");
        sparql.append("PREFIX rdfs: <");
        sparql.append(RDFS_URI);
        sparql.append("> ");
        sparql.append("CONSTRUCT {?resource ?p ?o} WHERE {");
        for(final EIClass eic : eiClasses)
        {
            sparql.append("{?resource a <");
            sparql.append(eic.getEntity().getURI().toString());
            sparql.append("> .?resource ?p ?o .} ");
            // Don't do this for the last element
            if(eiClasses.indexOf(eic) != eiClasses.size() - 1)
            {
                sparql.append("UNION ");
            }
        }
        sparql.append("}");
        return sparql.toString();
    }
    
    public List<EIInstance> getAllEIResourcesForUser(final String user, final Model m)
    {

        return query(getAllEIResourcesForUserQuery(user), m);
    }

    
    /*
     * returns the SPARQL query
     */
    
    //TODO Need to change this name, it is confusing
    //rename to getEIResourcesOfClassForUserQuery or something shorter ;-)
    /**
     * @param user
     * @param classUri
     * @return
     */
    /*public String getUserInstancesQuery(final String user, final EIURI classUri)
    {

        final StringBuilder sparql = new StringBuilder();
        // sparql.append("PREFIX eagle-i: <");
        // sparql.append(EAGLE_I_URI);
        // sparql.append("> ");
        sparql.append("PREFIX rdf: <");
        sparql.append(RDF_URI);
        sparql.append("> ");
        sparql.append("PREFIX dc: <");
        sparql.append(DC_URI);
        sparql.append("> ");
        sparql.append("PREFIX rdfs: <");
        sparql.append(RDFS_URI);
        sparql.append("> ");
        sparql.append("SELECT * WHERE {?resource rdf:type <");
        sparql.append(classUri.toString());
        sparql.append("> . ");
        sparql.append("?resource ?p ?o .}");
        return sparql.toString();
    }*/
 
    public String getUserInstancesQuery(final String user, final EIURI classUri)
    {
    	//TODO add user in parameters

        final StringBuilder sparql = new StringBuilder();
        // sparql.append("PREFIX eagle-i: <");
        // sparql.append(EAGLE_I_URI);
        // sparql.append("> ");
        sparql.append("PREFIX rdf: <");
        sparql.append(RDF_URI);
        sparql.append("> ");
        sparql.append("PREFIX dc: <");
        sparql.append(DC_URI);
        sparql.append("> ");
        sparql.append("PREFIX rdfs: <");
        sparql.append(RDFS_URI);
        sparql.append("> ");
        sparql.append("CONSTRUCT {$resource rdf:type <");
        sparql.append(classUri.toString());
        sparql.append("> . ?resource ?p ?o .} WHERE {$resource rdf:type <");
        sparql.append(classUri.toString());
        sparql.append("> . ?resource ?p ?o .}");
        return sparql.toString();
    }
    
    public List<EIInstance> getUserInstances(final String user, final EIURI classUri, final Model m)
    {
        return query(getUserInstancesQuery(user,classUri), m);
    }
    
    
    
    
    public List<EIInstance> query(final String sparql, final Model m)
    {
        // FIXME this needs to be refactored as it will fail silently when the
        // query doesn't contain same variable names
        //logger.debug("Query is: " + sparql);
        final Query query = QueryFactory.create(sparql.toString());

        // Execute the query and obtain results
        final QueryExecution qe = QueryExecutionFactory.create(query, m);
        final ResultSet results = qe.execSelect();
        // ResultSetFormatter.out(System.out, results);
        final List<QuerySolution> resultList = ResultSetFormatter.toList(results);
        qe.close();

        // Iterate over result set to turn it into RDF
        final Model resultModel = ModelFactory.createDefaultModel();
        for(final QuerySolution q : resultList)
        {
            final Resource instanceResource = q.getResource("resource");
            final Resource p = q.getResource("p");
            final RDFNode object = q.get("o");
            final Property predicate = resultModel.createProperty(p.getURI());
            resultModel.add(resultModel.createStatement(instanceResource, predicate, object));
        }

        return EIInstanceFactory.INSTANCE.create(resultModel);
    }
    
    
    public String serializeQuery(final String sparql, final Model m)
    {
        // FIXME this needs to be refactored as it will fail silently when the
        // query doesn't contain same variable names
        logger.debug("Query is: " + sparql);
        final Query query = QueryFactory.create(sparql.toString());

        // Execute the query and obtain results
        final QueryExecution qe = QueryExecutionFactory.create(query, m);
        final ResultSet results = qe.execSelect();
        // ResultSetFormatter.out(System.out, results);
        final List<QuerySolution> resultList = ResultSetFormatter.toList(results);
        qe.close();

        // Iterate over result set to turn it into RDF
        final Model resultModel = ModelFactory.createDefaultModel();
        for(final QuerySolution q : resultList)
        {
            final Resource instanceResource = q.getResource("resource");
            final Resource p = q.getResource("p");
            final RDFNode object = q.get("o");
            final Property predicate = resultModel.createProperty(p.getURI());
            resultModel.add(resultModel.createStatement(instanceResource, predicate, object));
        }

        
        // write the model to StringBuffer
        
        
        StringWriter sw = new StringWriter();
        try {
            //TODO validate format
            resultModel.write(sw);
            String s = sw.toString();
            sw.flush();
            return s;
        } finally {
            try {if(sw != null) sw.close(); } catch (IOException e){logger.error("Error serializeQuery: " + e);}
        }     
        
        
        
    }
    
    
}
