package org.eaglei.datatools.provider;

import java.util.List;

import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIURI;


public interface RepositoryProvider  {

    /*
     * EIInstance functionality
     */

    public List<EIInstance> getUserInstances(String rnav, EIURI classUri)throws Exception;
    public List<EIInstance> getAllEIResourcesForUser(String rnav) throws Exception; 
    
    // CRUD, etc
    public List<EIURI> getNewInstanceID(int count) throws Exception;
    public EIInstance getEmptyEIInstance(EIURI classUri, EIEntity instanceEntity) throws Exception;
    
    public EIInstance getInstance(EIURI instanceID) throws Exception;
    public String updateInstance(EIInstance instance, String token) throws Exception;
    public void createInstance(EIInstance instance) throws Exception;
    public void deleteInstance(EIInstance instance) throws Exception;
 
    /*
     * Bulk upload
     */
    
    public void uploadInstances(String rdf) throws Exception;
    
    /*
     *  free from SPARQL query to this provider
     */
    
    public String query(String sparql) throws Exception;
    
    /*
    * login/logout etc
    */
    
   public String[] login(String user, String password) throws Exception;    
   public void logout() throws Exception;
   public String whoami() throws Exception;
   public boolean isOnline();
   
   


}
