/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.etl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.eaglei.datatools.etl.MappingsFactory;
import org.eaglei.datatools.excel.ExcelUtils;
import org.eaglei.datatools.interim.cores.Cores3Mappings;
import org.eaglei.datatools.interim.cores.Mapping;

public class Cores3ExcelParser {
    private List<ProcessedTab> processedTabs = new ArrayList<ProcessedTab>();

    public Cores3ExcelParser(String fileName) throws ConfigurationException {
        Workbook wb = ExcelUtils.openWorkBook(fileName);
        Map<String, Mapping> configMap = MappingsFactory.createMappings("Cores3").getMappings();
        int n = wb.getNumberOfSheets();
        Sheet sheet = wb.getSheetAt(0);
        if (Cores3Mappings.FIRST_ROWS.get("INSTRUMENT") != null) {
            int firstRow = Cores3Mappings.FIRST_ROWS.get("INSTRUMENT");
            Mapping classMapping = configMap.get("INSTRUMENT");
            List<Map<String, String>> list = ExcelUtils.processTab(sheet, sheet.getLastRowNum());
            this.processedTabs.add(new ProcessedTab(classMapping, list));
        }
    }

    public List<ProcessedTab> getProcessedTabs() {
        return this.processedTabs;
    }

    public class ProcessedTab {
        private Mapping classMapping;
        private List<Map<String, String>> tabData;

        public ProcessedTab(Mapping classMapping, List<Map<String, String>> tabData) {
            this.classMapping = classMapping;
            this.tabData = tabData;
        }

        public Mapping getClassMapping() {
            return this.classMapping;
        }

        public List<Map<String, String>> getTabData() {
            return this.tabData;
        }
    }
}

