/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.etl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.configuration.reloading.FileChangedReloadingStrategy;
import org.apache.commons.configuration.reloading.ReloadingStrategy;
import org.apache.commons.configuration.tree.ExpressionEngine;
import org.apache.commons.configuration.tree.xpath.XPathExpressionEngine;
import org.eaglei.datatools.interim.cores.Mapping;

public abstract class Mappings {
    public Map<String, Mapping> getMappings(String path) throws ConfigurationException {
        XMLConfiguration config = new XMLConfiguration(path);
        config.setReloadingStrategy((ReloadingStrategy)new FileChangedReloadingStrategy());
        config.setExpressionEngine((ExpressionEngine)new XPathExpressionEngine());
        HashMap<String, Mapping> mappingMap = new HashMap<String, Mapping>();
        List classConfigLst = config.configurationsAt("/mapping");
        for (HierarchicalConfiguration classConfig : classConfigLst) {
            String className = classConfig.getString("//@identifier");
            Mapping classMapping = new Mapping(Mapping.MappingType.CLASS, Mapping.SourceType.TAB, className, classConfig.getString("//@targetrdfNamespace"), classConfig.getString("//@targetidentifier"));
            List hirConfig = classConfig.configurationsAt("//propertymapping");
            for (HierarchicalConfiguration columnConfig : hirConfig) {
                classMapping.addMapping(columnConfig.getString("//@identifier"), columnConfig.getString("//@targetrdfNamespace"), columnConfig.getString("//@targetidentifier"));
            }
            mappingMap.put(className, classMapping);
        }
        return mappingMap;
    }

    public abstract Map<String, Mapping> getMappings() throws ConfigurationException;
}

