/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.etl.server;

import java.io.File;
import java.net.URL;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.datatools.config.DatatoolsConfiguration;
import org.eaglei.datatools.jena.RESTRepositoryProviderFactory;
import org.eaglei.datatools.provider.RepositoryProvider;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIURI;

public class RDFtoRepoService {
    private static RDFtoRepoService instance = null;
    private DatatoolsConfiguration config = this.getConfiguration();
    RepositoryProvider repoProvider = new RESTRepositoryProviderFactory().createRepositoryProvider(this.config);
    private static final String DEFAULT_CONFIGURATION = "etl-datatools.prop";
    private static final Log logger = LogFactory.getLog(RDFtoRepoService.class);

    private RDFtoRepoService() throws Exception {
    }

    public RepositoryProvider getRepositoryProvider() {
        return this.repoProvider;
    }

    public DatatoolsConfiguration getDatatoolsConfiguration() {
        return this.config;
    }

    public static RDFtoRepoService getInstance() throws Exception {
        if (instance == null) {
            instance = new RDFtoRepoService();
        }
        return instance;
    }

    public boolean pushtoRepo(String rdfString) throws Exception {
        this.repoProvider.uploadInstances(rdfString);
        return true;
    }

    public List<EIURI> getNewInstancesFromRepo(int countofInstances) throws Exception {
        return this.repoProvider.getNewInstanceID(countofInstances);
    }

    private DatatoolsConfiguration getConfiguration() throws Exception {
        URL configURL = this.getClass().getClassLoader().getResource(DEFAULT_CONFIGURATION);
        if (configURL == null) {
            logger.error((Object)"Could not locate etl-datatools.prop on classpath");
            throw new Exception("Could not locate etl-datatools.prop on classpath");
        }
        try {
            File configFile = new File(configURL.toURI());
            logger.debug((Object)("loading configuration file: " + configFile));
            return new DatatoolsConfiguration(configFile);
        }
        catch (Exception e) {
            logger.error((Object)("Error loading configuration from " + configURL + " " + e));
            throw new Exception(e);
        }
    }

    public void deleteRepo() throws Exception {
        logger.debug((Object)"Deleting an instance:http://dev.alaska.eagle-i.net/i/*");
        EIURI euuri = EIURI.create((String)"http://dev.alaska.eagle-i.net/i/*");
        EIInstance temp_ei = this.repoProvider.getInstance(euuri);
        this.repoProvider.deleteInstance(temp_ei);
        logger.debug((Object)"delete succeeded");
    }
}

