/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.etl.server;

import java.util.Map;
import javax.swing.table.DefaultTableModel;

public class Rdf123Expression {
    private String expression;
    private int curIndex;
    private int nextIndex;
    private String token;
    private String lookAhead;
    private String outdate;
    private String output;
    DefaultTableModel tableModel;
    int row;
    private Map prefixMap = null;
    int startCol;
    private String baseURI;
    private static boolean error_tolerate = false;

    public Rdf123Expression(DefaultTableModel model, Map map, int startColumn, String base) {
        this.tableModel = model;
        this.prefixMap = map;
        this.startCol = startColumn;
        this.baseURI = base;
    }

    public String nextToken() {
        if (this.curIndex >= this.expression.length()) {
            return "EOF";
        }
        if (this.expression.charAt(this.curIndex) == '\'') {
            this.nextIndex = this.expression.indexOf(39, this.curIndex + 1);
            if (this.nextIndex != -1) {
                this.token = this.expression.substring(this.curIndex, this.nextIndex + 1);
                this.curIndex = this.nextIndex + 1;
                return this.token;
            }
            this.token = this.expression.substring(this.curIndex);
            this.curIndex = this.expression.length();
            return this.token;
        }
        if (this.expression.charAt(this.curIndex) == '<' && this.expression.charAt(this.curIndex + 1) == '>') {
            this.curIndex += 2;
            return "<>";
        }
        if (this.expression.charAt(this.curIndex) == '!' && this.expression.charAt(this.curIndex + 1) == '=') {
            this.curIndex += 2;
            return "!=";
        }
        if (this.expression.charAt(this.curIndex) == '?') {
            ++this.curIndex;
            return "?";
        }
        if (this.expression.charAt(this.curIndex) == '@') {
            if (this.expression.substring(this.curIndex).startsWith("@If(")) {
                this.curIndex += 4;
                return "@If(";
            }
            if (this.expression.substring(this.curIndex).startsWith("@IsEmpty(")) {
                this.curIndex += 9;
                return "@IsEmpty(";
            }
            if (this.expression.substring(this.curIndex).startsWith("@Add(")) {
                this.curIndex += 5;
                return "@Add(";
            }
            if (this.expression.substring(this.curIndex).startsWith("@Sub(")) {
                this.curIndex += 5;
                return "@Sub(";
            }
            if (this.expression.substring(this.curIndex).startsWith("@Length(")) {
                this.curIndex += 8;
                return "@Length(";
            }
            if (this.expression.substring(this.curIndex).startsWith("@IndexOf(")) {
                this.curIndex += 9;
                return "@IndexOf(";
            }
            if (this.expression.substring(this.curIndex).startsWith("@Substr(")) {
                this.curIndex += 8;
                return "@Substr(";
            }
            int next = this.indexOfNextToken(this.curIndex + 1);
            String token = this.expression.substring(this.curIndex, next);
            this.curIndex = next;
            return token;
        }
        if (this.expression.charAt(this.curIndex) == ')') {
            ++this.curIndex;
            return ")";
        }
        if (this.expression.charAt(this.curIndex) == ';') {
            ++this.curIndex;
            return ";";
        }
        if (this.expression.charAt(this.curIndex) == ',') {
            ++this.curIndex;
            return ",";
        }
        if (this.expression.charAt(this.curIndex) == '+') {
            ++this.curIndex;
            return "+";
        }
        if (this.expression.charAt(this.curIndex) == ' ') {
            ++this.curIndex;
            return " ";
        }
        if (this.expression.charAt(this.curIndex) == '(') {
            ++this.curIndex;
            return "(";
        }
        if (this.expression.charAt(this.curIndex) == '=') {
            ++this.curIndex;
            return "=";
        }
        this.nextIndex = this.curIndex;
        while (this.nextIndex < this.expression.length() && this.expression.charAt(this.nextIndex) != '@' && this.expression.charAt(this.nextIndex) != ')' && this.expression.charAt(this.nextIndex) != '(' && this.expression.charAt(this.nextIndex) != ';' && this.expression.charAt(this.nextIndex) != ',' && this.expression.charAt(this.nextIndex) != '+' && this.expression.charAt(this.nextIndex) != '<' && this.expression.charAt(this.nextIndex) != '?' && this.expression.charAt(this.nextIndex) != '=' && this.expression.charAt(this.nextIndex) != '!' && this.expression.charAt(this.nextIndex) != ' ' && this.expression.charAt(this.nextIndex) != '\'') {
            ++this.nextIndex;
        }
        this.token = this.expression.substring(this.curIndex, this.nextIndex);
        this.curIndex = this.nextIndex;
        return this.token;
    }

    private int indexOfNextToken(int current) {
        int next;
        for (next = current; next < this.expression.length() && this.expression.charAt(next) != '@' && this.expression.charAt(next) != ')' && this.expression.charAt(next) != '(' && this.expression.charAt(next) != ';' && this.expression.charAt(next) != ',' && this.expression.charAt(next) != '+' && this.expression.charAt(next) != '<' && this.expression.charAt(next) != '?' && this.expression.charAt(next) != '=' && this.expression.charAt(next) != '!' && this.expression.charAt(next) != ' ' && this.expression.charAt(next) != '\''; ++next) {
        }
        return next;
    }

    private void match(String t) throws Exception {
        if (!this.lookAhead.equals(t)) {
            throw new Exception("Parse error found at index " + this.curIndex + " :    '" + this.lookAhead + "' is not expected in the expression " + this.expression.substring(0, this.curIndex - this.lookAhead.length()) + "<font color=red><u>" + this.lookAhead + "</u></font>" + this.expression.substring(this.curIndex));
        }
        this.lookAhead = this.nextToken();
        this.output = this.output + this.lookAhead;
    }

    public String evaluate(String formula, int r) throws Exception {
        this.expression = formula.endsWith("_") ? formula.substring(0, formula.length() - 1) : formula;
        this.row = r;
        this.curIndex = 0;
        this.output = "";
        this.lookAhead = this.nextToken();
        this.output = this.output + this.lookAhead;
        String exp = this.E(false);
        if (!this.lookAhead.equals("EOF")) {
            throw new Exception("Parse error found at index " + this.curIndex + " :    '" + this.lookAhead + "' is not expected in the expression " + this.expression.substring(0, this.curIndex - this.lookAhead.length()) + "<font color=red><u>" + this.lookAhead + "</u></font>" + this.expression.substring(this.curIndex));
        }
        if (exp.trim().equals("")) {
            return null;
        }
        return exp;
    }

    private String E(boolean parseOnly) throws Exception {
        String tExp = this.T(parseOnly);
        String e2Exp = this.E2(parseOnly);
        return tExp + e2Exp;
    }

    private String E2(boolean parseOnly) throws Exception {
        if (this.lookAhead.equals("+")) {
            this.match("+");
            String tExp = this.T(parseOnly);
            String e2Exp = this.E2(parseOnly);
            return tExp + e2Exp;
        }
        return "";
    }

    private String T(boolean parseOnly) throws Exception {
        if (this.lookAhead.equals("@If(")) {
            this.match("@If(");
            boolean test = this.B(parseOnly);
            this.match(";");
            String thenE = test ? this.E(parseOnly) : this.E(true);
            this.match(";");
            String elseE = test ? this.E(true) : this.E(parseOnly);
            this.match(")");
            if (test) {
                return thenE;
            }
            return elseE;
        }
        return this.S(parseOnly);
    }

    private boolean B(boolean parseOnly) throws Exception {
        if (this.lookAhead.equals("@IsEmpty(")) {
            this.match("@IsEmpty(");
            String value = this.E(parseOnly);
            this.match(")");
            return value.trim().equals("");
        }
        String leftE = this.E(parseOnly);
        if (this.lookAhead.equals("=")) {
            this.match("=");
            String rightE = this.E(parseOnly);
            try {
                float leftFloat = Float.parseFloat(leftE);
                float rightFloat = Float.parseFloat(rightE);
                return leftFloat == rightFloat;
            }
            catch (NumberFormatException e) {
                return leftE.trim().equals(rightE.trim());
            }
        }
        this.match("!=");
        String rightE = this.E(parseOnly);
        try {
            float leftFloat = Float.parseFloat(leftE);
            float rightFloat = Float.parseFloat(rightE);
            return leftFloat != rightFloat;
        }
        catch (NumberFormatException e) {
            return !leftE.trim().equals(rightE.trim());
        }
    }

    private String S(boolean parseOnly) throws Exception {
        if (this.lookAhead.startsWith("'") && this.lookAhead.endsWith("'")) {
            this.outdate = this.lookAhead;
            this.match(this.lookAhead);
            if (parseOnly) {
                return "";
            }
            return this.outdate.substring(1, this.outdate.length() - 1);
        }
        if (this.lookAhead.matches("\\$[0-9]+")) {
            this.outdate = this.lookAhead;
            this.match(this.lookAhead);
            if (parseOnly) {
                return "";
            }
            int col = Integer.valueOf(this.outdate.substring(1));
            if (col != 0) {
                try {
                    String cell = (String)this.tableModel.getValueAt(this.row, 0 + col - 1);
                    if (cell == null) {
                        cell = "";
                    }
                    return cell.trim();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new Exception("Access error: the cell " + this.outdate + " is out of bound in the expression " + this.expression);
                }
            }
            return String.valueOf(this.row);
        }
        if (this.lookAhead.equals("<>")) {
            this.match(this.lookAhead);
            if (parseOnly) {
                return "";
            }
            return this.baseURI;
        }
        if (this.lookAhead.equals("?")) {
            this.match(this.lookAhead);
            if (parseOnly) {
                return "";
            }
            return this.baseURI;
        }
        if (this.lookAhead.equals("@Add(")) {
            int beginIndex = this.curIndex;
            this.match(this.lookAhead);
            String leftE = this.E(parseOnly);
            this.match(",");
            String rightE = this.E(parseOnly);
            this.match(")");
            int endIndex = this.curIndex;
            if (parseOnly) {
                return "";
            }
            try {
                try {
                    int leftInt = Integer.parseInt(leftE);
                    int rightInt = Integer.parseInt(rightE);
                    return String.valueOf(leftInt + rightInt);
                }
                catch (NumberFormatException e) {
                    float leftFloat = Float.parseFloat(leftE);
                    float rightFloat = Float.parseFloat(rightE);
                    return String.valueOf(leftFloat + rightFloat);
                }
            }
            catch (Exception e) {
                if (error_tolerate) {
                    return "";
                }
                if (this.lookAhead.equals("EOF")) {
                    ++endIndex;
                }
                throw new Exception("Compute Error at row " + (this.row + 1) + ": " + " in the expression " + this.expression.substring(0, beginIndex - 1) + "<font color=red><u>" + this.expression.substring(beginIndex - 1, endIndex - 1) + "</u></font>" + this.expression.substring(endIndex - 1) + " with an error message --- " + e.toString());
            }
        }
        if (this.lookAhead.equals("@Sub(")) {
            int beginIndex = this.curIndex;
            this.match(this.lookAhead);
            String leftE = this.E(parseOnly);
            this.match(",");
            String rightE = this.E(parseOnly);
            this.match(")");
            int endIndex = this.curIndex;
            if (parseOnly) {
                return "";
            }
            try {
                try {
                    int leftInt = Integer.parseInt(leftE);
                    int rightInt = Integer.parseInt(rightE);
                    return String.valueOf(leftInt - rightInt);
                }
                catch (NumberFormatException e) {
                    float leftFloat = Float.parseFloat(leftE);
                    float rightFloat = Float.parseFloat(rightE);
                    return String.valueOf(leftFloat - rightFloat);
                }
            }
            catch (Exception e) {
                if (error_tolerate) {
                    return "";
                }
                if (this.lookAhead.equals("EOF")) {
                    ++endIndex;
                }
                throw new Exception("Compute Error at row " + (this.row + 1) + ": " + " in the expression " + this.expression.substring(0, beginIndex - 1) + "<font color=red><u>" + this.expression.substring(beginIndex - 1, endIndex - 1) + "</u></font>" + this.expression.substring(endIndex - 1) + " with an error message --- " + e.toString());
            }
        }
        if (this.lookAhead.equals("@Length(")) {
            this.match(this.lookAhead);
            String Exp = this.E(parseOnly);
            this.match(")");
            if (parseOnly) {
                return "";
            }
            return String.valueOf(Exp.length());
        }
        if (this.lookAhead.equals("@IndexOf(")) {
            this.match(this.lookAhead);
            String leftE = this.E(parseOnly);
            this.match(",");
            String rightE = this.E(parseOnly);
            this.match(")");
            if (parseOnly) {
                return "";
            }
            return String.valueOf(leftE.indexOf(rightE));
        }
        if (this.lookAhead.equals("@Substr(")) {
            int beginIndex = this.curIndex;
            this.match(this.lookAhead);
            String leftE = this.E(parseOnly);
            this.match(",");
            String midE = this.E(parseOnly);
            if (this.lookAhead.equals(",")) {
                this.match(",");
                String rightE = this.E(parseOnly);
                this.match(")");
                int endIndex = this.curIndex;
                if (parseOnly) {
                    return "";
                }
                try {
                    int begin = Integer.parseInt(midE);
                    int end = Integer.parseInt(rightE);
                    return leftE.substring(begin, end);
                }
                catch (Exception e) {
                    if (error_tolerate) {
                        return "";
                    }
                    if (this.lookAhead.equals("EOF")) {
                        ++endIndex;
                    }
                    throw new Exception("Compute Error at row " + (this.row + 1) + ": " + " in the expression " + this.expression.substring(0, beginIndex - 1) + "<font color=red><u>" + this.expression.substring(beginIndex - 1, endIndex - 1) + "</u></font>" + this.expression.substring(endIndex - 1) + " with an error message --- " + e.toString());
                }
            }
            this.match(")");
            int endIndex = this.curIndex;
            if (parseOnly) {
                return "";
            }
            try {
                int begin = Integer.parseInt(midE);
                return leftE.substring(begin);
            }
            catch (Exception e) {
                if (error_tolerate) {
                    return "";
                }
                if (this.lookAhead.equals("EOF")) {
                    ++endIndex;
                }
                throw new Exception("Compute Error at row " + (this.row + 1) + ": " + " in the expression " + this.expression.substring(0, beginIndex - 1) + "<font color=red><u>" + this.expression.substring(beginIndex - 1, endIndex - 1) + "</u></font>" + this.expression.substring(endIndex - 1) + " with an error message --- " + e.toString());
            }
        }
        if (this.lookAhead.matches("[A-Za-z0-9._]+")) {
            this.outdate = this.lookAhead;
            this.match(this.lookAhead);
            if (parseOnly) {
                return "";
            }
            String expend = (String)this.prefixMap.get(this.outdate);
            if (expend != null) {
                return expend;
            }
            return this.outdate;
        }
        throw new Exception("Parse error found at index " + this.curIndex + " :    '" + this.lookAhead + "' is not expected in the expression " + this.expression.substring(0, this.curIndex - this.lookAhead.length()) + "<font color=red><u>" + this.lookAhead + "</u></font>" + this.expression.substring(this.curIndex));
    }

    public static void main(String[] args) {
        try {
            System.out.println();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

