/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.etl.server;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.table.DefaultTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.eaglei.datatools.etl.server.Configure;
import org.eaglei.datatools.etl.server.RDFtoRepoService;
import org.eaglei.datatools.etl.server.Rdf123Expression;
import org.eaglei.datatools.etl.server.RowConfiguration;
import org.eaglei.datatools.etl.utils.BasicUtils;
import org.eaglei.datatools.etl.utils.JenaUtils;
import org.eaglei.datatools.excel.ExcelParserException;
import org.eaglei.datatools.excel.ExcelUtils;
import org.eaglei.datatools.jena.SPARQLQueryUtil;
import org.eaglei.datatools.model.AnnotationFormModel;
import org.eaglei.datatools.provider.RepositoryProvider;
import org.eaglei.model.EIURI;

public class RdfMaker {
    private static final long serialVersionUID = 1L;
    private static Model prefixModel = null;
    private static HashMap predefinedMetaMap = null;
    private int count = 0;
    String[][] globalColumnsAry = new String[2][];
    private static final Log logger = LogFactory.getLog(RdfMaker.class);
    private String template = new String();
    private String repo = new String();
    private String directory = new String();
    private String oputputdirectory;
    private static RDFtoRepoService rdftorepo;
    private String order;

    public static void main(String[] args) throws Exception {
        RdfMaker rdfmaker = new RdfMaker();
        try {
            if (args.length > 0) {
                for (int i = 0; i < args.length - 1; ++i) {
                    if (args[i].equals("-t")) {
                        rdfmaker.template = args[++i];
                        continue;
                    }
                    if (args[i].equals("-d")) {
                        rdfmaker.directory = args[++i];
                        continue;
                    }
                    if (!args[i].equals("-o")) continue;
                    rdfmaker.oputputdirectory = args[++i];
                }
                if (rdfmaker.template.equals("boyerslab")) {
                    rdfmaker.rdfToRepoByExcelStream(rdfmaker.directory, "src/main/resources/etl/cores_v3/map");
                }
            } else {
                rdfmaker.rdfToRepoByExcelStream("src/main/resources/etl/cores_v3", "src/main/resources/etl/cores_v3/map");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getCount() {
        return this.count;
    }

    public RdfMaker() throws Exception {
        int row;
        rdftorepo = RDFtoRepoService.getInstance();
        int count = Configure.prefixArray.length;
        HashMap<String, String> predefinedPrefixes = new HashMap<String, String>();
        for (row = 0; row < count; ++row) {
            predefinedPrefixes.put(Configure.prefixArray[row][0], Configure.prefixArray[row][1]);
        }
        prefixModel = ModelFactory.createDefaultModel();
        prefixModel.setNsPrefixes(predefinedPrefixes);
        count = Configure.metaArray.length;
        predefinedMetaMap = new HashMap();
        for (row = 0; row < count; ++row) {
            predefinedMetaMap.put(Configure.metaArray[row][0], Configure.metaArray[row][1]);
        }
    }

    public boolean rdfToRepoByExcelStream(String excelFolder, String mapFolder) throws Exception {
        String[] lstFiles;
        File mapdirectory = new File(mapFolder);
        String[] lstMapFiles = mapdirectory.list();
        HashMap<String, InputStream> mapIns = new HashMap<String, InputStream>();
        File excelDirectory = new File(excelFolder);
        for (String str : lstFiles = excelDirectory.list()) {
            if (!str.contains(".xlsx")) {
                logger.info((Object)(str + "is not Excel file ...Ignoring"));
                continue;
            }
            for (String mapstr : lstMapFiles) {
                if (mapstr.contains(".svn")) continue;
                FileInputStream fis = new FileInputStream(mapFolder + "/" + mapstr);
                mapIns.put(mapstr.replace(".rdf", ""), fis);
            }
            File dirfile = new File(excelFolder + "/" + str);
            if (dirfile.isDirectory()) {
                logger.info((Object)(excelFolder + "/" + str + "is directory ...Ignoring"));
                continue;
            }
            logger.info((Object)("processing file :" + excelFolder + "/" + str));
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(excelFolder + "/" + str));
            Map<String, DefaultTableModel> defaultModelMap = this.ExcelToTableModel(is);
            DefaultTableModel tableModel = defaultModelMap.get("INSTRUMENT");
            FileOutputStream fvec = new FileOutputStream("src/test/resources/vector.txt");
            PrintWriter prrvec = new PrintWriter(fvec);
            prrvec.println(tableModel.getDataVector().toString());
            Map<String, Model> retMap = this.generateRDFGraph(defaultModelMap, mapIns);
        }
        return true;
    }

    protected static ByteArrayOutputStream download(BufferedInputStream bInput) throws IOException {
        int nRead;
        ByteArrayOutputStream bytearray = new ByteArrayOutputStream();
        long bytenum = 0L;
        int BUFFER_SIZE = 8192;
        byte[] buffer = new byte[8192];
        while ((nRead = bInput.read(buffer, 0, 8192)) != -1) {
            bytearray.write(buffer, 0, nRead);
            if ((bytenum += (long)nRead) <= 10000000L) continue;
            throw new OutOfMemoryError("Oversized document: we only accept a upper limit of byte 10000000.");
        }
        return bytearray;
    }

    public Map<String, Model> generateRDFGraph(Map<String, DefaultTableModel> tableModelMap, Map<String, InputStream> mapStreamMap) throws Exception {
        String[] keySetAry = this.order.split("#");
        HashMap<String, Model> retMap = new HashMap<String, Model>();
        int loopVar = 0;
        for (String keyStr : keySetAry) {
            String cell;
            DefaultTableModel tableModel = tableModelMap.get(keyStr.toUpperCase());
            InputStream mapStream = mapStreamMap.get(keyStr.toLowerCase());
            if (mapStream == null) continue;
            Model mapModel = null;
            Model rdfModel = null;
            rdfModel = ModelFactory.createDefaultModel();
            rdfModel.setNsPrefix("rdf123", (String)prefixModel.getNsPrefixMap().get("rdf123"));
            if (!keyStr.equalsIgnoreCase("LAB")) continue;
            String base = rdftorepo.getDatatoolsConfiguration().getDatatoolsRepositoryNamespace();
            String mapBase = null;
            Resource mapURIResource = null;
            HashMap<String, String> metaMap = new HashMap<String, String>();
            int metaBaseRow = 0;
            int metaBaseCol = 0;
            int colCount = tableModel.getColumnCount();
            int rowCount = tableModel.getRowCount();
            boolean find = false;
            for (int row = Configure.baseRow; row <= rowCount - 1; ++row) {
                for (int col = Configure.baseCol; col <= colCount - 1; ++col) {
                    cell = (String)tableModel.getValueAt(row, col);
                    if (cell == null || !cell.trim().equalsIgnoreCase("rdf123:metadata")) continue;
                    metaBaseRow = row;
                    metaBaseCol = col;
                    find = true;
                    break;
                }
                if (find) break;
            }
            int metaCol = metaBaseCol;
            for (int metaRow = metaBaseRow + 1; metaRow <= metaBaseRow + 8 && metaCol < colCount - 1 && !(cell = (String)tableModel.getValueAt(metaRow, metaCol)).trim().equals(""); ++metaRow) {
                String valueCell = (String)tableModel.getValueAt(metaRow, metaCol + 1);
                if (valueCell.trim().equals("")) continue;
                metaMap.put(cell.trim(), valueCell.trim());
            }
            String mapURI = (String)metaMap.get("map file");
            String syntax = "RDF/XML";
            mapModel = ModelFactory.createDefaultModel();
            mapModel.read(mapStream, null, syntax);
            mapModel.removeNsPrefix("");
            rdfModel.setNsPrefixes(mapModel.getNsPrefixMap());
            boolean hasRowHead = true;
            int startRow = Configure.baseRow;
            int endRow = tableModel.getRowCount() - 1;
            int startCol = 1;
            Rdf123Expression rdf123Exp = new Rdf123Expression(tableModel, rdfModel.getNsPrefixMap(), startCol, base);
            if (hasRowHead) {
                ++startRow;
            }
            List<EIURI> eiurilst = null;
            if (endRow - startRow >= 1) {
                eiurilst = rdftorepo.getNewInstancesFromRepo(endRow - startRow + 1);
            }
            this.count = 0;
            for (int row = startRow; row <= endRow; ++row) {
                HashMap<String, String> mapInstanceExp = new HashMap<String, String>();
                int columnCount = tableModel.getColumnCount();
                boolean blankRow = true;
                for (int column = 0; column <= columnCount - 1; ++column) {
                    if (tableModel.getValueAt(row, column) == null || tableModel.getValueAt(row, column).equals("")) continue;
                    blankRow = false;
                    break;
                }
                if (blankRow) continue;
                StmtIterator mapIter = mapModel.listStatements();
                boolean checkforInstance = false;
                boolean foundInstance = false;
                Resource prevSubject = null;
                Property prevPredicate = null;
                RDFNode prevObject = null;
                Resource prevSubjectMap = null;
                RDFNode prevObjectMap = null;
                while (mapIter.hasNext()) {
                    RDFNode object;
                    String result;
                    foundInstance = false;
                    Statement stmtMap = mapIter.nextStatement();
                    Resource subjectMap = stmtMap.getSubject();
                    Property predicateMap = stmtMap.getPredicate();
                    RDFNode objectMap = stmtMap.getObject();
                    Resource subject = null;
                    Property predicate = null;
                    RDFNode[] objectAry = new RDFNode[20];
                    if (subjectMap.isAnon()) {
                        subject = rdfModel.createResource(new AnonId(subjectMap.getId().toString() + row));
                    } else if (subjectMap.getURI().startsWith("Ex:")) {
                        if (subjectMap.getURI().startsWith("Ex:e")) {
                            String[] instanceURI;
                            String instance;
                            RepositoryProvider provider;
                            String query;
                            if (subjectMap.getURI().startsWith("Ex:e+$0")) {
                                if (eiurilst != null) {
                                    EIURI eiuri = eiurilst.get(this.count);
                                    subject = rdfModel.createResource(eiuri.toString());
                                }
                            } else if (subjectMap.getURI().matches("Ex:e\\+\\$\\d") && !subjectMap.getURI().startsWith("Ex:e+$0")) {
                                Resource objectResourceForQuery = null;
                                if (objectMap.isResource()) {
                                    objectResourceForQuery = (Resource)objectMap;
                                }
                                if (predicateMap.hasURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type")) {
                                    checkforInstance = true;
                                }
                                if (objectResourceForQuery == null) {
                                    if (foundInstance) {
                                        foundInstance = false;
                                        continue;
                                    }
                                    if (prevSubjectMap != null && prevSubjectMap.getURI().equals(subjectMap.getURI())) {
                                        subject = this.pushIfNewInstance(rdfModel, mapInstanceExp, subjectMap);
                                        prevSubjectMap = null;
                                        prevObjectMap = null;
                                    } else if (prevSubjectMap != null && prevObjectMap != null && !prevSubjectMap.getURI().equals(subjectMap.getURI()) && !prevObjectMap.isResource()) {
                                        this.checkForAlreadyModelAndAdd(rdfModel, prevSubject, prevPredicate, prevObject, subjectMap);
                                        checkforInstance = true;
                                        prevSubject = this.pushIfNewInstance(rdfModel, mapInstanceExp, subjectMap);
                                        prevSubjectMap = subjectMap;
                                        prevObjectMap = objectMap;
                                    } else {
                                        checkforInstance = true;
                                        List<EIURI> lstEIURI = rdftorepo.getNewInstancesFromRepo(1);
                                        EIURI neweiuri = lstEIURI.get(0);
                                        prevSubject = this.checkSubjectandAddMode(rdfModel, mapInstanceExp, subjectMap, neweiuri);
                                        prevSubjectMap = subjectMap;
                                        prevObjectMap = objectMap;
                                    }
                                } else if (checkforInstance) {
                                    String[] strSplit = subjectMap.getURI().split("\\+");
                                    EIURI eiuri = EIURI.create((String)mapModel.expandPrefix(objectResourceForQuery.getURI()));
                                    String literal = rdf123Exp.evaluate(strSplit[1], row);
                                    if (literal != null) {
                                        literal = literal.replace("?", "\\?").replace("+", "\\+").replace("*", "\\*").replace("(", "\\(").replace(")", "//)");
                                    }
                                    query = SPARQLQueryUtil.getInstance().getEIResourcesByLabelQuery(eiuri, literal);
                                    logger.info((Object)query);
                                    provider = rdftorepo.getRepositoryProvider();
                                    instance = provider.query(query);
                                    instanceURI = RdfMaker.getInstanceURI(instance);
                                    if (instanceURI != null) {
                                        mapInstanceExp.put(subjectMap.getURI(), instanceURI[0]);
                                        subject = rdfModel.createResource(instanceURI[0]);
                                        foundInstance = true;
                                    } else if (literal != null) {
                                        ResIterator iter = rdfModel.listSubjectsWithProperty(predicateMap, objectMap);
                                        boolean found = false;
                                        Resource foundResource = null;
                                        while (iter.hasNext()) {
                                            found = true;
                                            foundResource = (Resource)iter.next();
                                        }
                                        if (found) {
                                            mapInstanceExp.put(subjectMap.getURI(), foundResource.getURI());
                                            subject = rdfModel.createResource(foundResource.getURI());
                                            foundInstance = true;
                                        } else {
                                            subject = this.pushIfNewInstance(rdfModel, mapInstanceExp, subjectMap);
                                        }
                                    }
                                    checkforInstance = false;
                                    prevSubjectMap = subjectMap;
                                    prevObjectMap = objectMap;
                                } else {
                                    subject = this.pushIfNewInstance(rdfModel, mapInstanceExp, subjectMap);
                                }
                            } else if (subjectMap.getURI().matches("Ex:e\\+ont\\+[^\\+]*?\\+\\$\\d+")) {
                                if (mapInstanceExp.get(subjectMap.getURI()) == null) {
                                    String[] strSplit = subjectMap.getURI().split("\\+");
                                    String label = rdf123Exp.evaluate(strSplit[3], row);
                                    if (label != null) {
                                        label = label.replace("?", "\\?").replace("+", "\\+").replace("*", "\\*").replace("(", "\\(").replace(")", "//)");
                                    }
                                    String uritoQuery = mapModel.expandPrefix(strSplit[2]);
                                    EIURI eiuri = EIURI.create((String)uritoQuery);
                                    query = SPARQLQueryUtil.getInstance().getEIResourcesByLabelQuery(eiuri, label);
                                    provider = rdftorepo.getRepositoryProvider();
                                    instance = provider.query(query);
                                    instanceURI = RdfMaker.getInstanceURI(instance);
                                    if (instanceURI != null) {
                                        mapInstanceExp.put(subjectMap.getURI(), instanceURI[0]);
                                        subject = rdfModel.createResource(instanceURI[0]);
                                    } else {
                                        String ontologyURI = this.checkOntology(rdf123Exp, row, label, uritoQuery, mapModel);
                                        if (ontologyURI == null) {
                                            if (label != null) {
                                                ResIterator iter = rdfModel.listSubjectsWithProperty(predicateMap, objectMap);
                                                boolean found = false;
                                                Resource foundResource = null;
                                                while (iter.hasNext()) {
                                                    found = true;
                                                    foundResource = (Resource)iter.next();
                                                }
                                                if (found) {
                                                    mapInstanceExp.put(subjectMap.getURI(), foundResource.getURI());
                                                    subject = rdfModel.createResource(foundResource.getURI());
                                                    foundInstance = true;
                                                } else {
                                                    subject = this.pushIfNewInstance(rdfModel, mapInstanceExp, subjectMap);
                                                }
                                            }
                                        } else {
                                            subject = rdfModel.createResource(ontologyURI);
                                            mapInstanceExp.put(subjectMap.getURI(), subject.getURI());
                                        }
                                    }
                                } else {
                                    subject = rdfModel.createResource(((String)mapInstanceExp.get(subjectMap.getURI())).toString());
                                }
                            }
                        } else if (subjectMap.getURI().startsWith("Ex:ont")) {
                            String[] splitStr = subjectMap.getURI().split("\\+");
                            String[] splitNamespace = splitStr[1].split(":");
                            String rootURI = mapModel.expandPrefix(splitStr[1]);
                            String id = splitNamespace[1];
                            String subclassLabel = rdf123Exp.evaluate(splitStr[2], row);
                            String instanceURI = this.checkOntology(rdf123Exp, row, subclassLabel, rootURI, mapModel);
                            if (instanceURI == null) continue;
                            subject = rdfModel.createResource(instanceURI);
                        } else if (!subjectMap.getURI().startsWith("Ex:e") && !subjectMap.getURI().matches("Ex:ont") || subjectMap.getURI().startsWith("Ex:")) {
                            result = rdf123Exp.evaluate(subjectMap.getURI().substring("Ex:".length()), row);
                            if (result == null) continue;
                            if (!BasicUtils.isValidURL(result)) {
                                if (!JenaUtils.isValidRDFId(result) && !JenaUtils.isValidRDFId(result = result.replace(' ', '_'))) continue;
                                result = this.toURI(base, result);
                            }
                            subject = rdfModel.createResource(result);
                        }
                    } else if (subjectMap.getURI().equals(mapBase)) {
                        if (mapBase.equals("http://baseURI")) {
                            if (mapURIResource != null) {
                                subject = mapURIResource;
                            } else {
                                subject = mapURIResource = rdfModel.createResource(rdfModel.createResource(rdfModel.expandPrefix("rdf123:Map")));
                                rdfModel.add(rdfModel.createResource(base), rdfModel.createProperty(rdfModel.expandPrefix("rdf123:hasMap")), (RDFNode)mapURIResource);
                            }
                        } else if (mapURIResource != null) {
                            subject = mapURIResource;
                        } else {
                            subject = mapURIResource = rdfModel.createResource(mapURI, rdfModel.createResource(rdfModel.expandPrefix("rdf123:Map")));
                            rdfModel.add(rdfModel.createResource(base), rdfModel.createProperty(rdfModel.expandPrefix("rdf123:hasMap")), (RDFNode)mapURIResource);
                        }
                    } else {
                        subject = subjectMap;
                    }
                    if (predicateMap.getURI().startsWith("Ex:")) {
                        result = rdf123Exp.evaluate(predicateMap.getURI().substring("Ex:".length()), row);
                        if (result == null) continue;
                        if (!BasicUtils.isValidURL(result)) {
                            if (!JenaUtils.isValidRDFId(result) && !JenaUtils.isValidRDFId(result = result.replace(' ', '_'))) continue;
                            result = this.toURI(base, result);
                        }
                        if (checkforInstance) {
                            prevPredicate = rdfModel.createProperty(result);
                        } else {
                            predicate = rdfModel.createProperty(result);
                        }
                    } else if (checkforInstance) {
                        prevPredicate = predicateMap;
                    } else {
                        predicate = predicateMap;
                    }
                    if (objectMap instanceof Resource) {
                        Resource object2;
                        Resource objectResource = (Resource)objectMap;
                        if (objectResource.isAnon()) {
                            object2 = rdfModel.createResource(new AnonId(objectResource.getId().toString() + row));
                            objectAry[0] = object2;
                        } else if (objectResource.getURI().startsWith("Ex:e")) {
                            if (objectResource.getURI().matches("Ex:e\\+\\$\\d") || objectResource.getURI().matches("Ex:e\\+ont\\+[^\\+]*?\\+\\$\\d+")) {
                                String strEiURI;
                                if (checkforInstance) {
                                    strEiURI = (String)mapInstanceExp.get(objectResource.getURI());
                                    prevObject = rdfModel.createResource(strEiURI);
                                } else {
                                    strEiURI = (String)mapInstanceExp.get(objectResource.getURI());
                                    if (strEiURI != null) {
                                        objectAry[0] = object = rdfModel.createResource(strEiURI);
                                    } else {
                                        List<EIURI> lstEIURI = rdftorepo.getNewInstancesFromRepo(1);
                                        EIURI neweiuri = lstEIURI.get(0);
                                        mapInstanceExp.put(objectResource.getURI(), neweiuri.toString());
                                        Resource object3 = rdfModel.createResource(neweiuri.toString());
                                        objectAry[0] = object3;
                                    }
                                }
                            }
                        } else if (objectResource.getURI().matches("Ex:ont\\+[^\\+]*?\\+\\$\\d+")) {
                            boolean retBoolean = true;
                            retBoolean = predicate != null ? this.ontProcess(keyStr, mapModel, rdfModel, rdf123Exp, row, mapInstanceExp, objectAry, objectResource.toString(), predicate) : this.ontProcess(keyStr, mapModel, rdfModel, rdf123Exp, row, mapInstanceExp, objectAry, objectResource.toString(), prevPredicate);
                            if (!retBoolean) {
                                predicate = predicate != null ? rdfModel.createProperty("http://eagle-i.org/ont/dt/temporary/" + predicate.getLocalName()) : rdfModel.createProperty("http://eagle-i.org/ont/dt/temporary/" + prevPredicate.getLocalName());
                            }
                        } else if (objectResource.getURI().startsWith("Ex:") && !objectResource.getURI().matches("ont")) {
                            Resource object4;
                            String result2 = rdf123Exp.evaluate(objectResource.getURI().substring("Ex:".length()), row);
                            if (result2 == null) continue;
                            StmtIterator propertyIter = objectResource.listProperties();
                            if (propertyIter.hasNext()) {
                                if (!BasicUtils.isValidURL(result2)) {
                                    if (!JenaUtils.isValidRDFId(result2) && !JenaUtils.isValidRDFId(result2 = result2.replace(' ', '_'))) continue;
                                    result2 = this.toURI(base, result2);
                                }
                                object4 = rdfModel.createResource(result2);
                                objectAry[0] = object4;
                            } else if (BasicUtils.isValidURL(result2)) {
                                object4 = rdfModel.createResource(result2);
                                objectAry[0] = object4;
                            } else {
                                object4 = rdfModel.createLiteral(result2);
                                objectAry[0] = object4;
                            }
                        } else {
                            object2 = rdfModel.createResource(objectResource.getURI());
                            objectAry[0] = object2;
                        }
                    } else {
                        Literal objectLiteral = (Literal)objectMap;
                        RDFDatatype dataType = objectLiteral.getDatatype();
                        if (objectLiteral.toString().matches("Ex:ont\\+[^\\+]*?\\+\\$\\d+")) {
                            boolean retBoolean = true;
                            retBoolean = predicate != null ? this.ontProcess(keyStr, mapModel, rdfModel, rdf123Exp, row, mapInstanceExp, objectAry, objectLiteral.toString(), predicate) : this.ontProcess(keyStr, mapModel, rdfModel, rdf123Exp, row, mapInstanceExp, objectAry, objectLiteral.toString(), prevPredicate);
                            if (!retBoolean) {
                                predicate = predicate != null ? rdfModel.createProperty("http://eagle-i.org/ont/dt/temporary/" + predicate.getLocalName()) : rdfModel.createProperty("http://eagle-i.org/ont/dt/temporary/" + prevPredicate.getLocalName());
                            }
                        } else if (dataType == null) {
                            if (objectLiteral.getString().startsWith("Ex:")) {
                                Literal object5;
                                String result3;
                                String expression;
                                String localName = objectLiteral.getString().substring("Ex:".length());
                                if (localName.endsWith("^^string")) {
                                    expression = localName.substring(0, localName.length() - 8);
                                    result3 = rdf123Exp.evaluate(expression, row);
                                    if (result3 == null) continue;
                                    if (checkforInstance) {
                                        prevObject = rdfModel.createTypedLiteral(result3, (RDFDatatype)XSDDatatype.XSDstring);
                                    } else {
                                        object5 = rdfModel.createTypedLiteral(result3, (RDFDatatype)XSDDatatype.XSDstring);
                                        objectAry[0] = object5;
                                    }
                                } else if (localName.endsWith("^^decimal")) {
                                    expression = localName.substring(0, localName.length() - 9);
                                    result3 = rdf123Exp.evaluate(expression, row);
                                    if (result3 == null) continue;
                                    object5 = rdfModel.createTypedLiteral(result3, (RDFDatatype)XSDDatatype.XSDdecimal);
                                    objectAry[0] = object5;
                                } else if (localName.endsWith("^^integer")) {
                                    expression = localName.substring(0, localName.length() - 9);
                                    result3 = rdf123Exp.evaluate(expression, row);
                                    if (result3 == null) continue;
                                    object5 = rdfModel.createTypedLiteral(result3, (RDFDatatype)XSDDatatype.XSDinteger);
                                    objectAry[0] = object5;
                                } else if (localName.endsWith("^^float")) {
                                    expression = localName.substring(0, localName.length() - 7);
                                    result3 = rdf123Exp.evaluate(expression, row);
                                    if (result3 == null) continue;
                                    object5 = rdfModel.createTypedLiteral(result3, (RDFDatatype)XSDDatatype.XSDfloat);
                                    objectAry[0] = object5;
                                } else if (localName.endsWith("^^boolean")) {
                                    expression = localName.substring(0, localName.length() - 9);
                                    result3 = rdf123Exp.evaluate(expression, row);
                                    if (result3 == null) continue;
                                    object5 = rdfModel.createTypedLiteral(result3, (RDFDatatype)XSDDatatype.XSDboolean);
                                    objectAry[0] = object5;
                                } else if (localName.endsWith("^^time")) {
                                    expression = localName.substring(0, localName.length() - 6);
                                    result3 = rdf123Exp.evaluate(expression, row);
                                    if (result3 == null) continue;
                                    object5 = rdfModel.createTypedLiteral(result3, (RDFDatatype)XSDDatatype.XSDtime);
                                    objectAry[0] = object5;
                                } else if (localName.endsWith("^^anyURI")) {
                                    expression = localName.substring(0, localName.length() - 8);
                                    result3 = rdf123Exp.evaluate(expression, row);
                                    if (result3 == null) continue;
                                    object5 = rdfModel.createTypedLiteral(result3, (RDFDatatype)XSDDatatype.XSDanyURI);
                                    objectAry[0] = object5;
                                } else if (localName.endsWith("^^double")) {
                                    expression = localName.substring(0, localName.length() - 8);
                                    result3 = rdf123Exp.evaluate(expression, row);
                                    if (result3 == null) continue;
                                    object5 = rdfModel.createTypedLiteral(result3, (RDFDatatype)XSDDatatype.XSDdouble);
                                    objectAry[0] = object5;
                                } else if (localName.endsWith("^^int")) {
                                    expression = localName.substring(0, localName.length() - 5);
                                    result3 = rdf123Exp.evaluate(expression, row);
                                    if (result3 == null) continue;
                                    object5 = rdfModel.createTypedLiteral(result3, (RDFDatatype)XSDDatatype.XSDint);
                                    objectAry[0] = object5;
                                } else if (localName.endsWith("^^long")) {
                                    expression = localName.substring(0, localName.length() - 6);
                                    result3 = rdf123Exp.evaluate(expression, row);
                                    if (result3 == null) continue;
                                    object5 = rdfModel.createTypedLiteral(result3, (RDFDatatype)XSDDatatype.XSDlong);
                                    objectAry[0] = object5;
                                } else if (localName.endsWith("^^short")) {
                                    expression = localName.substring(0, localName.length() - 7);
                                    result3 = rdf123Exp.evaluate(expression, row);
                                    if (result3 == null) continue;
                                    object5 = rdfModel.createTypedLiteral(result3, (RDFDatatype)XSDDatatype.XSDshort);
                                    objectAry[0] = object5;
                                } else if (localName.endsWith("^^positiveInteger")) {
                                    expression = localName.substring(0, localName.length() - 17);
                                    result3 = rdf123Exp.evaluate(expression, row);
                                    if (result3 == null) continue;
                                    object5 = rdfModel.createTypedLiteral(result3, (RDFDatatype)XSDDatatype.XSDpositiveInteger);
                                    objectAry[0] = object5;
                                } else if (localName.endsWith("^^negativeInteger")) {
                                    expression = localName.substring(0, localName.length() - 17);
                                    result3 = rdf123Exp.evaluate(expression, row);
                                    if (result3 == null) continue;
                                    object5 = rdfModel.createTypedLiteral(result3, (RDFDatatype)XSDDatatype.XSDnegativeInteger);
                                    objectAry[0] = object5;
                                } else if (localName.endsWith("^^byte")) {
                                    expression = localName.substring(0, localName.length() - 6);
                                    result3 = rdf123Exp.evaluate(expression, row);
                                    if (result3 == null) continue;
                                    object5 = rdfModel.createTypedLiteral(result3, (RDFDatatype)XSDDatatype.XSDbyte);
                                    objectAry[0] = object5;
                                } else if (localName.endsWith("^^dateTime")) {
                                    expression = localName.substring(0, localName.length() - 10);
                                    result3 = rdf123Exp.evaluate(expression, row);
                                    if (result3 == null) continue;
                                    object5 = rdfModel.createTypedLiteral(result3, (RDFDatatype)XSDDatatype.XSDdateTime);
                                    objectAry[0] = object5;
                                } else if (localName.endsWith("^^token")) {
                                    expression = localName.substring(0, localName.length() - 7);
                                    result3 = rdf123Exp.evaluate(expression, row);
                                    if (result3 == null) continue;
                                    object5 = rdfModel.createTypedLiteral(result3, (RDFDatatype)XSDDatatype.XSDtoken);
                                    objectAry[0] = object5;
                                } else if (localName.endsWith("^^language")) {
                                    expression = localName.substring(0, localName.length() - 10);
                                    result3 = rdf123Exp.evaluate(expression, row);
                                    if (result3 == null) continue;
                                    object5 = rdfModel.createTypedLiteral(result3, (RDFDatatype)XSDDatatype.XSDlanguage);
                                    objectAry[0] = object5;
                                } else if (localName.endsWith("^^date")) {
                                    expression = localName.substring(0, localName.length() - 6);
                                    result3 = rdf123Exp.evaluate(expression, row);
                                    if (result3 == null) continue;
                                    object5 = rdfModel.createTypedLiteral(result3, (RDFDatatype)XSDDatatype.XSDdate);
                                    objectAry[0] = object5;
                                } else {
                                    expression = localName;
                                    result3 = rdf123Exp.evaluate(expression, row);
                                    if (result3 == null) continue;
                                    if (BasicUtils.isValidURL(result3)) {
                                        if (checkforInstance) {
                                            prevObject = rdfModel.createResource(result3);
                                        } else {
                                            object5 = rdfModel.createResource(result3);
                                            objectAry[0] = object5;
                                        }
                                    } else if (checkforInstance) {
                                        prevObject = rdfModel.createResource(result3);
                                    } else {
                                        object5 = rdfModel.createResource(result3);
                                        objectAry[0] = object5;
                                    }
                                }
                            } else if (checkforInstance) {
                                prevObject = objectMap;
                            } else {
                                objectAry[0] = object = objectMap;
                            }
                        } else if (checkforInstance) {
                            prevObject = objectMap;
                        } else {
                            objectAry[0] = object = objectMap;
                        }
                    }
                    if (subject != null && !foundInstance && prevSubjectMap != null && prevSubject != null && prevPredicate != null && prevObject != null && prevSubjectMap.getURI().equals(subjectMap.getURI())) {
                        this.checkForAlreadyModelAndAdd(rdfModel, prevSubject, prevPredicate, prevObject, subjectMap);
                        checkforInstance = false;
                        foundInstance = false;
                    }
                    if (checkforInstance || foundInstance) continue;
                    for (RDFNode objectNode : objectAry) {
                        if (objectNode == null) continue;
                        this.checkForAlreadyModelAndAdd(rdfModel, subject, predicate, objectNode, subjectMap);
                    }
                }
                ++this.count;
            }
            if (this.count % 50 == 0) {
                System.gc();
            }
            retMap.put(keyStr, rdfModel);
            logger.info((Object)("pushing " + keyStr + "to repo"));
            StringWriter swriter = new StringWriter();
            rdfModel.write((Writer)swriter, "N-TRIPLE");
            rdftorepo.pushtoRepo(swriter.toString());
            if (this.oputputdirectory != null) {
                FileOutputStream fout = new FileOutputStream(this.oputputdirectory + "/" + keyStr + ".rdf");
                PrintWriter prr = new PrintWriter(fout);
                rdfModel.write((Writer)prr);
            }
            logger.info((Object)(keyStr + " pushed into repo"));
            ++loopVar;
        }
        return retMap;
    }

    private boolean ontProcess(String keyStr, Model mapModel, Model rdfModel, Rdf123Expression rdf123Exp, int row, Map<String, String> mapInstanceExp, RDFNode[] objectAry, String objectResourceURI, Property predicate) throws Exception {
        try {
            String[] splitStr = objectResourceURI.split("\\+");
            String rootURI = mapModel.expandPrefix(splitStr[1]);
            String subclassLabel = rdf123Exp.evaluate(splitStr[2], row);
            String result = this.checkOntology(rdf123Exp, row, subclassLabel, rootURI, mapModel);
            boolean retBoolean = false;
            if (result != null) {
                Resource object = rdfModel.createResource(result);
                objectAry[0] = object;
                retBoolean = true;
                return retBoolean;
            }
            mapInstanceExp.put(objectResourceURI, "http://eagle-i.org/ont/dt/temporary/" + predicate.getLocalName());
            Literal object = rdfModel.createLiteral(subclassLabel);
            objectAry[0] = object;
            retBoolean = false;
            return retBoolean;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            logger.debug((Object)(keyStr + "----" + objectResourceURI));
            throw e;
        }
    }

    private void checkForAlreadyModelAndAdd(Model rdfModel, Resource subject, Property predicate, RDFNode objectNode, Resource subjectMap) {
        ResIterator iter = rdfModel.listSubjectsWithProperty(predicate, objectNode);
        boolean found = false;
        if (iter.hasNext()) {
            found = true;
        }
        if (!found && subject != null && objectNode != null && predicate != null && subjectMap != null || subjectMap.getURI().equals("Ex:e+$0")) {
            logger.debug((Object)("added" + subject.toString() + "--" + predicate.toString() + "---" + objectNode.toString()));
            rdfModel.add(subject, predicate, objectNode);
        }
    }

    private Resource pushIfNewInstance(Model rdfModel, Map<String, String> mapInstanceExp, Resource subjectMap) throws Exception {
        List<EIURI> lstEIURI = rdftorepo.getNewInstancesFromRepo(1);
        EIURI neweiuri = lstEIURI.get(0);
        Resource subject = this.checkSubjectandAddMode(rdfModel, mapInstanceExp, subjectMap, neweiuri);
        return subject;
    }

    private Resource checkSubjectandAddMode(Model rdfModel, Map<String, String> mapInstanceExp, Resource subjectMap, EIURI neweiuri) {
        String uri = mapInstanceExp.get(subjectMap.getURI());
        if (uri == null) {
            mapInstanceExp.put(subjectMap.getURI(), neweiuri.toString());
            Resource subject = rdfModel.createResource(neweiuri.toString());
            return subject;
        }
        Resource subject = rdfModel.createResource(uri);
        return subject;
    }

    private String checkOntology(Rdf123Expression rdf123Exp, int row, String label, String URI2, Model mapModel) throws Exception {
        AnnotationFormModel anntModel = AnnotationFormModel.getInstance();
        String result = anntModel.findSubclassByLabel(URI2, label);
        return result;
    }

    public Map<String, DefaultTableModel> ExcelToTableModel(InputStream excelInputStream) throws Exception {
        Workbook wb;
        boolean rdfmetadatafound = false;
        try {
            wb = WorkbookFactory.create((InputStream)excelInputStream);
        }
        catch (FileNotFoundException e) {
            throw new ExcelParserException(e);
        }
        catch (InvalidFormatException e) {
            throw new ExcelParserException("Expecting an Excel file", e);
        }
        catch (IOException e) {
            throw new ExcelParserException(e);
        }
        finally {
            try {
                if (excelInputStream != null) {
                    excelInputStream.close();
                }
            }
            catch (IOException e) {}
        }
        HashMap<String, DefaultTableModel> tableModelMap = new HashMap<String, DefaultTableModel>();
        int numBerOFSheets = wb.getNumberOfSheets();
        for (int sheetNum = 0; sheetNum <= numBerOFSheets - 1; ++sheetNum) {
            Row row;
            Row row2;
            int row3;
            Sheet sheet = wb.getSheetAt(sheetNum);
            int rowcount = sheet.getLastRowNum();
            if (sheet.getRow(1) == null) continue;
            short colcount = sheet.getRow(1).getLastCellNum();
            DefaultTableModel tableModel = new DefaultTableModel(rowcount + 1, colcount + 1);
            for (row3 = Configure.baseRow; row3 < rowcount; ++row3) {
                tableModel.setValueAt(String.valueOf(row3 + 1), row3, 0);
            }
            for (row3 = Configure.baseRow; row3 < rowcount; ++row3) {
                for (int col = Configure.baseCol; col < colcount + 1; ++col) {
                    tableModel.setValueAt(new String(""), row3, col);
                }
            }
            double startRow = 0.0;
            double endRow = 0.0;
            Iterator rowIter = sheet.rowIterator();
            if (rowIter.hasNext()) {
                Row row4 = (Row)rowIter.next();
                Iterator cellIter = row4.cellIterator();
                while (cellIter.hasNext()) {
                    Cell cell = (Cell)cellIter.next();
                    int rowNum = row4.getRowNum();
                    int colNum = cell.getColumnIndex();
                }
            }
            boolean startRowFlag = false;
            boolean endRowFlag = false;
            boolean globalColumns = false;
            boolean globalColumnsValues = false;
            boolean rowhead = false;
            boolean rdfmetadata = false;
            int rowheadStart = 0;
            int loopVarLimit = 1;
            for (int loopVarIncrement = 0; (loopVarIncrement <= loopVarLimit || loopVarLimit == 1) && (row2 = sheet.getRow(loopVarIncrement)) != null; ++loopVarIncrement) {
                Iterator cellIter = row2.cellIterator();
                while (cellIter.hasNext()) {
                    Cell cell = (Cell)cellIter.next();
                    int rowNum = row2.getRowNum();
                    if (startRowFlag) {
                        startRow = cell.getNumericCellValue();
                        startRowFlag = false;
                    } else if (endRowFlag) {
                        endRow = cell.getNumericCellValue();
                        endRowFlag = false;
                    } else if (globalColumns) {
                        this.globalColumnsAry[0] = cell.getStringCellValue().split(";");
                        globalColumns = false;
                    } else if (globalColumnsValues) {
                        this.globalColumnsAry[1] = cell.getStringCellValue().split(";");
                        globalColumnsValues = false;
                        tableModel.setColumnCount(tableModel.getColumnCount() + this.globalColumnsAry[0].length);
                    } else if (rowhead) {
                        rowheadStart = (int)cell.getNumericCellValue();
                        tableModel.setColumnCount(sheet.getRow(rowheadStart).getLastCellNum() + 1);
                        if (endRow == 0.0) {
                            endRow = rowheadStart;
                        }
                        rowhead = false;
                    } else if (rdfmetadata) {
                        loopVarLimit *= 8;
                        rdfmetadata = false;
                    }
                    if (cell.getCellType() == 1 && cell.getStringCellValue().equals("start row")) {
                        startRowFlag = true;
                        continue;
                    }
                    if (cell.getCellType() == 1 && cell.getStringCellValue().equals("end row")) {
                        endRowFlag = true;
                        continue;
                    }
                    if (cell.getCellType() == 1 && cell.getStringCellValue().equalsIgnoreCase("globalcolumns")) {
                        globalColumns = true;
                        continue;
                    }
                    if (cell.getCellType() == 1 && cell.getStringCellValue().equalsIgnoreCase("globalcolumnsvalues")) {
                        globalColumnsValues = true;
                        continue;
                    }
                    if (cell.getCellType() == 1 && cell.getStringCellValue().equalsIgnoreCase("row head")) {
                        rowhead = true;
                        continue;
                    }
                    if (cell.getCellType() != 1 || !cell.getStringCellValue().equalsIgnoreCase("rdf123:metadata")) continue;
                    rdfmetadata = true;
                    rdfmetadatafound = true;
                }
            }
            if (!rdfmetadatafound) {
                Map<String, String> rowConfigMap = RowConfiguration.getRowInfoMap("C:\\workspace\\tools\\src\\main\\resources\\etl\\cores_v3\\map", sheet.getSheetName());
                startRow = Integer.parseInt(rowConfigMap.get("startrow"));
                rowheadStart = Integer.parseInt(rowConfigMap.get("rowheadstart"));
                this.order = rowConfigMap.get("order");
            }
            int i = (int)startRow - 1;
            endRow = sheet.getPhysicalNumberOfRows();
            while ((double)i <= endRow - 1.0 && (row = sheet.getRow(i)) != null) {
                if (ExcelUtils.isBlankRow(row)) {
                    ++i;
                    continue;
                }
                Iterator cellIter = row.cellIterator();
                while (cellIter.hasNext()) {
                    Cell cell = (Cell)cellIter.next();
                    if (i < 343 || cell.getCellType() == 1 || cell.getCellType() == 2) {
                        // empty if block
                    }
                    int rowNum = row.getRowNum();
                    int colNum = rowheadStart > 0 && rowNum >= rowheadStart && this.globalColumnsAry[0] != null ? cell.getColumnIndex() + this.globalColumnsAry[0].length - 1 : cell.getColumnIndex();
                    this.addCell(tableModel, cell, rowNum, colNum);
                }
                if (this.globalColumnsAry[0] != null) {
                    if (i == rowheadStart && this.globalColumnsAry[0].length > 0) {
                        int y = 0;
                        for (String s : this.globalColumnsAry[0]) {
                            this.addCell(tableModel, s, i, y);
                            ++y;
                        }
                    } else if (i > rowheadStart && this.globalColumnsAry[1] != null) {
                        int y = 0;
                        for (String s : this.globalColumnsAry[1]) {
                            this.addCell(tableModel, s, i, y);
                            ++y;
                        }
                    }
                }
                ++i;
            }
            tableModelMap.put(sheet.getSheetName(), tableModel);
        }
        return tableModelMap;
    }

    private void addCell(DefaultTableModel tableModel, Cell cell, int rowNum, int colNum) {
        try {
            tableModel.setValueAt(cell.getStringCellValue() + "", rowNum, colNum + Configure.baseCol);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw e;
        }
        catch (Exception e) {
            tableModel.setValueAt((int)cell.getNumericCellValue() + "", rowNum, colNum + Configure.baseCol);
        }
    }

    private void addCell(DefaultTableModel tableModel, String cellValue, int rowNum, int colNum) {
        tableModel.setValueAt(cellValue, rowNum, colNum + Configure.baseCol);
    }

    private String toURI(String base, String localname) {
        if (base.endsWith("/")) {
            return base + localname;
        }
        return base + "#" + localname;
    }

    public static String[] getInstanceURI(String xmlString) {
        if (xmlString != null) {
            Pattern instancePattern = Pattern.compile("<uri>([^<]*?)</uri>");
            Matcher match = instancePattern.matcher(xmlString);
            String[] instanceStr = null;
            while (match.find()) {
                int count = match.groupCount();
                instanceStr = new String[count];
                for (int i = 1; i <= count; ++i) {
                    instanceStr[i - 1] = match.group(i);
                }
            }
            return instanceStr;
        }
        return null;
    }
}

