/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.etl.utils;

import java.util.Vector;

public class ByStringTokenizer {
    private Vector mTokens = new Vector();
    private int mIndex = 0;

    public ByStringTokenizer(String str, String[] delims) {
        this(str, delims, true, true);
    }

    public ByStringTokenizer(String str, String[] delims, boolean returnDelims) {
        this(str, delims, returnDelims, true);
    }

    public ByStringTokenizer(String str, String[] delims, boolean returnDelims, boolean favorLarger) {
        int startIndex = 0;
        for (int currIndex = 0; currIndex < str.length(); ++currIndex) {
            int curr = -1;
            for (int i = 0; i < delims.length; ++i) {
                if (!str.regionMatches(currIndex, delims[i], 0, delims[i].length())) continue;
                if (curr == -1) {
                    curr = i;
                    continue;
                }
                if (favorLarger && delims[curr].length() < delims[i].length()) {
                    curr = i;
                    continue;
                }
                if (favorLarger || delims[i].length() >= delims[curr].length()) continue;
                curr = i;
            }
            if (curr != -1) {
                String st = str.substring(startIndex, currIndex);
                startIndex = (currIndex += delims[curr].length() - 1) + 1;
                this.mTokens.addElement(st);
                if (!returnDelims) continue;
                this.mTokens.addElement(delims[curr]);
                continue;
            }
            if (curr != -1 || currIndex + 1 != str.length()) continue;
            String st = str.substring(startIndex, str.length());
            this.mTokens.add(st);
            startIndex = currIndex + 1;
        }
    }

    protected int hasDelim(String str, String[] delims) {
        int curr = -1;
        for (int i = 0; i < delims.length; ++i) {
            if (!str.endsWith(delims[i]) || curr != -1 && delims[curr].length() >= delims[i].length()) continue;
            curr = i;
        }
        return curr;
    }

    public Object nextElement() {
        return this.mTokens.elementAt(this.mIndex++);
    }

    public boolean hasMoreElements() {
        return this.mIndex < this.mTokens.size();
    }

    protected boolean isWhiteSpace(String str) {
        return str.equals(" ") || str.equals("\n") || str.equals("\t") || str.equals("\r");
    }

    public String nextSkipWhiteSpace() {
        String currToken = this.nextToken();
        while (this.hasMoreTokens() && (currToken.length() == 0 || this.isWhiteSpace(currToken))) {
            currToken = this.nextToken();
        }
        return currToken.trim();
    }

    public String next() {
        return this.nextToken();
    }

    public int getIndex() {
        return this.mIndex;
    }

    public String nextToken() {
        return this.nextElement().toString();
    }

    public boolean hasMoreTokens() {
        return this.hasMoreElements();
    }

    public int countTokens() {
        return this.mTokens.size();
    }

    public void pushBack(int num) {
        this.mIndex -= num;
    }

    public void reset() {
        this.mIndex = 0;
    }
}

