/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.etl.utils;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.eaglei.datatools.etl.utils.JenaUtils;

public class NewUtils {
    public static int[] readDelimitedIntegers(String theString, String theDelims) throws NumberFormatException {
        int[] aIntList = null;
        if (theString == null || theString.equals("")) {
            return new int[0];
        }
        StringTokenizer toke = new StringTokenizer(theString, theDelims);
        while (toke.hasMoreTokens()) {
            String num = toke.nextToken();
            int col = -1;
            try {
                if (num.indexOf("-") != -1) {
                    StringTokenizer st = new StringTokenizer(num, "-");
                    int startInt = Integer.parseInt(st.nextToken());
                    int endInt = Integer.parseInt(st.nextToken());
                    for (int i = startInt; i <= endInt; ++i) {
                        aIntList = NewUtils.addToIntArray(i, aIntList);
                    }
                    continue;
                }
                col = Integer.parseInt(num);
                aIntList = NewUtils.addToIntArray(col, aIntList);
            }
            catch (NumberFormatException nfe) {
                System.out.println("Invalid format in exclude param.  Type \"int,int ... \" expected.");
                throw nfe;
            }
        }
        return aIntList;
    }

    public static int[] removeFromIntArray(int theElem, int[] theIntList) {
        int[] temp = null;
        if (theIntList == null || theIntList.length == 0) {
            temp = theIntList;
        } else if (theIntList.length == 1) {
            temp = new int[]{};
        } else {
            boolean found = false;
            for (int i = 0; i < theIntList.length; ++i) {
                if (theIntList[i] != theElem) continue;
                found = true;
            }
            if (!found) {
                temp = theIntList;
            } else {
                temp = new int[theIntList.length - 1];
                int aIndex = 0;
                for (int i = 0; i < theIntList.length; ++i) {
                    if (theIntList[i] == theElem) continue;
                    temp[aIndex] = theIntList[i];
                    ++aIndex;
                }
            }
        }
        return temp;
    }

    public static int[] addToIntArray(int theElem, int[] theIntList) {
        int[] temp = null;
        if (theIntList == null) {
            temp = new int[]{theElem};
        } else {
            temp = new int[theIntList.length + 1];
            System.arraycopy(theIntList, 0, temp, 0, theIntList.length);
            temp[theIntList.length] = theElem;
        }
        return temp;
    }

    public static boolean isInArray(int theElem, int[] theArray) {
        if (theArray == null) {
            return false;
        }
        for (int i = 0; i < theArray.length; ++i) {
            if (theArray[i] != theElem) continue;
            return true;
        }
        return false;
    }

    public static String replace(String theHost, String theOldString, String theNewString) {
        int index = 0;
        while (theHost.indexOf(theOldString, index) != -1) {
            index = theHost.indexOf(theOldString, index);
            theHost = theHost.substring(0, index) + theNewString + theHost.substring(index + theOldString.length(), theHost.length());
            index += theNewString.length();
        }
        return theHost;
    }

    public static Iterator listClasses(Model theModel) {
        HashSet<Resource> classes = new HashSet<Resource>();
        ResIterator rIter = theModel.listSubjects();
        while (rIter.hasNext()) {
            Set aTypes;
            Resource aRes = (Resource)rIter.next();
            if (aRes.isAnon() || JenaUtils.isLanguageTerm(aRes) || !(aTypes = JenaUtils.getTypes(aRes, false)).contains(RDFS.Class) && !aTypes.contains(OWL.Class)) continue;
            classes.add(aRes);
        }
        rIter.close();
        return classes.iterator();
    }

    public static Iterator listProperties(Model theModel) {
        HashSet<Resource> classes = new HashSet<Resource>();
        ResIterator rIter = theModel.listSubjects();
        while (rIter.hasNext()) {
            Set aTypes;
            Resource aRes = (Resource)rIter.next();
            if (aRes.isAnon() || JenaUtils.isLanguageTerm(aRes) || !(aTypes = JenaUtils.getTypes(aRes, false)).contains(RDF.Property) && !aTypes.contains(OWL.DatatypeProperty) && !aTypes.contains(OWL.ObjectProperty)) continue;
            classes.add(aRes);
        }
        rIter.close();
        return classes.iterator();
    }

    public static Set collectResourcesFromRDFList(Resource theList) {
        LinkedHashSet<Resource> aSet = new LinkedHashSet<Resource>();
        Resource first = null;
        Resource rest = null;
        rest = theList;
        if (rest == null || !rest.hasProperty(RDF.first)) {
            return aSet;
        }
        do {
            first = rest.getProperty(RDF.first).getResource();
            rest = rest.getProperty(RDF.rest).getResource();
            aSet.add(first);
        } while (!rest.equals(RDF.nil));
        return aSet;
    }
}

