/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.etl.utils;

import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class ProgressFrame
extends JDialog {
    private Thread mThread = new Thread();
    private long mStartTime;
    private static final long WAIT_TIME = 900L;
    private Thread mWaitThread = new Thread();

    public ProgressFrame(JFrame parent, String title, String msg, Runnable task) {
        this(parent, title, msg, task, true);
    }

    public ProgressFrame(JFrame parent, String title, String msg, final Runnable task, boolean modal) {
        super(parent, title, modal);
        this.getContentPane().setLayout(new BorderLayout());
        JProgressBar progressBar = new JProgressBar();
        progressBar.setIndeterminate(true);
        JButton cancelBtn = new JButton("Cancel");
        cancelBtn.setFont(new Font("Tahoma", 0, 11));
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        panel.add(new JLabel(msg));
        panel.add(Box.createVerticalStrut(5));
        panel.add(progressBar);
        panel.add(Box.createVerticalStrut(5));
        panel.add(cancelBtn);
        this.getContentPane().add(panel);
        this.pack();
        this.setSize(400, this.getHeight());
        this.setLocation(80, 100);
        this.setResizable(false);
        this.setLocation(80, 100);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ProgressFrame.this.mThread.stop();
                ProgressFrame.this.dispose();
            }
        });
        this.mThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    task.run();
                }
                catch (Throwable ex) {
                    System.err.println("task run exception");
                    ex.printStackTrace();
                }
                finally {
                    try {
                        ProgressFrame.this.dispose();
                    }
                    catch (Exception ex) {}
                }
            }
        };
        this.mThread.start();
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ProgressFrame.this.mThread.stop();
                    ProgressFrame.this.dispose();
                }
                catch (Exception ex) {
                    System.err.println("task kill exception");
                }
            }
        });
        this.mWaitThread = new Thread(){

            @Override
            public void run() {
                long elapsedTime;
                int sleepTime = 100;
                do {
                    try {
                        Thread.sleep(sleepTime);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                } while ((elapsedTime = System.currentTimeMillis() - ProgressFrame.this.mStartTime) < 900L && ProgressFrame.this.mThread.isAlive());
                if (ProgressFrame.this.mThread.isAlive()) {
                    ProgressFrame.this.show();
                }
            }
        };
        this.mStartTime = System.currentTimeMillis();
        this.mWaitThread.start();
    }
}

