/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.etl.utils;

import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.Comparator;
import org.eaglei.datatools.etl.utils.JenaUtils;

public class ResourceComparator
implements Comparator {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int compare(Object a, Object b) {
        if (a == null) return -1;
        if (b == null) return 1;
        if (!(a instanceof Resource) || !(b instanceof Resource)) return 0;
        Resource res1 = (Resource)a;
        Resource res2 = (Resource)b;
        String one = null;
        String two = null;
        if (res1.isAnon()) {
            if (!res1.hasProperty(RDFS.label)) return 1;
            one = JenaUtils.getLabel(res1).toLowerCase();
        } else {
            one = res1.hasProperty(RDFS.label) ? JenaUtils.getLabel(res1).toLowerCase() : res1.getLocalName().toLowerCase();
        }
        if (res2.isAnon()) {
            if (!res2.hasProperty(RDFS.label)) return -1;
            two = JenaUtils.getLabel(res2).toLowerCase();
            return one.compareTo(two);
        } else {
            two = res2.hasProperty(RDFS.label) ? JenaUtils.getLabel(res2).toLowerCase() : res2.getLocalName().toLowerCase();
        }
        return one.compareTo(two);
    }
}

