/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.etl.utils;

import java.awt.GridLayout;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Authenticator;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.eaglei.datatools.etl.utils.StaticAuthenticator;
import org.eaglei.datatools.etl.utils.VisualAuthenticator;

public class SubmitRDF {
    public static boolean DEBUG = false;
    private String rdfpayload;
    private String name;
    private String description = "Program Data";
    private Date date = new Date();
    private Vector emails;
    private Vector categories;
    private JTextField mUser;
    private JTextField mDescription;
    private SimpleDateFormat sdf;
    private static String lastUser = null;

    public SubmitRDF(String rdf) {
        this.rdfpayload = rdf;
        Authenticator.setDefault(new VisualAuthenticator());
        this.name = null;
        this.categories = new Vector();
        this.emails = new Vector();
        this.sdf = new SimpleDateFormat();
        this.sdf.applyPattern("yyyy-MM-dd");
    }

    public SubmitRDF(String rdf, String username, String password) {
        this.rdfpayload = rdf;
        Authenticator.setDefault(new StaticAuthenticator(username, password));
        this.name = null;
        this.categories = new Vector();
        this.emails = new Vector();
        this.sdf = new SimpleDateFormat();
        this.sdf.applyPattern("yyyy-MM-dd");
    }

    public void addCreator(String email) {
        this.emails.add(email);
    }

    public void setCreators(List email) {
        this.emails = new Vector(email);
    }

    public void addCategory(String category) {
        this.categories.add(category);
    }

    public void setCategories(List category) {
        this.categories = new Vector(category);
    }

    public void setName(String fname) {
        this.name = fname;
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public void setDate(Date d) {
        this.date = d;
    }

    public void setDate(String d) {
        try {
            this.date = this.sdf.parse(d);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.date == null) {
            this.date = new Date();
        }
    }

    private void writeCreators(PrintWriter out) throws IOException {
        Iterator iter = this.emails.iterator();
        while (iter.hasNext()) {
            String encodedEmail = URLEncoder.encode((String)iter.next(), "UTF-8");
            out.write("&creator=" + encodedEmail);
        }
    }

    private void writeCategories(PrintWriter out) throws IOException {
        Iterator iter = this.categories.iterator();
        while (iter.hasNext()) {
            String encodedCategory = URLEncoder.encode((String)iter.next(), "UTF-8");
            out.write("&category=" + encodedCategory);
        }
    }

    private void writeName(PrintWriter out) {
        if (this.name != null) {
            out.write("&num=" + this.name);
        }
    }

    private void writeDescription(PrintWriter out) {
        if (this.description != null) {
            out.write("&desc=" + this.description);
        }
    }

    private void writeDate(PrintWriter out) {
        if (this.date == null) {
            this.date = new Date();
        }
        String datestring = this.sdf.format(this.date);
        out.write("&date=" + datestring);
    }

    private boolean getUserInfo() {
        this.mUser = new JTextField();
        if (lastUser != null) {
            this.mUser.setText(lastUser);
        }
        this.mDescription = new JTextField();
        JPanel panel = new JPanel(new GridLayout(2, 2));
        panel.add(new JLabel("Email"));
        panel.add(this.mUser);
        panel.add(new JLabel("Description of RDF submission"));
        panel.add(this.mDescription);
        int option = JOptionPane.showConfirmDialog(null, panel, "RDF Submit Information", 2, -1);
        return option == 0;
    }

    private String clean(String theString) {
        StringBuffer aFixed = new StringBuffer();
        for (int i = 0; i < theString.length(); ++i) {
            char aVal = theString.charAt(i);
            Character aChar = new Character(theString.charAt(i));
            if (aVal == '\u0000' && Character.isIdentifierIgnorable(aChar.charValue()) && !Character.isLetterOrDigit(aChar.charValue()) && !Character.isWhitespace(aChar.charValue())) {
                System.err.println("removing char from submit output, it seems to be invalid: " + aChar);
                continue;
            }
            aFixed.append(aChar);
        }
        return aFixed.toString();
    }

    public boolean submit(String uri) throws IOException {
        if (this.getUserInfo()) {
            String encodedrdf = URLEncoder.encode(this.clean(this.rdfpayload), "UTF-8");
            URL url = new URL(uri);
            URLConnection connection = url.openConnection();
            connection.setDoOutput(true);
            this.setDescription(this.mDescription.getText());
            this.addCreator(this.mUser.getText());
            lastUser = this.mUser.getText();
            PrintWriter out = new PrintWriter(connection.getOutputStream());
            out.println("rdfblob=" + encodedrdf);
            this.writeCreators(out);
            this.writeCategories(out);
            this.writeName(out);
            this.writeDescription(out);
            this.writeDate(out);
            out.println("&inputtype=1");
            out.println("&op=Submit");
            out.close();
            return this.doSubmit(connection, this.rdfpayload);
        }
        JOptionPane.showMessageDialog(null, "Submit cannot be completed without user information, please try again.", "User Info Error", 0);
        return false;
    }

    private boolean doSubmit(URLConnection theConn, String theRDF) {
        boolean success = false;
        try {
            String line;
            theConn.connect();
            InputStream is = theConn.getInputStream();
            BufferedReader in = new BufferedReader(new InputStreamReader(is));
            String output = "";
            while ((line = in.readLine()) != null) {
                output = output + line;
                if (!DEBUG) continue;
                System.err.println(line);
            }
            if (output.indexOf("Success") != -1) {
                theConn.connect();
                String loc = theConn.getHeaderField("Location");
                success = true;
            } else {
                success = false;
            }
            is.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            success = false;
        }
        return success;
    }
}

