/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.etl.utils;

import java.text.SimpleDateFormat;

public class TypeValidator {
    public static boolean isValidData(String dataType, String data) {
        if (data.equals("") || dataType.endsWith("string")) {
            return true;
        }
        if (dataType.endsWith("normalizedString")) {
            return data.indexOf("\t") == -1 && data.indexOf("\n") == -1 && data.indexOf("\r") == -1;
        }
        if (dataType.endsWith("boolean")) {
            return data.equalsIgnoreCase("true") || data.equalsIgnoreCase("false");
        }
        try {
            if (dataType.endsWith("integer")) {
                Integer.parseInt(data);
            } else if (dataType.endsWith("positiveInteger") || dataType.endsWith("unsignedInt") || dataType.endsWith("nonNegativeInteger")) {
                if (data.indexOf("-") != -1) {
                    return false;
                }
                Integer.parseInt(data);
            } else if (dataType.endsWith("nonPositiveInteger") || dataType.endsWith("negativeInteger")) {
                if (data.indexOf("-") == -1) {
                    return false;
                }
                Integer.parseInt(data);
            } else if (dataType.endsWith("float") || dataType.endsWith("decimal")) {
                Float.parseFloat(data);
            } else if (dataType.endsWith("long") || dataType.endsWith("int")) {
                Long.parseLong(data);
            } else if (dataType.endsWith("unsignedLong")) {
                if (data.indexOf("-") != -1) {
                    return false;
                }
                Long.parseLong(data);
            } else if (dataType.endsWith("byte")) {
                Byte.parseByte(data);
            } else if (dataType.endsWith("unsignedByte")) {
                if (data.indexOf("-") != -1) {
                    return false;
                }
                Byte.parseByte(data);
            } else if (dataType.endsWith("short")) {
                Short.parseShort(data);
            } else if (dataType.endsWith("unsignedShort")) {
                if (data.indexOf("-") != -1) {
                    return false;
                }
                Short.parseShort(data);
            } else if (dataType.endsWith("double")) {
                Double.parseDouble(data);
            } else {
                if (dataType.endsWith("timeDuration")) {
                    return data.startsWith("P");
                }
                if (dataType.endsWith("uriReference") || dataType.endsWith("anyURI")) {
                    return data.startsWith("http://") || data.startsWith("www.");
                }
                if (dataType.endsWith("date")) {
                    SimpleDateFormat df = new SimpleDateFormat("MM/DD/yyyy");
                    df.setLenient(true);
                    df.parse(data);
                }
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

