/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.jena;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Selector;
import com.hp.hpl.jena.rdf.model.SimpleSelector;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIDatatypeProperty;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIObjectProperty;
import org.eaglei.model.EIProperty;
import org.eaglei.model.EIURI;
import org.eaglei.model.jena.JenaEIOntModel;

public class EIInstanceFactory {
    private static final Log logger = LogFactory.getLog(EIInstanceFactory.class);
    public static final EIInstanceFactory INSTANCE = new EIInstanceFactory();
    private OntModel ontModel = JenaEIOntModel.INSTANCE.getOntModel();

    public static EIInstanceFactory getInstance() {
        return INSTANCE;
    }

    private EIInstanceFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String serialize(EIInstance instance, String lang) {
        if (instance == null) {
            return null;
        }
        Model model = this.convertToJenaModel(instance);
        StringWriter sw = new StringWriter();
        try {
            model.write((Writer)sw, lang);
            String s = sw.toString();
            sw.flush();
            String string = s;
            return string;
        }
        finally {
            try {
                if (sw != null) {
                    sw.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public Model convertToJenaModel(EIInstance instance) {
        Set values;
        Property p;
        if (instance == null) {
            return null;
        }
        Model model = ModelFactory.createDefaultModel();
        Resource resourceInstance = model.createResource(instance.getInstanceURI().toString());
        Resource type = model.createResource(instance.getInstanceClass().getEntity().getURI().toString());
        model.add(model.createStatement(resourceInstance, RDF.type, (RDFNode)type));
        model.add(model.createStatement(resourceInstance, RDFS.label, instance.getInstanceLabel()));
        Map dataprop = instance.getDatatypeProperties();
        Map objectprop = instance.getObjectProperties();
        for (Map.Entry entry : dataprop.entrySet()) {
            p = model.createProperty(((EIEntity)entry.getKey()).getURI().toString());
            values = (Set)entry.getValue();
            for (String value : values) {
                model.add(model.createStatement(resourceInstance, p, value));
            }
        }
        for (Map.Entry entry : objectprop.entrySet()) {
            p = model.createProperty(((EIEntity)entry.getKey()).getURI().toString());
            values = (Set)entry.getValue();
            for (String value : values) {
                Resource valueResource = model.createResource(value.toString());
                model.add(model.createStatement(resourceInstance, p, (RDFNode)valueResource));
            }
        }
        return model;
    }

    public EIInstance create(EIURI instanceUri, String rdf, String lang) {
        if (instanceUri == null || instanceUri.toString().length() == 0 || rdf == null || rdf.length() == 0) {
            return null;
        }
        Model model = ModelFactory.createDefaultModel();
        model.read((Reader)new StringReader(rdf), null, lang);
        return this.create(instanceUri, model);
    }

    public static EIInstance createEmpty(EIURI classUri, EIEntity instanceEntity) {
        if (classUri == null || classUri.toString().length() == 0 || instanceEntity == null) {
            return null;
        }
        EIClass instanceClass = JenaEIOntModel.INSTANCE.getClass(classUri);
        if (instanceClass == null) {
            return null;
        }
        return new EIInstance(instanceClass, instanceEntity);
    }

    public EIInstance create(EIURI instanceUri, Model model) {
        if (instanceUri == null || model == null) {
            return null;
        }
        Resource subject = model.getResource(instanceUri.toString());
        if (!model.contains(subject, null, (RDFNode)null)) {
            return null;
        }
        List typeStatements = model.listStatements(subject, RDF.type, (RDFNode)((Resource)null)).toList();
        EIClass instanceClass = null;
        Resource instanceType = null;
        if (typeStatements.size() > 1) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Found more than one type: " + typeStatements.size()));
            }
            for (Statement st : typeStatements) {
                Resource type = (Resource)st.getObject();
                EIURI typeUri = EIURI.create((String)type.getURI());
                EIClass eiClass = JenaEIOntModel.INSTANCE.getClass(typeUri);
                if (eiClass == null || eiClass.hasSuperClass()) continue;
                instanceClass = eiClass;
                instanceType = type;
                break;
            }
        } else {
            Statement typeStatement = subject.getProperty(RDF.type);
            if (typeStatement == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Type is not set for instance in model");
                }
                return null;
            }
            instanceType = typeStatement.getResource();
            if (instanceType == null || instanceType.getURI() == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Type is not correctly set for instance in model");
                }
                return null;
            }
            instanceClass = JenaEIOntModel.INSTANCE.getClass(EIURI.create((String)instanceType.getURI()));
        }
        if (instanceClass == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"No EIClass found in the model");
            }
            return null;
        }
        EIURI instanceClassUri = instanceClass.getEntity().getURI();
        Statement labelStatement = subject.getProperty(RDFS.label);
        if (labelStatement == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"RDFS Label is not set for instance in RDF");
            }
            return null;
        }
        String instanceLabel = labelStatement.getString();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Creating an instance of class: " + instanceClassUri.toString() + " with URI: " + instanceUri + " and label: " + instanceLabel));
        }
        EIEntity instanceEntity = EIEntity.create((EIURI)instanceUri, (String)instanceLabel);
        EIInstance ei = new EIInstance(instanceClass, instanceEntity);
        StmtIterator iter = model.listStatements(subject, null, (RDFNode)null);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Searching for statements with subject: " + instanceUri.toString() + " of class: " + instanceClassUri + " and label: " + instanceLabel));
        }
        while (iter.hasNext()) {
            EIEntity propEntity;
            Statement statement = iter.nextStatement();
            Property predicate = statement.getPredicate();
            if (predicate.equals(RDFS.label)) continue;
            EIURI propertyUri = EIURI.create((String)predicate.getURI());
            RDFNode o = statement.getObject();
            if (predicate.equals(RDF.type) && o.isResource() && ((Resource)o).equals(instanceType)) continue;
            EIProperty p = this.getEIOntProperty(instanceClassUri, propertyUri);
            if (p != null) {
                String preferredLabel = JenaEIOntModel.INSTANCE.getPreferredLabel(propertyUri);
                propEntity = EIEntity.create((EIURI)propertyUri, (String)preferredLabel);
                if (p instanceof EIDatatypeProperty) {
                    String value = o.toString();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("adding property: [" + propertyUri + "] with literal value : [" + value + "] "));
                    }
                    ei.addDatattypePropertyToInstance(propEntity, value);
                    continue;
                }
                if (!(p instanceof EIObjectProperty)) continue;
                EIURI objectUri = EIURI.create((String)((Resource)o).getURI());
                ei.addObjectPropertyToInstance(propEntity, objectUri);
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("adding property: [" + propertyUri + "] with object value : [" + objectUri + "] "));
                continue;
            }
            String predicateLabel = predicate.getLocalName();
            propEntity = EIEntity.create((EIURI)propertyUri, (String)predicateLabel);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Property not found in ontology; we'll still try to add it: " + propertyUri));
            }
            if (o.isLiteral()) {
                ei.addNonOntologyLiteralProperty(propEntity, o.toString());
                continue;
            }
            if (o.isResource()) {
                ei.addNonOntologyResourceProperty(propEntity, EIURI.create((String)((Resource)o).getURI()));
                continue;
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("Could not add property " + propertyUri));
        }
        return ei;
    }

    public List<EIInstance> create(Model model) {
        if (model == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<EIInstance> instances = new ArrayList<EIInstance>();
        Set subjects = model.listSubjects().toSet();
        for (Resource r : subjects) {
            Model results = model.query((Selector)new SimpleSelector(r, null, (RDFNode)null));
            EIInstance ei = this.create(EIURI.create((String)r.getURI()), results);
            if (ei == null) continue;
            instances.add(ei);
        }
        return instances;
    }

    private EIProperty getEIOntProperty(EIURI instanceClassUri, EIURI propertyUri) {
        if (instanceClassUri == null || propertyUri == null) {
            return null;
        }
        List properties = JenaEIOntModel.INSTANCE.getProperties(instanceClassUri);
        if (properties == null || properties.isEmpty()) {
            return null;
        }
        for (EIProperty p : properties) {
            EIURI propUri = p.getEntity().getURI();
            if (!propUri.equals((Object)propertyUri)) continue;
            return p;
        }
        return null;
    }
}

