/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.jena;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.datatools.jena.EIInstanceFactory;
import org.eaglei.datatools.jena.SPARQLQueryUtil;
import org.eaglei.datatools.provider.RepositoryProvider;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIURI;

public final class MemoryRepositoryProvider
implements RepositoryProvider {
    private static final Log logger = LogFactory.getLog(MemoryRepositoryProvider.class);
    private static final String DEFAULT_USER = "eaglei";
    private static final String DEFAULT_SESSION = "valid_sessions";
    private Model model = ModelFactory.createDefaultModel();

    public MemoryRepositoryProvider(InputStream is) {
        this.populateFakeDataModel(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateFakeDataModel(InputStream is) {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Reading data file....");
            }
            this.model.read(is, null, "N-TRIPLE");
        }
        finally {
            block11: {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception e) {
                    if (!logger.isDebugEnabled()) break block11;
                    logger.debug((Object)("Error reading data file: " + e));
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"populated in memory repo...");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String updateInstance(EIInstance instance, String token) throws Exception {
        if (instance == null) {
            return null;
        }
        if (token == null) {
            return UUID.randomUUID().toString();
        }
        Model receivedModel = EIInstanceFactory.INSTANCE.convertToJenaModel(instance);
        if (receivedModel == null) {
            throw new Exception("updateInstance: model is null");
        }
        Resource subject = this.model.createResource(instance.getEntity().getURI().toString());
        this.model.remove(this.model.listStatements(subject, null, (RDFNode)null));
        List statements = receivedModel.listStatements().toList();
        this.model.add(statements);
        StringWriter sw = new StringWriter();
        try {
            this.model.write((Writer)sw, "RDF/XML");
            StringBuffer s = sw.getBuffer();
            sw.flush();
            logger.debug((Object)("updateInstance: RDF/XML size: " + s.length()));
        }
        finally {
            try {
                if (sw != null) {
                    sw.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)("updateInstance: problem updating: " + e));
                throw e;
            }
        }
        return "true";
    }

    @Override
    public EIInstance getInstance(EIURI uri) throws Exception {
        Resource r = this.model.getResource(uri.toString());
        if (r == null) {
            return null;
        }
        List statements = this.model.listStatements(r, null, (RDFNode)null).toList();
        Model results = ModelFactory.createDefaultModel();
        for (Statement s : statements) {
            results.add(s);
        }
        return EIInstanceFactory.INSTANCE.create(EIURI.create((String)r.getURI()), results);
    }

    @Override
    public List<EIInstance> getAllEIResourcesForUser(String user) {
        return SPARQLQueryUtil.getInstance().getAllEIResourcesForUser(user, this.model);
    }

    @Override
    public List<EIInstance> getUserInstances(String user, EIURI classUri) {
        return SPARQLQueryUtil.getInstance().getUserInstances(user, classUri, this.model);
    }

    @Override
    public void createInstance(EIInstance instance) throws Exception {
        this.updateInstance(instance, "non-null token");
    }

    @Override
    public void deleteInstance(EIInstance instance) throws Exception {
    }

    @Override
    public List<EIURI> getNewInstanceID(int count) throws Exception {
        ArrayList<EIURI> instances = new ArrayList<EIURI>(count);
        for (int i = 0; i < count; ++i) {
            String id = "http://harvard.data.eagle-i.org/i/" + UUID.randomUUID().toString();
            logger.debug((Object)("creating: " + id));
            instances.add(EIURI.create((String)id));
        }
        logger.debug((Object)("Created " + instances.size() + " ids"));
        return instances;
    }

    @Override
    public EIInstance getEmptyEIInstance(EIURI classUri, EIEntity instanceEntity) throws Exception {
        return EIInstanceFactory.createEmpty(classUri, instanceEntity);
    }

    @Override
    public String[] login(String user, String password) throws Exception {
        return new String[]{DEFAULT_USER, DEFAULT_SESSION};
    }

    @Override
    public void logout() throws Exception {
    }

    @Override
    public String whoami() throws Exception {
        return DEFAULT_USER;
    }

    @Override
    public boolean isOnline() {
        boolean state = this.model != null;
        return state;
    }

    @Override
    public String query(String sparql) throws Exception {
        return SPARQLQueryUtil.getInstance().serializeQuery(sparql, this.model);
    }

    @Override
    public void uploadInstances(String rdf) throws Exception {
        assert (rdf != null);
        StringBufferInputStream in = new StringBufferInputStream(rdf);
        this.model.read((InputStream)in, "RDF/XML");
    }
}

