/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.jena;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.datatools.config.DatatoolsConfiguration;
import org.eaglei.datatools.jena.MemoryRepositoryProvider;
import org.eaglei.datatools.provider.RepositoryProvider;
import org.eaglei.datatools.provider.RepositoryProviderFactory;

public class MemoryRepositoryProviderFactory
implements RepositoryProviderFactory {
    private static final Log log = LogFactory.getLog(MemoryRepositoryProviderFactory.class);

    @Override
    public RepositoryProvider createRepositoryProvider(DatatoolsConfiguration config) throws IOException {
        InputStream is = MemoryRepositoryProviderFactory.class.getClassLoader().getResourceAsStream(config.getDatatoolsMemoryFile());
        if (is == null) {
            log.error((Object)("Couldn't read RDF FILE to init in memory model: " + config.getDatatoolsMemoryFile()));
            throw new IOException("Couldn't read RDF FILE to init in memory model: " + config.getDatatoolsMemoryFile());
        }
        MemoryRepositoryProvider provider = new MemoryRepositoryProvider(is);
        return provider;
    }
}

