/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.jena;

import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.datatools.config.DatatoolsConfiguration;
import org.eaglei.datatools.jena.EIInstanceFactory;
import org.eaglei.datatools.jena.SPARQLQueryUtil;
import org.eaglei.datatools.provider.RepositoryProvider;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIURI;

public final class RESTRepositoryProvider
implements RepositoryProvider {
    private static final Log log = LogFactory.getLog(RESTRepositoryProvider.class);
    private static String DEFAULT_REPOSITORY = "http://alaska.data.eagle-i.org:8080/";
    private static String DEFAULT_NAMESPACE = "http://alaska.data.eagle-i.org/i/";
    private static String DEFAULT_USER = "superuser";
    private static String DEFAULT_PASSWD = "superuser";
    private ResultSet results;
    private UsernamePasswordCredentials defaultcreds = new UsernamePasswordCredentials("superuser", "superuser");

    public RESTRepositoryProvider(DatatoolsConfiguration config) {
        if (config != null) {
            DEFAULT_USER = config.getDefaultUser();
            DEFAULT_PASSWD = config.getDefaultPassword();
            DEFAULT_REPOSITORY = config.getDatatoolsRepositoryURL();
            DEFAULT_NAMESPACE = config.getDatatoolsRepositoryNamespace();
        }
    }

    private HttpClient getHttpClient() {
        HttpClient client = new HttpClient();
        client.getState().setCredentials(AuthScope.ANY, (Credentials)this.defaultcreds);
        client.getParams().setAuthenticationPreemptive(true);
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createInstance(EIInstance instance) throws Exception {
        assert (instance != null);
        assert (instance.getInstanceURI() != null);
        String id = instance.getInstanceURI().toString();
        int status = 0;
        PostMethod method = new PostMethod(RestCommands.CreateInstance.getURL());
        method.setParameter("uri", id);
        method.setParameter("format", "application/xml");
        method.setParameter("action", "create");
        method.setParameter("workspace", "http://eagle-i.org/ont/repo/1.0/NG_Published");
        method.setParameter("insert", EIInstanceFactory.INSTANCE.serialize(instance, "RDF/XML"));
        log.debug((Object)("Trying to get create instance at " + id));
        try {
            HttpClient client = this.getHttpClient();
            status = client.executeMethod((HttpMethod)method);
            String resp = this.getStringFromInputStream(method.getResponseBodyAsStream());
            if (status == 200) {
                log.info((Object)("get instance succeded with status: " + status + " response: " + resp));
            } else {
                log.error((Object)("create instance failed with status: " + status + " response: " + resp));
            }
        }
        catch (Exception e) {
            log.error((Object)("problem creating instance " + id + " at URL  " + RestCommands.CreateInstance.getURL() + " because " + e));
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteInstance(EIInstance instance) throws Exception {
        assert (instance != null);
        assert (instance.getInstanceURI() != null);
        assert (instance.getInstanceURI().toString() != null);
        String id = instance.getInstanceURI().toString();
        int status = 0;
        PostMethod method = new PostMethod(RestCommands.CreateInstance.getURL());
        method.setParameter("uri", id);
        method.setParameter("format", "application/xml");
        method.setParameter("action", "update");
        method.setParameter("workspace", "http://eagle-i.org/ont/repo/1.0/NG_Published");
        method.setParameter("delete", EIInstanceFactory.INSTANCE.serialize(instance, "RDF/XML"));
        log.debug((Object)("Trying to get delete instance at " + id));
        try {
            HttpClient client = this.getHttpClient();
            status = client.executeMethod((HttpMethod)method);
            String resp = this.getStringFromInputStream(method.getResponseBodyAsStream());
            if (status == 200) {
                log.info((Object)("delete instance succeded with status: " + status + " response: " + resp));
            } else {
                log.error((Object)("delete instance failed with status: " + status + " response: " + resp));
            }
        }
        catch (Exception e) {
            log.error((Object)("problem deleting instance " + id + " at URL  " + RestCommands.CreateInstance.getURL() + " because " + e));
        }
        finally {
            method.releaseConnection();
        }
    }

    @Override
    public List<EIInstance> getAllEIResourcesForUser(String rnav) throws Exception {
        log.debug((Object)("getAllEIResourcesForUser: " + rnav));
        String q = SPARQLQueryUtil.getInstance().getAllEIResourcesForUserQuery(rnav);
        String results = this.postQuery(q);
        Model m = ModelFactory.createDefaultModel();
        m.read((Reader)new StringReader(results), "RDF/XML");
        return EIInstanceFactory.INSTANCE.create(m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized String postQuery(String q) {
        assert (q != null);
        int status = 0;
        PostMethod method = new PostMethod(RestCommands.Query.getURL());
        method.setParameter("format", "application/xml");
        method.setParameter("default-graph-uri", "http://eagle-i.org/ont/repo/1.0/NG_Published");
        method.setParameter("query", q);
        try {
            HttpClient client = this.getHttpClient();
            status = client.executeMethod((HttpMethod)method);
            String resp = this.getStringFromInputStream(method.getResponseBodyAsStream());
            if (status == 200) {
                log.debug((Object)("query sparql endpoint succeded with status: " + status));
                String string = resp;
                return string;
            }
            log.error((Object)("query sparql endpoint  failed with status: " + status));
        }
        catch (Exception e) {
            log.error((Object)("problem query sparql endpoint at URL  " + RestCommands.Query.getURL() + " because " + e));
        }
        finally {
            method.releaseConnection();
        }
        return null;
    }

    @Override
    public List<EIInstance> getUserInstances(String rnav, EIURI classUri) throws Exception {
        String q = SPARQLQueryUtil.getInstance().getUserInstancesQuery(rnav, classUri);
        log.debug((Object)("getUserInstances: " + rnav + " URI: " + classUri));
        String results = this.postQuery(q);
        Model m = ModelFactory.createDefaultModel();
        m.read((Reader)new StringReader(results), "RDF/XML");
        log.debug((Object)("getUserInstances results: " + results));
        StringWriter s = new StringWriter();
        m.write((Writer)s, null);
        log.debug((Object)("model dump: " + s));
        return EIInstanceFactory.INSTANCE.create(m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EIInstance getInstance(EIURI instanceID) throws Exception {
        assert (instanceID != null);
        assert (instanceID.toString() != null);
        String id = null;
        try {
            id = instanceID.toString().split(DEFAULT_NAMESPACE)[1];
        }
        catch (Exception e) {
            log.error((Object)("Problem parsing the namespace: " + DEFAULT_NAMESPACE + " out of the EIRUI: " + instanceID.toString()));
            return null;
        }
        int status = 0;
        GetMethod method = new GetMethod(RestCommands.GetInstance.getURL() + "/" + id);
        HttpClient client = this.getHttpClient();
        client.getParams().setParameter("accept", (Object)"text/plain");
        log.debug((Object)("Trying to get instance " + RestCommands.GetInstance.getURL() + "/" + id));
        try {
            status = client.executeMethod((HttpMethod)method);
            if (status == 200) {
                log.debug((Object)"reading in input stream (RDF/XML)as a model");
                InputStream in = method.getResponseBodyAsStream();
                StringWriter writer = new StringWriter();
                IOUtils.copy((InputStream)in, (Writer)writer);
                EIInstance eIInstance = EIInstanceFactory.INSTANCE.create(instanceID, writer.toString(), "RDF/XML");
                return eIInstance;
            }
            log.error((Object)("get instance failed with status: " + status));
            EIInstance in = null;
            return in;
        }
        catch (Exception e) {
            log.error((Object)("problem getting instance " + instanceID.toString() + " at URL  " + RestCommands.GetInstance.getURL() + " because " + e));
            EIInstance eIInstance = null;
            return eIInstance;
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<EIURI> getNewInstanceID(int count) throws Exception {
        ArrayList<EIURI> instances;
        ResultSet results;
        block7: {
            int status = 0;
            results = null;
            PostMethod method = new PostMethod(RestCommands.GetNewInstances.getURL());
            instances = new ArrayList<EIURI>(count);
            log.info((Object)("getting " + count + " instance IDs"));
            try {
                method.setParameter("accept", "application/sparql-results+xml");
                method.setParameter("count", Integer.toString(count));
                HttpClient client = this.getHttpClient();
                status = client.executeMethod((HttpMethod)method);
                if (status == 200) {
                    String response = this.getStringFromInputStream(method.getResponseBodyAsStream());
                    results = ResultSetFactory.fromXML((String)response);
                    break block7;
                }
                log.debug((Object)("Error getting instances HTTP Status: " + status));
                List<EIURI> response = null;
                return response;
            }
            catch (Exception e) {
                log.error((Object)("problem obtaning a new instance from URL: " + RestCommands.GetNewInstances.getURL() + " " + e));
            }
            finally {
                method.releaseConnection();
            }
        }
        while (results.hasNext()) {
            QuerySolution soln = results.nextSolution();
            Resource r = soln.getResource("new");
            String id = r.getURI();
            instances.add(EIURI.create((String)id));
            log.info((Object)("Created new instance id: " + id));
        }
        log.debug((Object)("Created " + instances.size() + " ids"));
        return instances;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] login(String user, String password) throws Exception {
        int status = 0;
        ResultSet results = null;
        GetMethod method = new GetMethod(RestCommands.WhoAmI.getURL());
        HttpClient client = this.getHttpClient();
        client.getParams().setParameter("accept", (Object)"application/sparql-results+xml");
        client.getParams().setAuthenticationPreemptive(true);
        client.getState().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(user, password));
        log.debug((Object)("Trying to login at " + RestCommands.WhoAmI.getURL() + " with username " + user));
        try {
            status = client.executeMethod((HttpMethod)method);
            if (status == 200) {
                results = ResultSetFactory.fromXML((String)this.getStringFromInputStream(method.getResponseBodyAsStream()));
            }
        }
        catch (Exception e) {
            log.error((Object)("problem login into " + RestCommands.WhoAmI.getURL() + " " + e));
        }
        finally {
            method.releaseConnection();
        }
        if (status != 401) {
            QuerySolution soln = results.nextSolution();
            Literal l = soln.getLiteral("username");
            log.info((Object)("Authenticated user: " + l.getString()));
            this.defaultcreds = new UsernamePasswordCredentials(user, password);
            return new String[]{l.getString(), "temp_session"};
        }
        log.info((Object)("Could not authenticate user: " + user));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logout() throws Exception {
        int status = 0;
        PostMethod method = new PostMethod(RestCommands.Logout.getURL());
        log.debug((Object)("Trying to logout at " + RestCommands.Logout.getURL()));
        try {
            HttpClient client = this.getHttpClient();
            status = client.executeMethod((HttpMethod)method);
        }
        catch (Exception e) {
            log.error((Object)("problem with logout  " + RestCommands.Logout.getURL() + " " + e));
        }
        finally {
            method.releaseConnection();
        }
        if (status == 200) {
            log.debug((Object)"logout succeded");
            this.defaultcreds = null;
        } else {
            log.info((Object)("Could not logout user: HTTP Status: " + status));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String updateInstance(EIInstance instance, String token) throws Exception {
        assert (instance != null);
        assert (instance.getInstanceURI().toString() != null);
        int status = 0;
        PostMethod method = new PostMethod(RestCommands.CreateInstance.getURL());
        method.setParameter("format", "application/xml");
        method.setParameter("workspace", "http://eagle-i.org/ont/repo/1.0/NG_Published");
        String id = instance.getInstanceURI().toString();
        method.setParameter("uri", id);
        method.setParameter("insert", EIInstanceFactory.INSTANCE.serialize(instance, "RDF/XML"));
        log.debug((Object)("Trying to get update instance at " + RestCommands.CreateInstance.getURL() + "/" + id.split(DEFAULT_NAMESPACE)[1]));
        if (token == null) {
            method.setParameter("action", "gettoken");
        } else {
            method.setParameter("action", "update");
            method.setParameter("token", token);
        }
        try {
            HttpClient client = this.getHttpClient();
            status = client.executeMethod((HttpMethod)method);
            String resp = this.getStringFromInputStream(method.getResponseBodyAsStream());
            if (status == 200) {
                if (token == null) {
                    this.results = ResultSetFactory.fromXML((String)resp);
                    QuerySolution soln = this.results.nextSolution();
                    Resource r = soln.getResource("token");
                    String tokenid = r.getURI();
                    log.info((Object)("Retrieved new token " + tokenid));
                    String string = tokenid;
                    return string;
                }
                log.info((Object)("update succeded with status: " + status + " response size: " + resp.length()));
                String string = resp;
                return string;
            }
            log.error((Object)("update instance failed with status: " + status + " response: " + resp));
            String string = null;
            return string;
        }
        catch (Exception e) {
            log.error((Object)("problem updating instance " + id + " at URL  " + RestCommands.CreateInstance.getURL() + " because " + e));
            String string = null;
            return string;
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String whoami() throws Exception {
        int status = 0;
        ResultSet results = null;
        GetMethod method = new GetMethod(RestCommands.WhoAmI.getURL());
        HttpClient client = this.getHttpClient();
        client.getParams().setParameter("accept", (Object)"application/sparql-results+xml");
        log.debug((Object)("Trying to whoami at " + RestCommands.WhoAmI.getURL()));
        try {
            status = client.executeMethod((HttpMethod)method);
            if (status == 200) {
                results = ResultSetFactory.fromXML((String)this.getStringFromInputStream(method.getResponseBodyAsStream()));
            }
        }
        catch (Exception e) {
            log.error((Object)("problem with whoami into " + RestCommands.WhoAmI.getURL() + " " + e));
        }
        finally {
            method.releaseConnection();
        }
        if (status != 401) {
            QuerySolution soln = results.nextSolution();
            Literal l = soln.getLiteral("username");
            log.info((Object)("Authenticated user: " + l.getString()));
            return l.getString();
        }
        log.info((Object)("Could not whoami user: http status: " + status));
        return null;
    }

    @Override
    public EIInstance getEmptyEIInstance(EIURI classUri, EIEntity instanceEntity) throws Exception {
        return EIInstanceFactory.createEmpty(classUri, instanceEntity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOnline() {
        int status = 0;
        boolean online = false;
        GetMethod method = new GetMethod(RestCommands.Online.getURL());
        HttpClient client = this.getHttpClient();
        log.debug((Object)("Trying to see if Repository is available: " + RestCommands.Online.getURL()));
        try {
            status = client.executeMethod((HttpMethod)method);
            if (status == 200 || status == 401) {
                online = true;
                log.debug((Object)("Repository is available: " + RestCommands.Online.getURL() + " is available with status: " + status));
            } else {
                log.debug((Object)("Repository is unavailable: " + RestCommands.Online.getURL() + " is available with status: " + status));
            }
        }
        catch (Exception e) {
            log.error((Object)("problem checking online status of repository: " + RestCommands.Online.getURL() + " " + e));
        }
        finally {
            method.releaseConnection();
        }
        return online;
    }

    @Override
    public String query(String sparql) throws Exception {
        return this.postQuery(sparql);
    }

    private String getStringFromInputStream(InputStream in) throws IOException {
        StringWriter writer = new StringWriter();
        IOUtils.copy((InputStream)in, (Writer)writer);
        return writer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uploadInstances(String rdf) throws Exception {
        assert (rdf != null);
        int status = 0;
        PostMethod method = new PostMethod(RestCommands.Upload.getURL());
        method.setParameter("format", "text/plain");
        method.setParameter("name", "http://eagle-i.org/ont/repo/1.0/NG_Published");
        method.setParameter("type", "published");
        method.setParameter("action", "add");
        method.setParameter("content", rdf);
        try {
            HttpClient client = this.getHttpClient();
            status = client.executeMethod((HttpMethod)method);
            String resp = this.getStringFromInputStream(method.getResponseBodyAsStream());
            if (status == 200) {
                log.info((Object)("upload succeed with status: " + status + " response: " + resp));
            } else {
                log.error((Object)("upload sparql endpoint  failed with status: " + status + " response: " + resp));
            }
        }
        catch (Exception e) {
            log.error((Object)("problem with upload endpoint at URL  " + RestCommands.Upload.getURL() + " because " + e));
        }
        finally {
            method.releaseConnection();
        }
    }

    static enum RestCommands {
        GetNewInstances("repository/new"),
        WhoAmI("repository/whoami"),
        Logout("repository/logout"),
        GetInstance("i"),
        CreateInstance("repository/update"),
        Query("repository/sparql"),
        Online(""),
        Upload("repository/graph");

        private final String key;

        private RestCommands(String propKey) {
            this.key = propKey;
        }

        public String getURL() {
            return DEFAULT_REPOSITORY + this.key;
        }
    }
}

