/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.jena;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.datatools.jena.EIInstanceFactory;
import org.eaglei.datatools.jena.MemoryRepositoryProvider;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIURI;
import org.eaglei.model.jena.JenaEIOntModel;

public class SPARQLQueryUtil {
    private static final Log logger = LogFactory.getLog(MemoryRepositoryProvider.class);
    private static SPARQLQueryUtil instance;

    private SPARQLQueryUtil() {
    }

    public static SPARQLQueryUtil getInstance() {
        if (instance == null) {
            instance = new SPARQLQueryUtil();
        }
        return instance;
    }

    public String getEIResourcesByLabelQuery(EIURI rootURI, String label) {
        StringBuilder sparql = new StringBuilder();
        sparql.append("PREFIX rdf: <");
        sparql.append("http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        sparql.append("> ");
        sparql.append("PREFIX rdfs: <");
        sparql.append("http://www.w3.org/2000/01/rdf-schema#");
        sparql.append("> ");
        sparql.append("SELECT ?resource WHERE {?resource rdf:type <");
        sparql.append(rootURI.toString());
        sparql.append("> . ");
        sparql.append("?resource rdfs:label ?o ");
        sparql.append("FILTER regex(str(?o), \"" + label + "\", \"i\").}");
        return sparql.toString();
    }

    public String getAllEIResourcesForUserQuery(String user) {
        List eiClasses = JenaEIOntModel.INSTANCE.getTopLevelClasses();
        StringBuilder sparql = new StringBuilder();
        sparql.append("PREFIX rdf: <");
        sparql.append("http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        sparql.append("> ");
        sparql.append("PREFIX dc: <");
        sparql.append("http://purl.org/dc/terms");
        sparql.append("> ");
        sparql.append("PREFIX rdfs: <");
        sparql.append("http://www.w3.org/2000/01/rdf-schema#");
        sparql.append("> ");
        sparql.append("CONSTRUCT {?resource ?p ?o} WHERE {");
        for (EIClass eic : eiClasses) {
            sparql.append("{?resource a <");
            sparql.append(eic.getEntity().getURI().toString());
            sparql.append("> .?resource ?p ?o .} ");
            if (eiClasses.indexOf(eic) == eiClasses.size() - 1) continue;
            sparql.append("UNION ");
        }
        sparql.append("}");
        return sparql.toString();
    }

    public List<EIInstance> getAllEIResourcesForUser(String user, Model m) {
        return this.query(this.getAllEIResourcesForUserQuery(user), m);
    }

    public String getUserInstancesQuery(String user, EIURI classUri) {
        StringBuilder sparql = new StringBuilder();
        sparql.append("PREFIX rdf: <");
        sparql.append("http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        sparql.append("> ");
        sparql.append("PREFIX dc: <");
        sparql.append("http://purl.org/dc/terms");
        sparql.append("> ");
        sparql.append("PREFIX rdfs: <");
        sparql.append("http://www.w3.org/2000/01/rdf-schema#");
        sparql.append("> ");
        sparql.append("CONSTRUCT {$resource rdf:type <");
        sparql.append(classUri.toString());
        sparql.append("> . ?resource ?p ?o .} WHERE {$resource rdf:type <");
        sparql.append(classUri.toString());
        sparql.append("> . ?resource ?p ?o .}");
        return sparql.toString();
    }

    public List<EIInstance> getUserInstances(String user, EIURI classUri, Model m) {
        return this.query(this.getUserInstancesQuery(user, classUri), m);
    }

    public List<EIInstance> query(String sparql, Model m) {
        Query query = QueryFactory.create((String)sparql.toString());
        QueryExecution qe = QueryExecutionFactory.create((Query)query, (Model)m);
        ResultSet results = qe.execSelect();
        List resultList = ResultSetFormatter.toList((ResultSet)results);
        qe.close();
        Model resultModel = ModelFactory.createDefaultModel();
        for (QuerySolution q : resultList) {
            Resource instanceResource = q.getResource("resource");
            Resource p = q.getResource("p");
            RDFNode object = q.get("o");
            Property predicate = resultModel.createProperty(p.getURI());
            resultModel.add(resultModel.createStatement(instanceResource, predicate, object));
        }
        return EIInstanceFactory.INSTANCE.create(resultModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String serializeQuery(String sparql, Model m) {
        logger.debug((Object)("Query is: " + sparql));
        Query query = QueryFactory.create((String)sparql.toString());
        QueryExecution qe = QueryExecutionFactory.create((Query)query, (Model)m);
        ResultSet results = qe.execSelect();
        List resultList = ResultSetFormatter.toList((ResultSet)results);
        qe.close();
        Model resultModel = ModelFactory.createDefaultModel();
        for (QuerySolution q : resultList) {
            Resource instanceResource = q.getResource("resource");
            Resource p = q.getResource("p");
            RDFNode object = q.get("o");
            Property predicate = resultModel.createProperty(p.getURI());
            resultModel.add(resultModel.createStatement(instanceResource, predicate, object));
        }
        StringWriter sw = new StringWriter();
        try {
            resultModel.write((Writer)sw);
            String s = sw.toString();
            sw.flush();
            String string = s;
            return string;
        }
        finally {
            try {
                if (sw != null) {
                    sw.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)("Error serializeQuery: " + e));
            }
        }
    }
}

