package org.eaglei.datatools.config;

import static org.eaglei.datatools.config.DatatoolsConfiguration.Props.RepositoryMemoryFile;
import static org.eaglei.datatools.config.DatatoolsConfiguration.Props.RepositoryNamespace;
import static org.eaglei.datatools.config.DatatoolsConfiguration.Props.RepositoryNetworkURL;
import static org.eaglei.datatools.config.DatatoolsConfiguration.Props.RepositoryPassword;
import static org.eaglei.datatools.config.DatatoolsConfiguration.Props.RepositoryProviderFactory;
import static org.eaglei.datatools.config.DatatoolsConfiguration.Props.RepositoryUser;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;

import java.util.Properties;

/**
 * Configuration for the search application.
 */
// TODO switch to XML-based config (use something like JAXB); leaving JAXB out
// for now has some advantages
public class DatatoolsConfiguration implements Serializable
{


    private static final long serialVersionUID = 1L;


    // conf parametes in Enum form

    static enum Props
    {
        RepositoryNetworkURL("datatools.network.url"), RepositoryProviderFactory("datatools.repository.provider.factory"),
        RepositoryUser("datatools.repository.user"), RepositoryPassword("datatools.repository.password"),
        RepositoryMemoryFile("datatools.repository.memory.rdf"),RepositoryNamespace("datatools.repository.namespace");

        private Props(final String propKey)
        {
            this.propKey = propKey;
        }

        public final String propKey;
    }

    private Properties config = new Properties();


    public DatatoolsConfiguration(final File propFile) throws IOException {
        this(new FileReader(propFile));
    }
    
    public DatatoolsConfiguration(final Reader propFileContents) throws IOException {
        this.config.load(propFileContents);
        
    }


    
    
    public String getDatatoolsRepositoryProviderFactory()
    {
        return config.getProperty(RepositoryProviderFactory.propKey);
    }

    public String getDefaultUser()
    {
       
        return config.getProperty(RepositoryUser.propKey);
    }

    public String getDefaultPassword()
    {
        
        return config.getProperty(RepositoryPassword.propKey);
    }
    
    public String getDatatoolsRepositoryURL()
    {
        
        return config.getProperty(RepositoryNetworkURL.propKey);
    }
    public String getDatatoolsRepositoryNamespace()
    {
        
        return config.getProperty(RepositoryNamespace.propKey);
    }
    
    public String getDatatoolsMemoryFile()
    {
        
        return config.getProperty(RepositoryMemoryFile.propKey);
    }
    
    public Properties getProperties() {
        return this.config;
    }
}
