/**
 * The eagle-i consortium
 * Harvard University
 * Jul 9, 2010
 */
package org.eaglei.datatools.jena;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;

/**
 * @author Daniela Bourges-Waldegg
 *
 */
public class MetadataConstants {
    //read-onlymetadata; would be better to read from repository ontology
	//Use our own labels for now
    //datatools
	private static final EIURI capturedWithUri = EIURI.create("http://eagle-i.org/ont/datatools/1.0/captured_with");
    private static final EIEntity capturedWithEntity = EIEntity.create(capturedWithUri, "Captured with");

    //workflow	
    private static final EIURI WFStateUri = EIURI.create("http://eagle-i.org/ont/repo/1.0/hasWorkflowState");
	private static final EIEntity WFStateEntity = EIEntity.create(WFStateUri,"Workflow state");
	
	private static final EIURI WFOwnerUri = EIURI.create("http://eagle-i.org/ont/repo/1.0/hasWorkflowOwner");
	private static final EIEntity WFOwnerEntity = EIEntity.create(WFOwnerUri, "Workflow owner");
	
	//dcterms
	private static final EIURI createdUri = EIURI.create("http://purl.org/dc/terms/created");
	private static final EIEntity createdEntity = EIEntity.create(createdUri, "Creation date");
	
	private static final EIURI modifiedUri = EIURI.create("http://purl.org/dc/terms/modified");
	private static final EIEntity modifiedEntity = EIEntity.create(modifiedUri, "Last modification date");
	
	private static final EIURI creatorUri = EIURI.create("http://purl.org/dc/terms/creator");
	private static final EIEntity creatorEntity = EIEntity.create(creatorUri, "Creator");
	
	private static final EIURI mediatorUri = EIURI.create("http://purl.org/dc/terms/mediator");
	private static final EIEntity mediatorEntity = EIEntity.create(mediatorUri, "Mediator");
	
	private static final EIURI contributorUri = EIURI.create("http://purl.org/dc/terms/contributor");
	private static final EIEntity contributorEntity = EIEntity.create(contributorUri, "Contributor");
	
	public static final Map<EIURI, EIEntity> readOnlyResources = new HashMap<EIURI, EIEntity>();
	static {
		readOnlyResources.put(WFStateUri, WFStateEntity);
		readOnlyResources.put(WFOwnerUri, WFOwnerEntity);
		readOnlyResources.put(creatorUri, creatorEntity);
		readOnlyResources.put(mediatorUri, mediatorEntity);
		readOnlyResources.put(contributorUri, contributorEntity);
	}
	
	public static final Map<EIURI, EIEntity> readOnlyLiterals = new HashMap<EIURI, EIEntity>();
	static {
		readOnlyLiterals.put(capturedWithUri, capturedWithEntity);
		readOnlyLiterals.put(createdUri, createdEntity);
		readOnlyLiterals.put(modifiedUri, modifiedEntity);
	}
	
}
