/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.etl.server;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import java.text.StringCharacterIterator;

public class ETLSPARQLQueryUtil {
    public static String getEIResourcesByAllPropertiesQuery(Model rdfModel) {
        StringBuilder sparql = new StringBuilder();
        sparql.append("PREFIX rdf: <");
        sparql.append("http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        sparql.append("> ");
        sparql.append("PREFIX rdfs: <");
        sparql.append("http://www.w3.org/2000/01/rdf-schema#");
        sparql.append("> ");
        sparql.append("SELECT ?resource WHERE {");
        StmtIterator stmtIterator = rdfModel.listStatements();
        int i = 0;
        while (stmtIterator.hasNext()) {
            Statement stmtMap = stmtIterator.nextStatement();
            Resource subjectMap = stmtMap.getSubject();
            Property predicateMap = stmtMap.getPredicate();
            RDFNode objectMap = stmtMap.getObject();
            sparql.append("?resource <" + predicateMap.getURI() + "> ");
            if (objectMap.isResource()) {
                Resource objResource = (Resource)objectMap;
                sparql.append("\t <" + objResource.getURI() + "> . ");
            } else {
                sparql.append("?o" + i + " FILTER regex(str(?o" + i + "), \"" + ETLSPARQLQueryUtil.forRegex(objectMap.toString()).split("\\^\\^")[0].replace("", "\"").replace("", "\"").replace("\"", "\\\"").trim() + "\", \"i\").");
            }
            ++i;
        }
        sparql.append("}");
        return sparql.toString();
    }

    public static String getEIResourcesQueryButnotWithPassProperty(Model rdfModel, Property property) {
        StringBuilder sparql = new StringBuilder();
        sparql.append("PREFIX rdf: <");
        sparql.append("http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        sparql.append("> ");
        sparql.append("PREFIX rdfs: <");
        sparql.append("http://www.w3.org/2000/01/rdf-schema#");
        sparql.append("> ");
        sparql.append("SELECT ?resource WHERE {");
        StmtIterator stmtIterator = rdfModel.listStatements();
        int i = 0;
        while (stmtIterator.hasNext()) {
            Statement stmtMap = stmtIterator.nextStatement();
            Resource subjectMap = stmtMap.getSubject();
            Property predicateMap = stmtMap.getPredicate();
            RDFNode objectMap = stmtMap.getObject();
            if (predicateMap.toString().equals(property.toString())) continue;
            sparql.append("?resource <" + predicateMap.getURI() + "> ");
            if (objectMap.isResource()) {
                Resource objResource = (Resource)objectMap;
                sparql.append("\t <" + objResource.getURI() + "> . ");
            } else {
                sparql.append("?o" + i + " FILTER regex(str(?o" + i + "), \"" + ETLSPARQLQueryUtil.forRegex(objectMap.toString()).split("\\^\\^")[0].replace("", "\"").replace("", "\"").replace("\"", "\\\"").trim() + "\", \"i\").");
            }
            ++i;
        }
        sparql.append("}");
        return sparql.toString();
    }

    public static String getEIResourcesByOnlyTypeANDRdfsLabel(Model rdfModel) {
        StringBuilder sparql = new StringBuilder();
        sparql.append("PREFIX rdf: <");
        sparql.append("http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        sparql.append("> ");
        sparql.append("PREFIX rdfs: <");
        sparql.append("http://www.w3.org/2000/01/rdf-schema#");
        sparql.append("> ");
        sparql.append("SELECT ?resource WHERE {");
        StmtIterator stmtIterator = rdfModel.listStatements();
        while (stmtIterator.hasNext()) {
            Statement stmtMap = stmtIterator.nextStatement();
            Resource subjectMap = stmtMap.getSubject();
            Property predicateMap = stmtMap.getPredicate();
            RDFNode objectMap = stmtMap.getObject();
            if (!predicateMap.getURI().equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#type") && !predicateMap.getURI().equals("http://www.w3.org/2000/01/rdf-schema#label")) continue;
            sparql.append("?resource <" + predicateMap.getURI() + "> ");
            if (objectMap.isResource()) {
                Resource objResource = (Resource)objectMap;
                sparql.append("\t <" + objResource.getURI() + "> . ");
                continue;
            }
            sparql.append("?o FILTER regex(str(?o), \"" + ETLSPARQLQueryUtil.forRegex(objectMap.toString()).split("\\^\\^")[0].replace("", "\"").replace("", "\"").replace("\"", "\\\"") + "\", \"i\").");
        }
        sparql.append("}");
        return sparql.toString();
    }

    public static String forRegex(String aRegexFragment) {
        StringBuilder result = new StringBuilder();
        StringCharacterIterator iterator = new StringCharacterIterator(aRegexFragment);
        char character = iterator.current();
        while (character != '\uffff') {
            if (character == '.') {
                result.append("\\\\.");
            } else if (character == '\\') {
                result.append("\\\\\\");
            } else if (character == '?') {
                result.append("\\\\?");
            } else if (character == '*') {
                result.append("\\\\*");
            } else if (character == '+') {
                result.append("\\\\+");
            } else if (character == '&') {
                result.append("\\\\&");
            } else if (character == ':') {
                result.append("\\\\:");
            } else if (character == '{') {
                result.append("\\\\{");
            } else if (character == '}') {
                result.append("\\\\}");
            } else if (character == '[') {
                result.append("\\\\[");
            } else if (character == ']') {
                result.append("\\\\]");
            } else if (character == '(') {
                result.append("\\\\(");
            } else if (character == ')') {
                result.append("\\\\)");
            } else if (character == '^') {
                result.append("^");
            } else if (character == '$') {
                result.append("\\\\$");
            } else {
                result.append(character);
            }
            character = iterator.next();
        }
        return result.toString();
    }
}

