/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.jena;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIURI;

public class SPARQLQueryUtil {
    private static final Log logger = LogFactory.getLog(SPARQLQueryUtil.class);
    private static SPARQLQueryUtil instance;

    private SPARQLQueryUtil() {
    }

    public static SPARQLQueryUtil getInstance() {
        if (instance == null) {
            instance = new SPARQLQueryUtil();
        }
        return instance;
    }

    public String getEIResourcesByLabelQuery(EIURI rootURI, String label) {
        StringBuilder sparql = new StringBuilder();
        sparql.append("PREFIX rdf: <");
        sparql.append("http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        sparql.append("> ");
        sparql.append("PREFIX rdfs: <");
        sparql.append("http://www.w3.org/2000/01/rdf-schema#");
        sparql.append("> ");
        sparql.append("SELECT ?resource WHERE {?resource rdf:type <");
        sparql.append(rootURI.toString());
        sparql.append("> . ");
        sparql.append("?resource rdfs:label ?o ");
        sparql.append("FILTER regex(str(?o), \"" + label + "\", \"i\").}");
        return sparql.toString();
    }

    public String getWFStatesQuery(String user) {
        StringBuilder sparql = new StringBuilder();
        sparql.append("PREFIX repo: <");
        sparql.append("http://eagle-i.org/ont/repo/1.0/");
        sparql.append(">");
        sparql.append("SELECT DISTINCT ?state WHERE {?state repo:hasWriter ?role . <");
        sparql.append(user);
        sparql.append("> repo:hasRole ?role .}");
        return sparql.toString();
    }

    public String getRetrieveLabelQuery(EIURI uri) {
        StringBuilder sparql = new StringBuilder();
        sparql.append("PREFIX rdfs: <");
        sparql.append("http://www.w3.org/2000/01/rdf-schema#");
        sparql.append("> ");
        sparql.append("SELECT DISTINCT ?l WHERE {<");
        sparql.append(uri.toString());
        sparql.append("> rdfs:label ?l}");
        return sparql.toString();
    }

    public String getAllResourcesQuery(String user) {
        StringBuilder graphPattern = new StringBuilder();
        graphPattern.append("?s repo:hasWorkflowState ?state . ");
        graphPattern.append(this.allTypesPattern());
        return this.assembleQuery(user, graphPattern.toString());
    }

    public String getResourcesOfClassQuery(String user, EIURI classUri) {
        return this.getFilterQuery(user, classUri, null, null);
    }

    public String getAllResourcesInLabQuery(String user, EIURI labUri) {
        return this.getFilterQuery(user, null, null, labUri);
    }

    public String getFilterQuery(String user, EIURI classUri, EIURI state, EIURI lab) {
        return this.assembleQuery(user, this.graphPattern(classUri, state, lab));
    }

    private String assembleQuery(String user, String graphPattern) {
        StringBuilder sparql = new StringBuilder();
        sparql.append(this.namespaces());
        sparql.append("SELECT DISTINCT ");
        sparql.append("?s ?t ?l ?date ?own ?state ");
        sparql.append("WHERE {");
        sparql.append("?s rdfs:label ?l . ");
        sparql.append("OPTIONAL{?s dcterms:created ?date} . ");
        sparql.append(this.typePattern());
        sparql.append(graphPattern);
        sparql.append(this.ownerPattern(user));
        sparql.append("} order by ?l");
        return sparql.toString();
    }

    private String namespaces() {
        StringBuilder namespaces = new StringBuilder();
        namespaces.append("PREFIX dcterms: <");
        namespaces.append("http://purl.org/dc/terms/");
        namespaces.append("> ");
        namespaces.append("PREFIX rdf: <");
        namespaces.append("http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        namespaces.append("> ");
        namespaces.append("PREFIX rdfs: <");
        namespaces.append("http://www.w3.org/2000/01/rdf-schema#");
        namespaces.append("> ");
        namespaces.append("PREFIX repo: <");
        namespaces.append("http://eagle-i.org/ont/repo/1.0/");
        namespaces.append("> ");
        return namespaces.toString();
    }

    private String typePattern() {
        return "graph ?g{?s rdf:type ?t} filter(?g != repo:NG_Inferred) . ";
    }

    private String allTypesPattern() {
        StringBuilder allTypes = new StringBuilder();
        allTypes.append("?s rdf:type ?rt . ");
        allTypes.append("?rt <http://eagle-i.org/ont/app/1.0/inClassGroup> <http://eagle-i.org/ont/app/1.0/ClassGroup/resourceRoot> ");
        allTypes.append("filter(?rt != <");
        allTypes.append("http://purl.obolibrary.org/obo/OBI_0000245");
        allTypes.append("> && ?rt != <");
        allTypes.append("http://xmlns.com/foaf/0.1/Person");
        allTypes.append(">) .");
        return allTypes.toString();
    }

    private String ownerPattern(String user) {
        StringBuilder owner = new StringBuilder();
        owner.append("OPTIONAL {?s repo:hasWorkflowOwner ?own} FILTER(!bound(?own) || ?own = <");
        owner.append(user);
        owner.append(">)");
        return owner.toString();
    }

    private String graphPattern(EIURI classUri, EIURI state, EIURI lab) {
        StringBuilder graphPattern = new StringBuilder();
        if (classUri != null) {
            graphPattern.append("?s rdf:type <");
            graphPattern.append(classUri.toString());
            graphPattern.append("> .");
        } else {
            graphPattern.append(this.allTypesPattern());
        }
        if (state != null) {
            graphPattern.append("?s repo:hasWorkflowState <");
            graphPattern.append(state.toString());
            graphPattern.append("> . ?s repo:hasWorkflowState ?state .");
        } else {
            graphPattern.append("OPTIONAL {?s repo:hasWorkflowState ?state} . ");
        }
        if (lab != null) {
            graphPattern.append("?s ?p1 <");
            graphPattern.append(lab.toString());
            graphPattern.append("> . ");
        }
        return graphPattern.toString();
    }
}

