/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.interim.cores;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.eaglei.datatools.excel.ExcelUtils;
import org.eaglei.datatools.interim.cores.Cores3Mappings;
import org.eaglei.datatools.interim.cores.Mapping;

public class Cores3ExcelParser {
    private List<ProcessedTab> processedTabs = new ArrayList<ProcessedTab>();

    public Cores3ExcelParser(String fileName) {
        Workbook wb = ExcelUtils.openWorkBook(fileName);
        int n = wb.getNumberOfSheets();
        for (int i = 0; i < n; ++i) {
            Sheet sheet = wb.getSheetAt(i);
            String tabName = sheet.getSheetName().trim().replaceAll("\\s{1,}", "_").replaceAll("\\W{1,}", "");
            if (Cores3Mappings.FIRST_ROWS.get(tabName) == null) continue;
            int firstRow = Cores3Mappings.FIRST_ROWS.get(tabName);
            Mapping classMapping = Cores3Mappings.MAPPINGS.get(tabName);
            List<Map<String, String>> list = ExcelUtils.processTab(sheet, firstRow);
            this.processedTabs.add(new ProcessedTab(classMapping, list));
        }
    }

    public List<ProcessedTab> getProcessedTabs() {
        return this.processedTabs;
    }

    public class ProcessedTab {
        private Mapping classMapping;
        private List<Map<String, String>> tabData;

        public ProcessedTab(Mapping classMapping, List<Map<String, String>> tabData) {
            this.classMapping = classMapping;
            this.tabData = tabData;
        }

        public Mapping getClassMapping() {
            return this.classMapping;
        }

        public List<Map<String, String>> getTabData() {
            return this.tabData;
        }
    }
}

