/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.jena;

import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.datatools.config.DatatoolsConfiguration;
import org.eaglei.datatools.jena.EIInstanceFactory;
import org.eaglei.datatools.jena.SPARQLQueryUtil;
import org.eaglei.datatools.provider.EIDataToolsProviderException;
import org.eaglei.datatools.provider.RepositoryProvider;
import org.eaglei.datatools.provider.RepositoryProviderMessages;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIURI;

public final class RESTRepositoryProvider
implements RepositoryProvider {
    protected static final String READ_VIEW = "user";
    private static final String FORMAT_VALUE = "application/xml";
    private static final String RDF_FORMAT = "RDF/XML";
    private static final Log log = LogFactory.getLog(RESTRepositoryProvider.class);
    private static final boolean isDebugEnabled = log.isDebugEnabled();
    private static String DEFAULT_REPOSITORY = "";
    private static String DEFAULT_NAMESPACE = "";
    private ResultSet results;
    private Map<String, HttpClient> clientMap = new HashMap<String, HttpClient>();

    public RESTRepositoryProvider(DatatoolsConfiguration config) {
        if (config != null) {
            DEFAULT_REPOSITORY = config.getDatatoolsRepositoryURL();
            DEFAULT_NAMESPACE = config.getDatatoolsRepositoryNamespace();
        }
    }

    private HttpClient makeHttpClient(String username, String password) {
        HttpClient client = new HttpClient();
        client.setHttpConnectionManager((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
        client.getState().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
        client.getParams().setAuthenticationPreemptive(true);
        return client;
    }

    private HttpClient getHttpClient(String session) {
        if (this.clientMap.get(session) == null) {
            return null;
        }
        return this.clientMap.get(session);
    }

    protected void setWriteParameters(PostMethod method, String id) {
        method.setParameter("uri", id);
        method.setParameter("format", FORMAT_VALUE);
        method.setRequestHeader("charset", "UTF-8");
    }

    protected void setReadParameters(PostMethod method) {
        method.setParameter("format", FORMAT_VALUE);
        method.setParameter("view", READ_VIEW);
        method.setParameter("noinferred", "true");
        method.setRequestHeader("charset", "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createInstance(String session, EIInstance instance) throws Exception {
        block8: {
            if (session == null) {
                log.error((Object)"Invalid Session - request cannot be completed");
                throw new EIDataToolsProviderException("No session information was found");
            }
            if (instance == null || instance.getInstanceURI() == null) {
                log.warn((Object)"Trying to create (duplicate) instance with null instance or null instance URI");
                return;
            }
            String id = instance.getInstanceURI().toString();
            int status = 0;
            PostMethod method = new PostMethod(RestCommands.CreateInstance.getURL());
            this.setWriteParameters(method, id);
            method.setParameter("workspace", "http://eagle-i.org/ont/repo/1.0/NG_DefaultWorkspace");
            method.setParameter("action", "create");
            String instanceAsString = EIInstanceFactory.INSTANCE.serialize(instance, RDF_FORMAT);
            if (isDebugEnabled) {
                log.debug((Object)("dump data: " + instanceAsString));
            }
            method.setParameter("insert", instanceAsString);
            if (isDebugEnabled) {
                log.debug((Object)("Trying to get create instance at " + id));
            }
            try {
                HttpClient client = this.getHttpClient(session);
                status = client.executeMethod((HttpMethod)method);
                String resp = this.getStringFromInputStream(method.getResponseBodyAsStream());
                if (status == 200) {
                    log.info((Object)("get instance succeded with status: " + status + " response: " + resp));
                    break block8;
                }
                log.error((Object)("create instance failed with status: " + status + " response: " + resp));
                throw new EIDataToolsProviderException(RepositoryProviderMessages.getFailedMessage("create", status));
            }
            finally {
                method.releaseConnection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createInstance(String session, String rdfString, String id) throws Exception {
        block8: {
            if (session == null) {
                log.error((Object)"Invalid Session - request cannot be completed");
                throw new EIDataToolsProviderException("No session information was found");
            }
            if (rdfString == null) {
                log.warn((Object)"Trying to create (duplicate) instance with null instance or null instance URI");
                return;
            }
            int status = 0;
            PostMethod method = new PostMethod(RestCommands.CreateInstance.getURL());
            this.setWriteParameters(method, id);
            method.setParameter("workspace", "http://eagle-i.org/ont/repo/1.0/NG_DefaultWorkspace");
            method.setParameter("action", "create");
            if (isDebugEnabled) {
                log.debug((Object)("dump data: " + rdfString));
            }
            method.setParameter("insert", rdfString);
            if (isDebugEnabled) {
                log.debug((Object)("Trying to get create instance at " + id));
            }
            try {
                HttpClient client = this.getHttpClient(session);
                status = client.executeMethod((HttpMethod)method);
                String resp = this.getStringFromInputStream(method.getResponseBodyAsStream());
                if (status == 200) {
                    log.info((Object)("get instance succeded with status: " + status + " response: " + resp));
                    break block8;
                }
                log.error((Object)("create instance failed with status: " + status + " response: " + resp));
                throw new EIDataToolsProviderException(RepositoryProviderMessages.getFailedMessage("create", status));
            }
            finally {
                method.releaseConnection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteInstance(String session, EIInstance instance) throws Exception {
        block7: {
            if (session == null) {
                log.error((Object)"Invalid Session - request cannot be completed");
                throw new EIDataToolsProviderException("No session information was found");
            }
            if (instance == null || instance.getInstanceURI() == null || instance.getInstanceURI().toString() == null) {
                return;
            }
            String id = instance.getInstanceURI().toString();
            String token = this.makeResponseRequest(session, instance);
            int status = 0;
            PostMethod method = new PostMethod(RestCommands.CreateInstance.getURL());
            this.setWriteParameters(method, id);
            method.setParameter("action", "update");
            method.setParameter("token", token);
            method.setParameter("delete", this.createDeleteStatement(instance));
            if (isDebugEnabled) {
                log.debug((Object)("Trying to get delete instance at " + id));
            }
            try {
                HttpClient client = this.getHttpClient(session);
                status = client.executeMethod((HttpMethod)method);
                String resp = this.getStringFromInputStream(method.getResponseBodyAsStream());
                if (status == 200) {
                    log.info((Object)("delete instance succeded with status: " + status + " response: " + resp));
                    break block7;
                }
                log.error((Object)("delete instance failed with status: " + status + " response: " + resp));
                throw new EIDataToolsProviderException(RepositoryProviderMessages.getFailedMessage("delete", status));
            }
            finally {
                method.releaseConnection();
            }
        }
    }

    @Override
    public String updateInstance(String session, EIInstance instance, String token) throws Exception {
        if (session == null) {
            log.error((Object)"Invalid Session - request cannot be completed");
            throw new EIDataToolsProviderException("No session information was found");
        }
        if (instance == null || instance.getInstanceURI() == null) {
            log.warn((Object)"Trying to update instance with null instance or null instance URI");
            return null;
        }
        if (token == null) {
            return this.makeResponseRequest(session, instance);
        }
        int status = 0;
        PostMethod method = new PostMethod(RestCommands.CreateInstance.getURL());
        String id = instance.getInstanceURI().toString();
        this.setWriteParameters(method, id);
        method.setParameter("insert", EIInstanceFactory.INSTANCE.serialize(instance, RDF_FORMAT));
        method.setParameter("delete", this.createDeleteStatement(instance));
        if (isDebugEnabled) {
            log.debug((Object)("Trying to get update instance at " + id));
        }
        method.setParameter("action", "update");
        method.setParameter("token", token);
        try {
            HttpClient client = this.getHttpClient(session);
            status = client.executeMethod((HttpMethod)method);
            String resp = this.getStringFromInputStream(method.getResponseBodyAsStream());
            if (status == 200) {
                log.info((Object)("update succeded with status: " + status + " response size: " + resp.length()));
                String string = resp;
                return string;
            }
            log.error((Object)("update instance failed with status: " + status + " response: " + resp));
            throw new EIDataToolsProviderException(RepositoryProviderMessages.getFailedMessage("update", status));
        }
        finally {
            method.releaseConnection();
        }
    }

    public String updateInstance(String session, String rdfString, String id, String token) throws Exception {
        if (session == null) {
            log.error((Object)"Invalid Session - request cannot be completed");
            throw new EIDataToolsProviderException("No session information was found");
        }
        if (rdfString == null) {
            log.warn((Object)"Trying to create (duplicate) instance with null instance or null instance URI");
            return null;
        }
        if (token == null) {
            return this.makeResponseRequest(session, rdfString, id);
        }
        int status = 0;
        PostMethod method = new PostMethod(RestCommands.CreateInstance.getURL());
        this.setWriteParameters(method, id);
        method.setParameter("insert", rdfString);
        method.setParameter("delete", this.createDeleteStatement(id));
        if (isDebugEnabled) {
            log.debug((Object)("Trying to get update instance at " + id));
        }
        method.setParameter("action", "update");
        method.setParameter("token", token);
        try {
            HttpClient client = this.getHttpClient(session);
            status = client.executeMethod((HttpMethod)method);
            String resp = this.getStringFromInputStream(method.getResponseBodyAsStream());
            if (status == 200) {
                log.info((Object)("update succeded with status: " + status + " response size: " + resp.length()));
                String string = resp;
                return string;
            }
            log.error((Object)("update instance failed with status: " + status + " response: " + resp));
            throw new EIDataToolsProviderException(RepositoryProviderMessages.getFailedMessage("update", status));
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createDeleteStatement(EIInstance instance) {
        EIURI id = instance.getInstanceURI();
        String s = null;
        String wildcard = "<" + id.toString() + "> <http://eagle-i.org/ont/repo/1.0/MatchAnything> <http://eagle-i.org/ont/repo/1.0/MatchAnything> .";
        log.info((Object)"Trying to create a wildcard graph to delete all the statements");
        Model m = ModelFactory.createDefaultModel();
        StringReader st = new StringReader(wildcard);
        m.read((Reader)st, null, "N-TRIPLE");
        StringWriter sw = new StringWriter();
        try {
            m.write((Writer)sw, RDF_FORMAT);
            s = sw.toString();
            sw.flush();
        }
        finally {
            try {
                if (sw != null) {
                    sw.close();
                }
            }
            catch (IOException e) {
                log.warn((Object)("createDelete statement: " + e));
            }
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createDeleteStatement(String id) {
        String s = null;
        String wildcard = "<" + id + "> <http://eagle-i.org/ont/repo/1.0/MatchAnything> <http://eagle-i.org/ont/repo/1.0/MatchAnything> .";
        log.info((Object)"Trying to create a wildcard graph to delete all the statements");
        Model m = ModelFactory.createDefaultModel();
        StringReader st = new StringReader(wildcard);
        m.read((Reader)st, null, "N3");
        StringWriter sw = new StringWriter();
        try {
            m.write((Writer)sw, RDF_FORMAT);
            s = sw.toString();
            sw.flush();
        }
        finally {
            try {
                if (sw != null) {
                    sw.close();
                }
            }
            catch (IOException e) {
                log.warn((Object)("createDelete statement: " + e));
            }
        }
        return s;
    }

    protected String makeResponseRequest(String session, EIInstance instance) throws Exception {
        PostMethod method = new PostMethod(RestCommands.CreateInstance.getURL());
        String id = instance.getInstanceURI().toString();
        this.setWriteParameters(method, id);
        method.setParameter("insert", EIInstanceFactory.INSTANCE.serialize(instance, RDF_FORMAT));
        method.setParameter("action", "gettoken");
        int status = 0;
        try {
            HttpClient client = this.getHttpClient(session);
            status = client.executeMethod((HttpMethod)method);
            String resp = this.getStringFromInputStream(method.getResponseBodyAsStream());
            if (status == 200) {
                String string = this.getResponseToken(resp);
                return string;
            }
            if (status == 409) {
                log.error((Object)("stale token: " + status + " response: " + resp));
                throw new EIDataToolsProviderException("Someone else is changing or has changed this resource; repository message is: " + resp);
            }
            log.error((Object)("get token failed with status: " + status + " response: " + resp));
            throw new EIDataToolsProviderException(RepositoryProviderMessages.getFailedMessage("get token", status));
        }
        finally {
            method.releaseConnection();
        }
    }

    protected String makeResponseRequest(String session, String rdfString, String id) throws Exception {
        PostMethod method = new PostMethod(RestCommands.CreateInstance.getURL());
        this.setWriteParameters(method, id);
        method.setParameter("insert", rdfString);
        method.setParameter("action", "gettoken");
        int status = 0;
        try {
            HttpClient client = this.getHttpClient(session);
            status = client.executeMethod((HttpMethod)method);
            String resp = this.getStringFromInputStream(method.getResponseBodyAsStream());
            if (status == 200) {
                String string = this.getResponseToken(resp);
                return string;
            }
            log.error((Object)("get token failed with status: " + status + " response: " + resp));
            throw new EIDataToolsProviderException(RepositoryProviderMessages.getFailedMessage("get token", status));
        }
        finally {
            method.releaseConnection();
        }
    }

    private String getResponseToken(String resp) {
        this.results = ResultSetFactory.fromXML((String)resp);
        QuerySolution soln = this.results.nextSolution();
        Resource r = soln.getResource("token");
        String tokenid = r.getURI();
        log.info((Object)("Retrieved new token " + tokenid));
        return tokenid;
    }

    @Override
    public List<EIInstance> getAllResources(String session, String rnav) throws Exception {
        if (session == null) {
            log.error((Object)"Invalid Session - request cannot be completed");
            throw new EIDataToolsProviderException("No session information was found");
        }
        if (isDebugEnabled) {
            log.debug((Object)("getAllResourcesForUser: " + rnav));
        }
        String q = SPARQLQueryUtil.getInstance().getAllResourcesQuery(rnav);
        return this.EIQuery(session, q);
    }

    private synchronized String postQuery(String session, String q) throws Exception {
        return this.postQuery(session, q, READ_VIEW);
    }

    private synchronized String postQuery(String session, String q, String view) throws Exception {
        if (q == null) {
            log.warn((Object)"Null query!");
            return null;
        }
        int status = 0;
        PostMethod method = new PostMethod(RestCommands.Query.getURL());
        if (isDebugEnabled) {
            log.debug((Object)("Trying to query: " + RestCommands.Query.getURL()));
        }
        this.setReadParameters(method);
        method.setParameter("view", view);
        method.setParameter("query", q);
        try {
            HttpClient client = this.getHttpClient(session);
            status = client.executeMethod((HttpMethod)method);
            String resp = this.getStringFromInputStream(method.getResponseBodyAsStream());
            if (status == 200) {
                if (isDebugEnabled) {
                    log.debug((Object)("query sparql endpoint succeded with status: " + status));
                }
                String string = resp;
                return string;
            }
            log.error((Object)("query sparql endpoint  failed with status: " + status));
            log.error((Object)("Message from repository: " + resp));
            throw new EIDataToolsProviderException(RepositoryProviderMessages.getFailedMessage("query", status));
        }
        finally {
            method.releaseConnection();
        }
    }

    @Override
    public List<EIInstance> getResourcesOfClass(String session, String rnav, EIURI classUri) throws Exception {
        if (session == null) {
            log.error((Object)"Invalid Session - request cannot be completed");
            throw new EIDataToolsProviderException("No session information was found");
        }
        String q = SPARQLQueryUtil.getInstance().getResourcesOfClassQuery(rnav, classUri);
        if (isDebugEnabled) {
            log.debug((Object)("getResourcesOfClass: " + rnav + " URI: " + classUri));
        }
        return this.EIQuery(session, q);
    }

    @Override
    public EIInstance getInstance(String session, EIURI instanceID) throws Exception {
        if (session == null) {
            log.error((Object)"Invalid Session - request cannot be completed");
            throw new EIDataToolsProviderException("No session information was found");
        }
        if (instanceID == null || instanceID.toString() == null) {
            log.warn((Object)"Trying to get instance for null EIURI");
            return null;
        }
        int status = 0;
        PostMethod method = new PostMethod(RestCommands.GetInstance.getURL());
        this.setReadParameters(method);
        method.setParameter("uri", instanceID.toString());
        HttpClient client = this.getHttpClient(session);
        if (isDebugEnabled) {
            log.debug((Object)("Trying to get instance " + instanceID.toString()));
        }
        try {
            status = client.executeMethod((HttpMethod)method);
            if (status == 200) {
                if (isDebugEnabled) {
                    log.debug((Object)"started with an OK status");
                }
                if (isDebugEnabled) {
                    log.debug((Object)"reading in input stream as a model");
                }
                String response = this.getStringFromInputStream(method.getResponseBodyAsStream());
                EIInstance instance = EIInstanceFactory.INSTANCE.create(instanceID, response, RDF_FORMAT);
                if (isDebugEnabled) {
                    log.debug((Object)("got instance contents: " + instance));
                }
                EIInstance eIInstance = instance;
                return eIInstance;
            }
            log.error((Object)("get instance " + instanceID + " failed with status: " + status));
            throw new EIDataToolsProviderException(RepositoryProviderMessages.getFailedMessage("get instance", status));
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<EIURI> getNewInstanceID(String session, int count) throws Exception {
        ArrayList<EIURI> instances;
        ResultSet results;
        block7: {
            if (session == null) {
                throw new EIDataToolsProviderException("No session information was found");
            }
            int status = 0;
            results = null;
            PostMethod method = new PostMethod(RestCommands.GetNewInstances.getURL());
            instances = new ArrayList<EIURI>(count);
            log.info((Object)("getting " + count + " instance IDs"));
            try {
                method.setParameter("accept", "application/sparql-results+xml");
                method.setParameter("count", Integer.toString(count));
                HttpClient client = this.getHttpClient(session);
                status = client.executeMethod((HttpMethod)method);
                String response = this.getStringFromInputStream(method.getResponseBodyAsStream());
                if (status == 200) {
                    results = ResultSetFactory.fromXML((String)response);
                    break block7;
                }
                log.error((Object)("Error getting instance IDs; HTTP Status: " + status + " Response: " + response));
                throw new EIDataToolsProviderException(RepositoryProviderMessages.getFailedMessage("get new ID", status));
            }
            finally {
                method.releaseConnection();
            }
        }
        while (results.hasNext()) {
            QuerySolution soln = results.nextSolution();
            Resource r = soln.getResource("new");
            String id = r.getURI();
            instances.add(EIURI.create((String)id));
            log.info((Object)("Created new instance id: " + id));
        }
        if (isDebugEnabled) {
            log.debug((Object)("Created " + instances.size() + " ids"));
        }
        return instances;
    }

    protected String[] getUserInformation(String session, HttpClient client) throws Exception {
        int status = 0;
        ResultSet results = null;
        String error = null;
        GetMethod method = new GetMethod(RestCommands.WhoAmI.getURL());
        try {
            status = client.executeMethod((HttpMethod)method);
            if (status == 200) {
                results = ResultSetFactory.fromXML((String)this.getStringFromInputStream(method.getResponseBodyAsStream()));
                if (isDebugEnabled) {
                    log.debug((Object)"succeeded in logging in");
                }
            } else {
                error = this.getStringFromInputStream(method.getResponseBodyAsStream());
            }
        }
        catch (Exception e) {
            log.error((Object)("problem getting user info " + RestCommands.WhoAmI.getURL() + " Message from repo: " + this.getStringFromInputStream(method.getResponseBodyAsStream()) + "; Exception " + e));
            throw new EIDataToolsProviderException(RepositoryProviderMessages.getFailedMessage("get user information", 0));
        }
        finally {
            method.releaseConnection();
        }
        if (status == 404) {
            log.error((Object)"Repo unavailable");
            throw new EIDataToolsProviderException("The repository is currently not available");
        }
        if (status != 401 && results != null) {
            String sessionId;
            QuerySolution soln = results.nextSolution();
            Literal username = soln.getLiteral("username");
            Resource userURI = soln.getResource("uri");
            log.info((Object)("Authenticated user: " + username.getString() + " " + userURI.getURI()));
            String string = sessionId = session == null ? UUID.randomUUID().toString() : session;
            if (session == null) {
                this.clientMap.put(sessionId, client);
            }
            log.info((Object)("session ID: " + sessionId + "; new session? " + (session == null ? "yes" : "no")));
            List<String> states = this.getWFStatesList(sessionId, userURI.getURI());
            states.add(LoginFields.USERNAME.getValue(), username.getString());
            states.add(LoginFields.SESSION.getValue(), sessionId);
            states.add(LoginFields.USER_URI.getValue(), userURI.getURI());
            log.info((Object)("has login fields and states " + states.size()));
            return states.toArray(new String[states.size()]);
        }
        log.info((Object)"not authorized to get user information (login/whoami)");
        return new String[]{null, null, null, error};
    }

    @Override
    public String[] login(String user, String password) throws Exception {
        String[] results;
        HttpClient client = this.makeHttpClient(user, password);
        client.getParams().setParameter("accept", (Object)"application/sparql-results+xml");
        client.getParams().setAuthenticationPreemptive(true);
        if (isDebugEnabled) {
            log.debug((Object)("Trying to login at " + RestCommands.WhoAmI.getURL() + " with username " + user));
        }
        if ((results = this.getUserInformation(null, client))[LoginFields.USERNAME.getValue()] == null) {
            log.error((Object)("Could not authenticate user: " + user + "; error message is: " + results[3]));
            throw new EIDataToolsProviderException("Could not authenticate user; please check your username and/or password");
        }
        String sessionId = results[LoginFields.SESSION.getValue()];
        return results;
    }

    @Override
    public void logout(String session) throws Exception {
        int status = 0;
        PostMethod method = new PostMethod(RestCommands.Logout.getURL());
        if (isDebugEnabled) {
            log.debug((Object)("Trying to logout at " + RestCommands.Logout.getURL()));
        }
        try {
            HttpClient client = this.getHttpClient(session);
            status = client.executeMethod((HttpMethod)method);
        }
        catch (Exception e) {
            log.error((Object)("problem with logout  " + RestCommands.Logout.getURL() + " " + e));
            throw new EIDataToolsProviderException(RepositoryProviderMessages.getFailedMessage("logout", 0));
        }
        finally {
            method.releaseConnection();
        }
        if (status == 200) {
            if (isDebugEnabled) {
                log.debug((Object)"logout succeded");
            }
            this.clientMap.remove(session);
        } else {
            log.info((Object)("Could not logout user: HTTP Status: " + status));
        }
    }

    @Override
    public String[] whoami(String session) throws Exception {
        String[] results;
        if (session == null) {
            log.info((Object)"Using null session.  Could not whoami user");
            return new String[]{null, null, null};
        }
        HttpClient client = this.getHttpClient(session);
        if (client == null) {
            log.info((Object)"Using stale session.  Could not whoami user");
            return new String[]{null, null, null};
        }
        client.getParams().setParameter("accept", (Object)"application/sparql-results+xml");
        if (isDebugEnabled) {
            log.debug((Object)("Trying to whoami at " + RestCommands.WhoAmI.getURL()));
        }
        if ((results = this.getUserInformation(session, client))[LoginFields.USERNAME.getValue()] == null) {
            log.info((Object)("Could not whoami user: http status: " + results[3]));
            return new String[]{null, null, null};
        }
        return results;
    }

    @Override
    public EIInstance getEmptyEIInstance(String session, EIURI classUri, EIEntity instanceEntity) throws Exception {
        if (session == null) {
            throw new EIDataToolsProviderException("No session information was found");
        }
        return EIInstanceFactory.getInstance().createEmpty(classUri, instanceEntity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOnline() {
        int status = 0;
        boolean online = false;
        GetMethod method = new GetMethod(RestCommands.Online.getURL());
        HttpClient client = new HttpClient();
        client.setHttpConnectionManager((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
        if (isDebugEnabled) {
            log.debug((Object)("Trying to see if Repository is available: " + RestCommands.Online.getURL()));
        }
        try {
            status = client.executeMethod((HttpMethod)method);
            if (status == 200 || status == 401) {
                online = true;
                if (isDebugEnabled) {
                    log.debug((Object)("Repository is available: " + RestCommands.Online.getURL() + " is available with status: " + status));
                }
            } else if (isDebugEnabled) {
                log.debug((Object)("Repository is unavailable: " + RestCommands.Online.getURL() + " is available with status: " + status));
            }
        }
        catch (Exception e) {
            log.error((Object)("problem checking online status of repository: " + RestCommands.Online.getURL() + " " + e));
        }
        finally {
            method.releaseConnection();
        }
        return online;
    }

    @Override
    public String query(String session, String sparql) throws Exception {
        if (session == null) {
            log.error((Object)"Invalid Session - request cannot be completed");
            throw new EIDataToolsProviderException("No session information was found");
        }
        return this.postQuery(session, sparql);
    }

    private String getStringFromInputStream(InputStream in) throws IOException {
        StringWriter writer = new StringWriter();
        IOUtils.copy((InputStream)in, (Writer)writer, (String)"UTF-8");
        return writer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uploadInstances(String session, String rdf) throws Exception {
        if (session == null) {
            log.error((Object)"Invalid Session - request cannot be completed");
            throw new EIDataToolsProviderException("No session information was found");
        }
        if (rdf == null) {
            log.warn((Object)"Trying to upload null rdf");
            return;
        }
        int status = 0;
        PostMethod method = new PostMethod(RestCommands.Upload.getURL());
        method.setParameter("format", "text/plain");
        method.setParameter("name", "http://eagle-i.org/ont/repo/1.0/NG_Published");
        method.setParameter("type", "published");
        method.setParameter("action", "add");
        method.setParameter("content", rdf);
        try {
            HttpClient client = this.getHttpClient(session);
            status = client.executeMethod((HttpMethod)method);
            String resp = this.getStringFromInputStream(method.getResponseBodyAsStream());
            if (status == 200) {
                log.info((Object)("upload succeed with status: " + status + " response: " + resp));
            } else {
                log.error((Object)("upload sparql endpoint  failed with status: " + status + " response: " + resp));
            }
        }
        catch (Exception e) {
            log.error((Object)("problem with upload endpoint at URL  " + RestCommands.Upload.getURL() + " because " + e));
        }
        finally {
            method.releaseConnection();
        }
    }

    @Override
    public String claim(String session, String uri, String claimant) throws Exception {
        if (session == null) {
            throw new EIDataToolsProviderException("No session information was found");
        }
        if (uri == null || claimant == null) {
            log.warn((Object)("null claim parameter, returning null: " + (uri == null ? "uri" : (claimant == null ? "claimant" : "huh?"))));
            return null;
        }
        int status = 0;
        PostMethod method = new PostMethod(RestCommands.Workflow.getURL());
        method.setParameter("uri", uri);
        method.setParameter("format", FORMAT_VALUE);
        method.setParameter("claim", claimant);
        log.info((Object)("Trying to claim " + uri + " for " + claimant));
        try {
            HttpClient client = this.getHttpClient(session);
            status = client.executeMethod((HttpMethod)method);
            String resp = this.getStringFromInputStream(method.getResponseBodyAsStream());
            if (status == 200) {
                log.info((Object)("claim succeded with status: " + status + " response: " + resp));
                String string = resp;
                return string;
            }
            log.error((Object)("claim failed with status: " + status + " response: " + resp));
            throw new EIDataToolsProviderException(RepositoryProviderMessages.getFailedMessage("claim", status));
        }
        finally {
            method.releaseConnection();
        }
    }

    @Override
    public String promote(String session, String uri, String newState) throws Exception {
        if (session == null) {
            throw new EIDataToolsProviderException("No session information was found");
        }
        if (uri == null) {
            log.warn((Object)"Trying to promote a null URI");
            return null;
        }
        String newStateUri = newState;
        int status = 0;
        PostMethod method = new PostMethod(RestCommands.Workflow.getURL());
        method.setParameter("uri", uri);
        method.setParameter("format", FORMAT_VALUE);
        method.setParameter("promote", newStateUri);
        if (isDebugEnabled) {
            log.debug((Object)("Trying to get promote " + uri + " to state " + newState));
        }
        try {
            HttpClient client = this.getHttpClient(session);
            status = client.executeMethod((HttpMethod)method);
            String resp = this.getStringFromInputStream(method.getResponseBodyAsStream());
            if (status == 200) {
                log.info((Object)("promote succeded with status: " + status + " response: " + resp));
                String string = newStateUri;
                return string;
            }
            log.error((Object)("promote failed with status: " + status + " response: " + resp));
            throw new EIDataToolsProviderException(RepositoryProviderMessages.getFailedMessage("promote", status));
        }
        finally {
            method.releaseConnection();
        }
    }

    @Override
    public List<EIInstance> EIQuery(String session, String sparql) throws Exception {
        if (session == null) {
            log.error((Object)"Invalid Session - request cannot be completed");
            throw new EIDataToolsProviderException("No session information was found");
        }
        if (isDebugEnabled) {
            log.debug((Object)("Sparql: " + sparql));
        }
        ResultSet resultSet = ResultSetFactory.fromXML((String)this.postQuery(session, sparql));
        return EIInstanceFactory.getInstance().create(resultSet);
    }

    @Override
    public List<EIInstance> getInstancesForLab(String session, String rnav, String labURI) throws Exception {
        return this.EIQuery(session, SPARQLQueryUtil.getInstance().getAllResourcesInLabQuery(rnav, EIURI.create((String)labURI)));
    }

    @Override
    public List<EIInstance> getFilterQuery(String session, String user, EIURI classUri, EIURI state, EIURI lab) throws Exception {
        return this.EIQuery(session, SPARQLQueryUtil.getInstance().getFilterQuery(user, classUri, state, lab));
    }

    public List<String> getWFStatesList(String session, String user) throws Exception {
        if (user == null) {
            throw new EIDataToolsProviderException("cannot get workflow states for null user");
        }
        if (session != null) {
            String q = SPARQLQueryUtil.getInstance().getWFStatesQuery(user);
            if (isDebugEnabled) {
                log.debug((Object)("get wf states query: " + q));
            }
            String result = this.postQuery(session, q, "all");
            ResultSet resultSet = ResultSetFactory.fromXML((String)result);
            ArrayList<String> states = new ArrayList<String>();
            while (resultSet.hasNext()) {
                QuerySolution qs = resultSet.next();
                if (!qs.contains("state")) continue;
                states.add(qs.getResource("state").getURI());
            }
            return states;
        }
        throw new EIDataToolsProviderException("No session information was found");
    }

    @Override
    public String[] getWFStates(String session, String user) throws Exception {
        List<String> states = this.getWFStatesList(session, user);
        return states.toArray(new String[states.size()]);
    }

    @Override
    public String retrieveLabel(String session, EIURI uri) throws Exception {
        if (session != null) {
            String q = SPARQLQueryUtil.getInstance().getRetrieveLabelQuery(uri);
            if (isDebugEnabled) {
                log.debug((Object)("retrieve label query: " + q));
            }
            String result = this.postQuery(session, q, "all");
            if (isDebugEnabled) {
                log.debug((Object)("result " + result));
            }
            ResultSet resultSet = ResultSetFactory.fromXML((String)result);
            ArrayList<String> labels = new ArrayList<String>();
            while (resultSet.hasNext()) {
                QuerySolution qs = resultSet.next();
                if (!qs.contains("l")) continue;
                labels.add(qs.getLiteral("l").getString());
            }
            log.info((Object)("labels for " + uri.toString() + ": "));
            for (String label : labels) {
                log.info((Object)label);
            }
            return labels.isEmpty() ? "" : (String)labels.get(0);
        }
        throw new EIDataToolsProviderException("No session information was found");
    }

    static enum LoginFields {
        USERNAME(0),
        SESSION(1),
        USER_URI(2),
        ERROR_MESSAGE(3),
        WF_STATE(3);

        private final int value;

        private LoginFields(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    static enum RestCommands {
        GetNewInstances("repository/new"),
        WhoAmI("repository/whoami"),
        Logout("repository/logout"),
        GetInstance("i"),
        CreateInstance("repository/update"),
        Query("repository/sparql"),
        Online(""),
        Upload("repository/graph"),
        Workflow("repository/fakeworkflow");

        private final String key;

        private RestCommands(String propKey) {
            this.key = propKey;
        }

        public String getURL() {
            return DEFAULT_REPOSITORY + this.key;
        }
    }
}

