/**
 * @author Sravan Cheriyala
 * 
 * This is the core File for ETL ,This file takes Excel Files and Map Files and converts data of Excel into RDF with passed Map files
 * 
 */
package org.eaglei.datatools.etl.server;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.swing.table.DefaultTableModel;

import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.eaglei.datatools.etl.utils.BasicUtils;
import org.eaglei.datatools.etl.utils.Configure;
import org.eaglei.datatools.etl.utils.JenaUtils;
import org.eaglei.datatools.etl.utils.Rdf123Expression;
import org.eaglei.datatools.excel.ExcelParserException;
import org.eaglei.datatools.excel.ExcelUtils;
import org.eaglei.datatools.jena.RDFUtil;

import org.eaglei.datatools.model.AnnotationFormModel;
import org.eaglei.datatools.model.DataToolsEIOntModel;
import org.eaglei.datatools.model.DataToolsOntModelUtils;
import org.eaglei.datatools.provider.EIDataToolsProviderException;
import org.eaglei.datatools.provider.RepositoryProvider;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.EIURI;
import org.eaglei.services.InstitutionRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

import com.clarkparsia.pellint.rdfxml.RDFModel;
import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import org.apache.commons.logging.impl.Log4JLogger;

public class RdfMaker {
	private static final long				serialVersionUID	= 1L;
	private static Model					prefixModel			= null;
	Model									mapModel			= null;
	private static HashMap					predefinedMetaMap	= null;
	private int								count				= 0;
	HashMap<String, String>					globalColumnsHash;
	private static org.apache.log4j.Logger	logger				= Logger.getLogger(RdfMaker.class);
	public static String					template;
	public static String					repo;
	public static String					log;
	public static String					directory;
	public static String					oputputdirectory;
	public static String					mapDirectory;
	public static String					promoteParameter;
	private static RDFtoRepoService			rdftorepo;
	public String							order;
	RepositoryProvider						provider;
	public static String					maps;
	private String							session;
	private PrintWriter						outputPrinter;
	private AnnotationFormModel				anntModel;
	private Map<String, String>				dcCreatorMap;
	List<EIURI>								eiurilst			= null;
	public static void main(String args[]) throws Exception {
		RdfMaker.promoteParameter = "CURATION";
		RdfMaker.directory = "";
		try {
			if (args.length > 0) {
				for (int i = 0; i < args.length - 1; i++) {
					if (args[i].equals("-d")) {
						i = i + 1;
						RdfMaker.directory = args[i];
					} else if (args[i].equals("-o")) {
						i = i + 1;
						RdfMaker.oputputdirectory = args[i];
					} else if (args[i].equals("-r")) {
						i = i + 1;
						RdfMaker.repo = args[i];
					} else if (args[i].equals("-l")) {
						i = i + 1;
						RdfMaker.log = args[i];
					} else if (args[i].equals("-m")) {
						i = i + 1;
						RdfMaker.maps = args[i];
						RdfMaker.mapDirectory = args[i];
					} else if (args[i].equals("-p")) {
						i = i + 1;
						RdfMaker.promoteParameter = args[i];
						if (!(RdfMaker.promoteParameter.equalsIgnoreCase("publish") || RdfMaker.promoteParameter.equalsIgnoreCase("curation"))) {
							logger.info("Parameter supplied for promote is not recognized..data  will be promoted to Curation by default");
							RdfMaker.promoteParameter = "curation";
						}
					}
				}
				if (RdfMaker.directory == null) {
					logger.error("Excel Files location is not provided ,this input is mandatory");
					System.exit(2);
				}
				if (RdfMaker.repo == null) {
					logger.error("Repository is not provided ,this input is mandatory");
					System.exit(2);
				}
				if (RdfMaker.maps == null) {
					logger.error("Maps location are not provided ,this input is mandatory");
					System.exit(2);
				}
				/* Logs if user supplied log output directory with -l option */
				if (RdfMaker.log != null) {
					FileAppender appender = null;
					try {
						appender = new FileAppender(new PatternLayout(), RdfMaker.log);
					} catch (Exception e) {
						logger.error("Cannot create Log file..ignoring");
					}
					logger.addAppender(appender);
				}
				try {
					rdftorepo = RDFtoRepoService.getInstance(RdfMaker.repo);
				} catch (FileNotFoundException fe) {
					logger.error(fe);
					throw fe;
				}
				// create and configure spring beans
				ApplicationContext context = new ClassPathXmlApplicationContext(new String[] { "datatools-model-config.xml" });
				// retrieve configured instance
				AnnotationFormModel anntModel = context.getBean(AnnotationFormModel.class);
				/* command line options */
				RdfMaker rdfmaker = new RdfMaker(anntModel);
				rdfmaker.rdfToRepoByExcelStream(RdfMaker.directory, RdfMaker.maps);
			}
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			logger.error(e);
			logger.error("Exiting System");
			System.exit(2);
		}
	}
	public int getCount() {
		return count;
	}
	public String getSession() {
		return session;
	}
	public void setSession(String session) {
		this.session = session;
	}
	public RdfMaker(AnnotationFormModel anntModel) throws Exception {
		super();
		dcCreatorMap = RowConfiguration.getdcCreatorFromRepoFile(RdfMaker.repo);
		this.anntModel = anntModel;
		template = new String();
		// directory = new String();
		// initialize predefined prefix definition
		int count = Configure.prefixArray.length;
		HashMap predefinedPrefixes = new HashMap();
		for (int row = 0; row < count; row++) {
			predefinedPrefixes.put(Configure.prefixArray[row][0], Configure.prefixArray[row][1]);
		}
		prefixModel = ModelFactory.createDefaultModel();
		prefixModel.setNsPrefixes(predefinedPrefixes);
		// initialize predefined RDF123 spreadsheet metadata definition
		count = Configure.metaArray.length;
		predefinedMetaMap = new HashMap();
		for (int row = 0; row < count; row++) {
			predefinedMetaMap.put(Configure.metaArray[row][0], Configure.metaArray[row][1]);
		}
	}
	/**
	 * Get all files from the specified directory and call
	 * generateRDFGraph(which inturn generates the RDF and pushed into Repo)
	 * 
	 */
	public boolean rdfToRepoByExcelStream(final String excelFolder, final String mapFolder) throws Exception {
		Map<String, InputStream> mapIns = new HashMap<String, InputStream>();
		/* excel files */
		File excelDirectory = new File(excelFolder);
		if (!excelDirectory.isDirectory()) {
			logger.error(excelFolder + " is not a directory...exiting");
			System.exit(2);
		}
		String[] lstFiles = excelDirectory.list();
		for (String str : lstFiles) {
			try {
				if (!str.contains(".xlsx") && !str.contains(".xls")) {
					if (str.contains(".svn")) {
						continue;
					}
					File strFIle = new File(excelFolder + "/" + str);
					if (strFIle.isDirectory()) {
						rdfToRepoByExcelStream(excelFolder + "/" + str, mapFolder);
					} else {
						logger.info(str + "is not Excel file ...Ignoring");
						continue;
					}
				}
				/*
				 * map files Map<String, String> mapInfoHash =
				 * RowConfiguration.getMapInfo(mapFolder +
				 * "/mapsInfo.properties"); File mapdirectory = null;
				 * Iterator<String> setIter = mapInfoHash.keySet().iterator();
				 * boolean mapFound = false; while (setIter.hasNext()) { String
				 * keyStr = setIter.next(); if (str.contains(keyStr)) {
				 * mapdirectory = new File(mapFolder + "/" +
				 * mapInfoHash.get(keyStr)); RdfMaker.mapDirectory = mapFolder +
				 * "/" + mapInfoHash.get(keyStr); mapFound = true; } }
				 */
				File dirfile = new File(excelFolder + "/" + str);
				if (dirfile.isDirectory()) {
					logger.info(excelFolder + "/" + str + "is directory ...Ignoring");
					continue;
				} else {
					logger.info("processing file :" + excelFolder + "/" + str);
					if (RdfMaker.oputputdirectory != null) {
						FileOutputStream fvec = new FileOutputStream(RdfMaker.oputputdirectory + "/" + str + ".rdf");
						outputPrinter = new PrintWriter(fvec);
					}
				}
				InputStream is = new BufferedInputStream(new FileInputStream(excelFolder + "/" + str));
				Map<String, DefaultTableModel> defaultModelMap = ExcelToTableModel(is);
				File mapdirectory = null;
				mapdirectory = new File(RdfMaker.mapDirectory);
				String[] lstMapFiles = mapdirectory.list();
				for (String mapstr : lstMapFiles) {
					if (mapstr.contains(".svn")) {
						continue;
					}
					try {
						FileInputStream fis = new FileInputStream(RdfMaker.mapDirectory + "/" + mapstr);
						mapIns.put(mapstr.replace(".rdf", ""), fis);
					} catch (FileNotFoundException e) {
						logger.error(e);
						throw e;
					}
				}
				/*
				 * getting an instance of rfdtorepo for repository services
				 * ,which will be used through out the program
				 */
				provider = rdftorepo.getRepositoryProvider();
				Map<String, String> credentialMap = RowConfiguration.getCredentialsForRepo(RdfMaker.repo);
				String[] strAry = provider.login(credentialMap.get("user"), credentialMap.get("password"));
				if (strAry == null) {
					logger.error("Could not authenticate please check username,password and Repository URL...Exiting System");
					System.exit(2);
				}
				setSession(strAry[1]);
				Map<String, Model> retMap = generateRDFGraph(defaultModelMap, mapIns);
				outputPrinter.close();
				RdfMaker.mapDirectory = RdfMaker.maps;
			} catch (FileNotFoundException e) {
				logger.error(e);
				throw e;
			}
		}
		return true;
	}
	/**
	 * Generates RDGGraph by tableModel and mapStream and pushes into Repo
	 */
	public Map<String, Model> generateRDFGraph(Map<String, DefaultTableModel> tableModelMap, Map<String, InputStream> mapStreamMap) throws Exception {
		String[] keySetAry = order.split("#");
		Map<String, Model> retMap = new HashMap<String, Model>();
		int loopVar = 0;
		for (String keyStr : keySetAry) {
			
			logger.info("Processing " + keyStr);
			/*
			 * if (!keyStr.equals("protocol")) { continue; }
			 */
			DefaultTableModel tableModel = tableModelMap.get(keyStr.toUpperCase());
			InputStream mapStream = mapStreamMap.get(keyStr.toLowerCase());
			if (mapStream == null) {
				continue;
			}
			/* gets the base namspace from properties file */
			String base = rdftorepo.getDatatoolsConfiguration().getDatatoolsRepositoryNamespace();
			String syntax = "RDF/XML";
			mapModel = ModelFactory.createDefaultModel();
			mapModel.read(mapStream, null, syntax);
			mapModel.removeNsPrefix("");
			boolean hasRowHead = true;
			int startRow = Configure.baseRow;
			int endRow = tableModel.getRowCount() - 1;
			int startCol = 1;
			Rdf123Expression rdf123Exp = new Rdf123Expression(tableModel, mapModel.getNsPrefixMap(), startCol, base);
			if (hasRowHead)
				startRow++;
			if (endRow - startRow >= 1) {
				eiurilst = rdftorepo.getNewInstancesFromRepo(session, (endRow - startRow) + 1);
			}
			count = 0;
			for (int row = startRow; row <= endRow; row++) {
				Map<String, String[]> mapInstanceExp = new HashMap<String, String[]>();
				// list the statements in the graph
				int columnCount = tableModel.getColumnCount();
				int columnsFilled = 0;
				/* if blank row skip it */
				for (int column = 0; column <= columnCount - 1; column++) {
					if (tableModel.getValueAt(row, column) != null) {
						if (!tableModel.getValueAt(row, column).equals("")) {
							columnsFilled++;
							// break;
						}
					}
				}
				/*if ((columnsFilled==0) || (columnsFilled > 4)) {
					continue;
				}*/
				/*
				 * process the dependent nodes first,that is our main newly
				 * created instance depend on few node ,that should be processed
				 * first ,please see the actvity diagram for further
				 * understading on flow
				 */
				Set<String> subjectSet = new HashSet<String>();
				StmtIterator subIter = mapModel.listStatements();
				while (subIter.hasNext()) {
					Statement stmtMap = subIter.nextStatement();
					Resource subjectMap = stmtMap.getSubject();
					if (!subjectMap.getURI().equals("Ex:e+$0"))
						subjectSet.add(subjectMap.getURI());
				}
				Iterator<String> setIter = subjectSet.iterator();
				while (setIter.hasNext()) {
					Model tempModel;
					tempModel = ModelFactory.createDefaultModel();
					String subjectExpression = setIter.next();
					loopMakeRdf(mapModel, tempModel, base, rdf123Exp, row, mapInstanceExp, subjectSet, subjectExpression);
				}
				/* process the main node ,that is new instance of the row */
				StmtIterator mapIter = mapModel.listStatements();
				Model rdfModel = null;
				rdfModel = ModelFactory.createDefaultModel();
				rdfModel.setNsPrefixes(mapModel.getNsPrefixMap());
				while (mapIter.hasNext()) {
					Statement stmtMap = mapIter.nextStatement();
					Resource subjectMap = stmtMap.getSubject();
					Property predicateMap = stmtMap.getPredicate();
					RDFNode objectMap = stmtMap.getObject();
					if (!subjectMap.getURI().equals("Ex:e+$0"))
						continue;
					if (evaluateExpression(rdf123Exp, row, objectMap.toString()) == null) {
						continue;
					}
					Resource subject = null;
					Property predicate;
					RDFNode[] objectAry = new RDFNode[20];
					if (subjectMap.isAnon()) {
						subject = rdfModel.createResource(new AnonId(subjectMap.getId().toString() + row));
					} else if (subjectMap.getURI().startsWith(Configure.EX)) {
						if (subjectMap.getURI().startsWith(Configure.EX + "e")) {
							if (subjectMap.getURI().startsWith(Configure.EX + "e+$0")) {
								if (eiurilst != null && mapInstanceExp.get(Configure.EX + "e+$0") == null) {
									EIURI eiuri = eiurilst.get(count);
									subject = rdfModel.createResource(eiuri.toString());
									putInMap(mapInstanceExp, Configure.EX + "e+$0", subject.getURI());
								} else {
									String[] strAry = mapInstanceExp.get(Configure.EX + "e+$0");
									subject = rdfModel.createResource(strAry[0]);
								}
							} else if ((!subjectMap.getURI().startsWith(Configure.EX + "e") && !subjectMap.getURI().matches(Configure.EX + "ont")) || subjectMap.getURI().startsWith(Configure.EX)) {
								String result = rdf123Exp.evaluate(subjectMap.getURI().substring(Configure.EX.length()), row);
								if (result != null) {
									if (!BasicUtils.isValidURL(result)) {
										if (!JenaUtils.isValidRDFId(result)) {
											result = result.replace(' ', '_');
											if (!JenaUtils.isValidRDFId(result)) {
												continue;
											}
										}
										result = toURI(base, result);
									}
									subject = rdfModel.createResource(result);
								} else
									continue;
							} else {
								subject = subjectMap;
							}
						}
					}
					predicate = getPredicate(rdfModel, rdf123Exp, predicateMap, row);
					if (mapInstanceExp.get(objectMap.toString()) != null) {
						String[] strAry = mapInstanceExp.get(objectMap.toString());
						int i = 0;
						objectAry = new RDFNode[strAry.length + 1];
						for (String str : strAry) {
							objectAry[i] = rdfModel.createResource(str);
							i++;
						}
					} else if (objectMap.toString().matches(Configure.EX + "ont\\+\\$\\d+")) {
						//	Property[] pridicateAry = checkOntologyMakeObjectAndPredicate(mapModel, rdfModel, rdf123Exp, row, mapInstanceExp, predicate, objectAry, objectMap.toString());
						//predicate = pridicateAry[0];
						if (predicateMap.equals(RDF.type)) {
							String rootURI = getObjectFromModelBySubjectAndType(mapModel, objectMap.toString());
							if (rootURI != null) {
								RDFNode typeObject = rdfModel.createResource(rootURI);
								objectAry[0] = typeObject;
								predicate = RDF.type;
								// rdfModel.add(subject, pridicateAry[1], typeObject);
							}
						} else {
							String result = evaluateExpression(rdf123Exp, row, objectMap.toString());
							RDFNode node = mapModel.createTypedLiteral(result, XSDDatatype.XSDstring);
							objectAry[0] = node;
							predicate = rdfModel.createProperty("http://eagle-i.org/ont/datatools/1.0/temp");
						}
					} else {
						objectAry = getObject(rdfModel, rdf123Exp, objectMap, mapInstanceExp, row, subjectMap.toString());
					}
					for (RDFNode objectNode : objectAry) {
						if (objectNode != null) {
							rdfModel.add(subject, predicate, objectNode);
						}
					}
				}
				/* push new created instance to repo */
				EIURI eiuri = eiurilst.get(count);
				logger.info("pushing " + keyStr + " instance into repo");
				StringWriter swriter = new StringWriter();
				rdfModel.write(swriter, "N-TRIPLE");
				if (RdfMaker.oputputdirectory != null) {
					outputPrinter.println(swriter.toString());
				}
				try {
					String query = ETLSPARQLQueryUtil.getEIResourcesByOnlyTypeANDRdfsLabel(rdfModel);
					String instance = provider.query(this.session, query.replace("\n", " ").replace("\r", " "));
					String[] instanceURI = getInstanceURI(instance);
					if (query != null && (instanceURI == null || !(query.contains("ERO_0000001") || query.contains("ERO_0000002")))) {
						rdftorepo.pushtoRepo(rdfModel, this.getSession(), eiuri.toString(), RdfMaker.promoteParameter);
					}
				} catch (EIDataToolsProviderException ex) {
					logger.error(ex.getMessage());
					logger.info("skiping...");
				}
				logger.info(keyStr + " instance pushed into repo");
				count++;
				loopVar++;
			}
			if (count % 50 == 0)
				System.gc();
		}
		return retMap;
	}
	/**
	 * Make Rdf of the ex-----cel row by looping through it
	 * 
	 * @param mapModel
	 * @param rdfModel
	 * @param base
	 * @param rdf123Exp
	 * @param row
	 * @param mapInstanceExp
	 * @param subjectSet
	 * @param subjectExpression
	 * @throws Exception
	 */
	private String loopMakeRdf(Model mapModel, Model rdfModel, String base, Rdf123Expression rdf123Exp, int row, Map<String, String[]> mapInstanceExp, Set<String> subjectSet, String subjectExpression) throws Exception {
		boolean somethingAdded = false;
		StmtIterator subNodes = mapModel.listStatements();
		Resource subject = null;
		Property predicate;
		RDFNode[] objectAry = new RDFNode[20];
		List<EIURI> lstEIURI = rdftorepo.getNewInstancesFromRepo(session, 1);
		EIURI neweiuri = lstEIURI.get(0);
		// putInMap(mapInstanceExp, subjectExpression, neweiuri.toString());
		subject = rdfModel.createResource(neweiuri.toString());
		while (subNodes.hasNext()) {
			Statement stmtMap = subNodes.nextStatement();
			Resource subjectMap = stmtMap.getSubject();
			if (!subjectMap.getURI().equals(subjectExpression)) {
				continue;
			}
			if (evaluateExpression(rdf123Exp, row, subjectMap.toString()) == null) {
				mapInstanceExp.remove(subjectExpression);
				continue;
			}
			Property predicateMap = stmtMap.getPredicate();
			RDFNode objectMap = stmtMap.getObject();
			if (!(objectMap instanceof Resource) && predicateMap.equals(RDFS.label)) {
				Literal objectLiteral = (Literal) objectMap;
				String result = evaluateExpression(rdf123Exp, row, objectLiteral.getString());
				String returnedStr = getTypeFromModelByObject(mapModel, subjectExpression);
				if (returnedStr != null && returnedStr.contains("http://purl.org/dc/terms/")) {
					result = wrapUsersofdcCreator(result);
				}
				if (result != null && rdfModel != null && result.contains(";") && !rdfModel.toString().contains("http://xmlns.com/foaf/0.1/Person")) {
					RDFNode[] subobjectAry = new RDFNode[20];
					subobjectAry[0] = mapModel.createResource(getObjectFromModelBySubjectAndType(mapModel, subjectExpression));
					if (predicateMap.equals(RDFS.label)) {
						for (String str : result.split(";")) {
							createOrCheckModelsWhenSemicolon(mapModel, base, rdf123Exp, row, subobjectAry[0], str, subjectExpression, mapInstanceExp);
						}
						continue;
					}
				} else if (result != null) {
					predicate = getPredicate(rdfModel, rdf123Exp, predicateMap, row);
					if (subjectSet.toString().contains(objectMap.toString()) && mapInstanceExp.get(objectMap.toString()) == null) {
						Model subtempModel;
						subtempModel = ModelFactory.createDefaultModel();
						String retResource = loopMakeRdf(mapModel, subtempModel, base, rdf123Exp, row, mapInstanceExp, subjectSet, objectMap.toString());
						if (retResource != null) {
							RDFNode object = rdfModel.createResource(retResource);
							objectAry[0] = object;
						} else {
							continue;
						}
					}
					/*
					 * if (objectMap.toString().matches(Configure.EX +
					 * "ont\\+\\$\\d+")) { Property[] pridicateAry =
					 * checkOntologyMakeObjectAndPredicate(mapModel, rdfModel,
					 * rdf123Exp, row, mapInstanceExp, predicate, objectAry,
					 * objectMap.toString()); predicate = pridicateAry[0]; }
					 */else {
						RDFNode object = rdfModel.createTypedLiteral(result, XSDDatatype.XSDstring);
						objectAry[0] = object;
					}
					for (RDFNode objectNode : objectAry) {
						if (objectNode != null) {
							somethingAdded = true;
							rdfModel.add(subject, predicate, objectNode);
						}
					}
				}
			} else {
				if (getLabelBySubjectExpression(mapModel, row, rdf123Exp, subjectExpression).contains(";") && !rdfModel.toString().contains("http://xmlns.com/foaf/0.1/Person")) {
					continue;
				}
				predicate = getPredicate(rdfModel, rdf123Exp, predicateMap, row);
				if (subjectSet.toString().contains(objectMap.toString()) && mapInstanceExp.get(objectMap.toString()) == null) {
					Model subtempModel;
					subtempModel = ModelFactory.createDefaultModel();
					String retResource = loopMakeRdf(mapModel, subtempModel, base, rdf123Exp, row, mapInstanceExp, subjectSet, objectMap.toString());
					if (retResource != null) {
						RDFNode object = rdfModel.createResource(retResource);
						objectAry[0] = object;
					} else {
						continue;
					}
				}
				/*
				 * if (objectMap.toString().matches(Configure.EX +
				 * "ont\\+\\$\\d+")) { Property[] pridicateAry =
				 * checkOntologyMakeObjectAndPredicate(mapModel, rdfModel,
				 * rdf123Exp, row, mapInstanceExp, predicate, objectAry,
				 * objectMap.toString()); predicate = pridicateAry[0]; }
				 */else {
					objectAry = getObject(rdfModel, rdf123Exp, objectMap, mapInstanceExp, row, subjectExpression);
				}
				for (RDFNode objectNode : objectAry) {
					if (objectNode != null) {
						somethingAdded = true;
						rdfModel.add(subject, predicate, objectNode);
					}
				}
			}
		}
		if (somethingAdded)
			checkExpressionAndMakeSubjectResource(mapModel, base, rdf123Exp, row, mapInstanceExp, rdfModel, subject, subjectExpression);
		if (mapInstanceExp.get(subjectExpression) != null) {
			return mapInstanceExp.get(subjectExpression)[0];
		} else {
			return null;
		}
	}
	public void createOrCheckModelsWhenSemicolon(Model mapModel, String base, Rdf123Expression rdf123Exp, int row, RDFNode objectResource, String label, String subjectExpression, Map<String, String[]> mapInstanceExp) throws Exception {
		List<EIURI> lstEIURI = rdftorepo.getNewInstancesFromRepo(session, 1);
		EIURI neweiuri = lstEIURI.get(0);
		Model tempModel = ModelFactory.createDefaultModel();
		Resource subject = tempModel.createResource(neweiuri.toString());
		RDFNode node = tempModel.createTypedLiteral(label.trim(), XSDDatatype.XSDstring);
		tempModel.add(subject, RDF.type, objectResource);
		tempModel.add(subject, RDFS.label, node);
		checkExpressionAndMakeSubjectResource(mapModel, base, rdf123Exp, row, mapInstanceExp, tempModel, subject, subjectExpression);
		/*
		 * String query =
		 * ETLSPARQLQueryUtil.getEIResourcesByOnlyTypeANDRdfsLabel(tempModel);
		 * logger.debug(query); String instance = provider.query(this.session,
		 * query.replace("\n", " ").replace("\r", " ")); String[] instanceURI =
		 * getInstanceURI(instance); pushIntoRepo(tempModel, mapInstanceExp,
		 * subject, subjectExpression, instanceURI);
		 */
	}
	/**
	 * checks ontology if the id is present in ontology then make Predicate
	 * property with the found ID and return it.
	 * 
	 * @param mapModel
	 * @param rdfModel
	 * @param rdf123Exp
	 * @param row
	 * @param mapInstanceExp
	 * @param predicate
	 * @param objectAry
	 * @param objectResourceURI
	 * @return
	 * @throws Exception
	 */
	private Property[] checkOntologyMakeObjectAndPredicate(Model mapModel, Model rdfModel, Rdf123Expression rdf123Exp, int row, Map<String, String[]> mapInstanceExp, Property predicate, RDFNode[] objectAry, String objectResourceURI) throws Exception {
		boolean retBoolean = true;
		Property predicateRDFType = null;
		if (predicate != null) {
			retBoolean = ontProcess(mapModel, rdfModel, rdf123Exp, row, mapInstanceExp, objectAry, objectResourceURI);
		}
		if (!retBoolean) {
			if (predicate != null) {
				predicate = rdfModel.createProperty("http://eagle-i.org/ont/datatools/1.0/temp");
				predicateRDFType = RDF.type;
			}
		}
		return new Property[] { predicate, predicateRDFType };
	}
	/**
	 * In this method Excpetions are processed ,Exceptions are special casses in
	 * map file which should be dealt specially
	 * 
	 * @param mapModel
	 * @param base
	 * @param rdf123Exp
	 * @param row
	 * @param mapInstanceExp
	 * @param tempModel
	 * @param subject
	 * @param subjectExpression
	 * @return
	 * @throws Exception
	 */
	private boolean checkExpressionAndMakeSubjectResource(Model mapModel, String base, Rdf123Expression rdf123Exp, int row, Map<String, String[]> mapInstanceExp, Model tempModel, Resource subject, String subjectExpression) throws Exception {
		if (subjectExpression.matches(Configure.EX + "e\\+\\$\\d+") && !subjectExpression.startsWith(Configure.EX + "e+$0")) {
			String query = "";
			if (tempModel.toString().contains("http://xmlns.com/foaf/0.1/Person")) {
				query = ETLSPARQLQueryUtil.getEIResourcesByOnlyTypeANDRdfsLabel(tempModel);
				logger.debug(query);
			} else {
				query = ETLSPARQLQueryUtil.getEIResourcesByAllPropertiesQuery(tempModel);
				logger.debug(query);
			}
			String instance = provider.query(this.session, query.replace("\n", " ").replace("\r", " "));
			String[] instanceURI = getInstanceURI(instance);
			pushIntoRepo(tempModel, mapInstanceExp, subject, subjectExpression, instanceURI);
			return true;
		} else if (subjectExpression.matches(Configure.EX + "e\\+ont\\+\\$\\d+")) {
			String query = ETLSPARQLQueryUtil.getEIResourcesByAllPropertiesQuery(tempModel);
			logger.debug(query);
			String instance = provider.query(this.session, query.replace("\n", " ").replace("\r", " "));
			String[] instanceURI = getInstanceURI(instance);
			if (instanceURI != null) {
				putInMap(mapInstanceExp, subjectExpression, instanceURI[0]);
			} else {
				/*
				 * String[] splitStr = subjectExpression.split("\\+"); String[]
				 * splitNamespace = splitStr[1].split(":"); String rootURI =
				 * mapModel.expandPrefix(splitStr[2]); String subclassLabel =
				 * rdf123Exp.evaluate(splitStr[3], row);
				 */
				String[] strAry = getLabelAndRootURI(tempModel, row, rdf123Exp);
				String ontologyURI = checkOntology(rdf123Exp, row, strAry[0], strAry[1], mapModel);
				if (ontologyURI != null) {
					putInMap(mapInstanceExp, subjectExpression, ontologyURI.toString());
				} else {
					pushIntoRepo(tempModel, mapInstanceExp, subject, subjectExpression, ontologyURI);
				}
			}
			return true;
		} else if (subjectExpression.startsWith(Configure.EX + "ont")) {
			String[] strAry = getLabelAndRootURI(tempModel, row, rdf123Exp);
			String strLabel = strAry[0];
			if (strLabel != null) {
				if (strLabel.equalsIgnoreCase("Protocol")) {
					strLabel = "Technique";
				}
				if (strLabel.equalsIgnoreCase("core facility")) {
					strLabel = "Core Laboratory";
				}
				if (strLabel.equalsIgnoreCase("research facility")) {
					strLabel = "Laboratory";
				}
				if (strLabel.equalsIgnoreCase("laboratory")) {
					strLabel = "Laboratory";
				}
				String instanceURI = checkOntology(rdf123Exp, row, strLabel, strAry[1], mapModel);
				if (instanceURI == null) {
					return false;
				}
				pushIntoRepo(tempModel, mapInstanceExp, subject, subjectExpression, instanceURI);
				return true;
			}
		} else if ((!subjectExpression.startsWith(Configure.EX + "e") && !subjectExpression.matches(Configure.EX + "ont")) || subjectExpression.startsWith(Configure.EX)) {
			String result = rdf123Exp.evaluate(subjectExpression.substring(Configure.EX.length()), row);
			if (result != null) {
				if (!BasicUtils.isValidURL(result)) {
					if (!JenaUtils.isValidRDFId(result)) {
						result = result.replace(' ', '_');
						if (!JenaUtils.isValidRDFId(result)) {
							return false;
						}
					}
					result = toURI(base, result);
				}
				subject = tempModel.createResource(result);
				putInMap(mapInstanceExp, subjectExpression, subject.getURI());
				return true;
			} else {
				return false;
			}
		}
		return false;
	}
	/**
	 * pushes the RDFModel into Repo
	 * 
	 * @param rdfModel
	 * @param mapInstanceExp
	 * @param subject
	 * @param subjectExpression
	 * @param instanceURI
	 * @throws Exception
	 */
	private void pushIntoRepo(Model rdfModel, Map<String, String[]> mapInstanceExp, Resource subject, String subjectExpression, String[] instanceURI) throws Exception {
		if (instanceURI != null) {
			putInMap(mapInstanceExp, subjectExpression, instanceURI[0]);
		} else {
			StringWriter swriter = new StringWriter();
			rdfModel.write(swriter, "N-TRIPLE");
			if (RdfMaker.oputputdirectory != null) {
				outputPrinter.println(swriter.toString());
			}
			rdftorepo.pushtoRepo(rdfModel, this.getSession(), subject.getURI(), RdfMaker.promoteParameter);
			putInMap(mapInstanceExp, subjectExpression, subject.getURI());
		}
	}
	private void pushIntoRepo(Model rdfModel, Map<String, String[]> mapInstanceExp, Resource subject, String subjectExpression, String instanceURI) throws Exception {
		if (instanceURI != null) {
			putInMap(mapInstanceExp, subjectExpression, instanceURI);
		} else {
			putInMap(mapInstanceExp, subjectExpression, subject.getURI());
			StringWriter swriter = new StringWriter();
			rdfModel.write(swriter, "N-TRIPLE");
			if (RdfMaker.oputputdirectory != null) {
				outputPrinter.println(swriter.toString());
			}
			rdftorepo.pushtoRepo(rdfModel, this.getSession(), subject.getURI(), RdfMaker.promoteParameter);
		}
	}
	private void putInMap(Map<String, String[]> mapInstanceExp, String key, String value) {
		String[] strAry = mapInstanceExp.get(key);
		if (strAry != null) {
			String[] newStrAry = new String[strAry.length + 1];
			int i = 0;
			for (String str : strAry) {
				newStrAry[i] = str;
				i++;
			}
			newStrAry[i] = value;
			mapInstanceExp.put(key, newStrAry);
		} else {
			mapInstanceExp.put(key, new String[] { value });
		}
	}
	/**
	 * prepares the Object by the checking the possible exceptions
	 * 
	 * @param rdfModel
	 * @param rdf123Exp
	 * @param objectMap
	 * @param mapInstanceExp
	 * @param row
	 * @return
	 * @throws Exception
	 */
	private RDFNode[] getObject(Model rdfModel, Rdf123Expression rdf123Exp, RDFNode objectMap, Map<String, String[]> mapInstanceExp, int row, String subjectExpression) throws Exception {
		RDFNode[] objectAry = new RDFNode[30];
		if (objectMap instanceof Resource) {
			Resource objectResource = (Resource) objectMap;
			if (objectResource.isAnon()) {
				RDFNode object = rdfModel.createResource(new AnonId(objectResource.getId().toString() + row));
				objectAry[0] = object;
			} else {
				if (objectResource.getURI().startsWith(Configure.EX + "e")) {
					if ((objectResource.getURI().matches(Configure.EX + "e\\+\\$\\d") || objectResource.getURI().matches(Configure.EX + "e\\+ont\\+\\$\\d+")) && !objectResource.getURI().matches(Configure.EX + "e\\+\\$0")) {
						checkMapGetRdfNode(rdfModel, objectAry, mapInstanceExp, objectResource);
					} else if (objectResource.getURI().matches(Configure.EX + "e\\+\\$0")) {
						if (eiurilst != null && mapInstanceExp.get(Configure.EX + "e+$0") == null) {
							EIURI eiuri = eiurilst.get(count);
							RDFNode object = rdfModel.createResource(eiuri.toString());
							objectAry[0] = object;
							putInMap(mapInstanceExp, Configure.EX + "e+$0", eiuri.toString());
						} else {
							String[] strAry = mapInstanceExp.get(Configure.EX + "e+$0");
							RDFNode object = rdfModel.createResource(strAry[0]);
							objectAry[0] = object;
						}
					}
				} else {
					RDFNode object = rdfModel.createResource(objectResource.getURI());
					objectAry[0] = object;
				}
			}
		} else {
			Literal objectLiteral = (Literal) objectMap;
			RDFDatatype dataType = objectLiteral.getDatatype();
			if (dataType == null) {
				if (objectLiteral.getString().startsWith(Configure.EX)) {
					String result = evaluateExpression(rdf123Exp, row, objectLiteral.getString());
					String returnedStr = getTypeFromModelByObject(mapModel, subjectExpression);
					if (returnedStr != null && returnedStr.contains("http://purl.org/dc/terms/")) {
						result = wrapUsersofdcCreator(result);
					}
					if (result != null) {
						RDFNode object = rdfModel.createTypedLiteral(result, XSDDatatype.XSDstring);
						objectAry[0] = object;
					}
				} else {
					RDFNode object = objectMap;
					objectAry[0] = object;
				}
			} else {
				RDFNode object = objectMap;
				objectAry[0] = object;
			}
		}
		return objectAry;
	}
	private String wrapUsersofdcCreator(String result) throws ConfigurationException {
		// Map<String, String> dcCreatorMap =
		// RowConfiguration.getdcCreatorFromRepoFile(RdfMaker.repo);
		if (dcCreatorMap.get(result.replace(" ", "")) != null) {
			return dcCreatorMap.get(result.replace(" ", ""));
		} else {
			return result;
		}
	}
	/**
	 * Evaluates the object Expression ,that it converts $1 $2 .. in to Excel
	 * Columns
	 * 
	 * @param rdf123Exp
	 * @param row
	 * @param objectString
	 * @return
	 * @throws Exception
	 */
	private String evaluateExpression(Rdf123Expression rdf123Exp, int row, String objectString) throws Exception {
		String localName = objectString.substring(Configure.EX.length());
		if (localName.endsWith("^^string")) {
			String expression = localName.substring(0, localName.length() - 8);
			String result = rdf123Exp.evaluate(expression, row);
			if (result != null) {
				return result;
			} else
				return null;
		} else if (localName.endsWith("^^decimal")) {
			String expression = localName.substring(0, localName.length() - 9);
			String result = rdf123Exp.evaluate(expression, row);
			if (result != null) {
				return result;
			} else
				return null;
		} else if (localName.endsWith("^^integer")) {
			String expression = localName.substring(0, localName.length() - 9);
			String result = rdf123Exp.evaluate(expression, row);
			if (result != null) {
				return result;
			} else
				return null;
		} else if (localName.endsWith("^^float")) {
			String expression = localName.substring(0, localName.length() - 7);
			String result = rdf123Exp.evaluate(expression, row);
			if (result != null) {
				return result;
			} else
				return null;
		} else if (localName.endsWith("^^boolean")) {
			String expression = localName.substring(0, localName.length() - 9);
			String result = rdf123Exp.evaluate(expression, row);
			if (result != null) {
				return result;
			} else
				return null;
		} else if (localName.endsWith("^^time")) {
			String expression = localName.substring(0, localName.length() - 6);
			String result = rdf123Exp.evaluate(expression, row);
			if (result != null) {
				return result;
			} else
				return null;
		} else if (localName.endsWith("^^anyURI")) {
			String expression = localName.substring(0, localName.length() - 8);
			String result = rdf123Exp.evaluate(expression, row);
			if (result != null) {
				return result;
			} else
				return null;
		} else if (localName.endsWith("^^double")) {
			String expression = localName.substring(0, localName.length() - 8);
			String result = rdf123Exp.evaluate(expression, row);
			if (result != null) {
				return result;
			} else
				return null;
		} else if (localName.endsWith("^^int")) {
			String expression = localName.substring(0, localName.length() - 5);
			String result = rdf123Exp.evaluate(expression, row);
			if (result != null) {
				return result;
			} else
				return null;
		} else if (localName.endsWith("^^long")) {
			String expression = localName.substring(0, localName.length() - 6);
			String result = rdf123Exp.evaluate(expression, row);
			if (result != null) {
				return result;
			} else
				return null;
		} else if (localName.endsWith("^^short")) {
			String expression = localName.substring(0, localName.length() - 7);
			String result = rdf123Exp.evaluate(expression, row);
			if (result != null) {
				return result;
			} else
				return null;
		} else if (localName.endsWith("^^positiveInteger")) {
			String expression = localName.substring(0, localName.length() - 17);
			String result = rdf123Exp.evaluate(expression, row);
			if (result != null) {
				return result;
			} else
				return null;
		} else if (localName.endsWith("^^negativeInteger")) {
			String expression = localName.substring(0, localName.length() - 17);
			String result = rdf123Exp.evaluate(expression, row);
			if (result != null) {
				return result;
			} else
				return null;
		} else if (localName.endsWith("^^byte")) {
			String expression = localName.substring(0, localName.length() - 6);
			String result = rdf123Exp.evaluate(expression, row);
			if (result != null) {
				return result;
			} else
				return null;
		} else if (localName.endsWith("^^dateTime")) {
			String expression = localName.substring(0, localName.length() - 10);
			String result = rdf123Exp.evaluate(expression, row);
			if (result != null) {
				return result;
			} else
				return null;
		} else if (localName.endsWith("^^token")) {
			String expression = localName.substring(0, localName.length() - 7);
			String result = rdf123Exp.evaluate(expression, row);
			if (result != null) {
				return result;
			} else
				return null;
		} else if (localName.endsWith("^^language")) {
			String expression = localName.substring(0, localName.length() - 10);
			String result = rdf123Exp.evaluate(expression, row);
			if (result != null) {
				return result;
			} else
				return null;
		} else if (localName.endsWith("^^date")) {
			String expression = localName.substring(0, localName.length() - 6);
			String result = rdf123Exp.evaluate(expression, row);
			if (result != null) {
				return result;
			} else
				return null;
		} else if (localName.matches("\\$\\d+")) {
			String expression = localName;
			String result = rdf123Exp.evaluate(expression, row);
			if (result != null) {
				if (BasicUtils.isValidURL(result)) {
					return result;
				} else {
					return result;
				}
			} else
				return null;
		} else if (localName.matches("e\\+\\$\\d+")) {
			String expression = localName.split("\\+")[1];
			String result = rdf123Exp.evaluate(expression, row);
			if (result != null) {
				if (BasicUtils.isValidURL(result)) {
					return result;
				} else {
					return result;
				}
			} else
				return null;
		} else if (localName.matches("e\\+ont\\+\\$\\d+")) {
			String expression = localName.split("\\+")[2];
			String result = rdf123Exp.evaluate(expression, row);
			if (result != null) {
				if (BasicUtils.isValidURL(result)) {
					return result;
				} else {
					return result;
				}
			} else
				return null;
		} else if (localName.matches("ont\\+\\$\\d+")) {
			String expression = localName.split("\\+")[1];
			String result = rdf123Exp.evaluate(expression, row);
			if (result != null) {
				if (BasicUtils.isValidURL(result)) {
					return result;
				} else {
					return result;
				}
			} else
				return null;
		} else {
			return objectString;
		}
	}
	private void checkMapGetRdfNode(Model rdfModel, RDFNode[] objectAry, Map<String, String[]> mapInstanceExp, Resource objectResource) throws Exception {
		String[] strEiURIAry = mapInstanceExp.get(objectResource.getURI());
		if (strEiURIAry != null) {
			int i = 0;
			for (String strEIURI : strEiURIAry) {
				RDFNode object = rdfModel.createResource(strEIURI);
				objectAry[i] = object;
				i++;
			}
		}
	}
	private Property getPredicate(Model rdfModel, Rdf123Expression rdf123Exp, Property predicateMap, int row) throws Exception {
		if (predicateMap.getURI().startsWith(Configure.EX)) {
			String result = rdf123Exp.evaluate(predicateMap.getURI().substring(Configure.EX.length()), row);
			if (result != null)
				result.replace('$', ' ');
			if (result != null) {
				return rdfModel.createProperty(result);
			} else
				return null;
		} else {
			return predicateMap;
		}
	}
	private boolean ontProcess(Model mapModel, Model rdfModel, Rdf123Expression rdf123Exp, int row, Map<String, String[]> mapInstanceExp, RDFNode[] objectAry, String objectResourceURI) throws Exception {
		try {
			/*
			 * String[] splitStr = objectResourceURI.split("\\+"); String
			 * rootURI = mapModel.expandPrefix(splitStr[1]); String
			 * subclassLabel = rdf123Exp.evaluate(splitStr[2], row);
			 */
			String[] strAry = getLabelAndRootURI(rdfModel, row, rdf123Exp);
			String rootURI = strAry[1];
			String subclassLabel = strAry[0];
			if (subclassLabel == null) {
				return false;
			}
			if (subclassLabel.equalsIgnoreCase("core facility")) {
				subclassLabel = "core laboratory";
			}
			if (subclassLabel.equalsIgnoreCase("research facility")) {
				subclassLabel = "laboratory";
			}
			if (subclassLabel.equalsIgnoreCase("laboratory")) {
				subclassLabel = "laboratory";
			}
			String result = checkOntology(rdf123Exp, row, subclassLabel, rootURI, mapModel);
			logger.debug("Result from onlology :" + result);
			boolean retBoolean = false;
			if (result != null) {
				RDFNode object = rdfModel.createResource(result);
				objectAry[0] = object;
				retBoolean = true;
				return retBoolean;
			} else {
				putInMap(mapInstanceExp, objectResourceURI, "http://eagle-i.org/ont/dt/temporary/" + subclassLabel);
				RDFNode object = rdfModel.createLiteral(subclassLabel);
				objectAry[0] = object;
				retBoolean = false;
				return retBoolean;
			}
		} catch (ArrayIndexOutOfBoundsException e) {
			throw e;
		}
	}
	private String checkOntology(Rdf123Expression rdf123Exp, int row, String label, String URI, Model mapModel) throws Exception {
		String result = null;
		if (label != null) {
			result = anntModel.findSubclassByLabel(URI, label.replace("  ", " ").trim());
		}
		return result;
	}
	/**
	 * converts Excel into CSV TableModel
	 * 
	 * @param excelInputStream
	 * @return
	 * @throws Exception
	 */
	public Map<String, DefaultTableModel> ExcelToTableModel(InputStream excelInputStream) throws Exception {
		Workbook wb;
		int TypeCellNum = 0;
		try {
			wb = WorkbookFactory.create(excelInputStream);
		} catch (FileNotFoundException e) {
			throw new ExcelParserException(e);
		} catch (InvalidFormatException e) {
			throw new ExcelParserException("Expecting an Excel file", e);
		} catch (IOException e) {
			throw new ExcelParserException(e);
		} finally {
			try {
				if (excelInputStream != null)
					excelInputStream.close();
			} catch (IOException e) {
				logger.error(e);/* can't do anything */
			}
		}
		Map<String, DefaultTableModel> tableModelMap = new HashMap<String, DefaultTableModel>();
		int numBerOFSheets = wb.getNumberOfSheets();
		boolean globalColumns = false;
		String[] globalColumnsAry = null;
		String[] strGlobalColumnsOrderAry = null;
		for (int sheetNum = 0; sheetNum <= numBerOFSheets - 1; sheetNum++) {
			Sheet sheet = wb.getSheetAt(sheetNum);
			logger.info("Reading " + sheet.getSheetName());
			int rowcount = sheet.getLastRowNum();
			if (rowcount == 0) {
				logger.info("no Rows in sheet...ignoring");
				continue;
			}
			int colcount;
			if (sheet.getRow(1) == null) {
				continue;
			} else {
				colcount = sheet.getRow(1).getLastCellNum();
			}
			double startRow = 0;
			double endRow = 0;
			int rowheadStart = 0;
			int k = 0;
			int headerRow = 0;
			endRow = sheet.getPhysicalNumberOfRows();
			boolean formVersionFound = false;
			if (sheet.getSheetName().equalsIgnoreCase("lab")) {
				int universityCellNum = 0;
				outer: while (k <= endRow - 1) {
					Row row = sheet.getRow(k);
					Iterator<Cell> cellIter = row.cellIterator();
					int cellNum = 0;
					while (cellIter.hasNext()) {
						Cell cell = cellIter.next();
						if (cell.getStringCellValue().contains("FORM VERSION")) {
							universityCellNum = cellNum;
							RdfMaker.mapDirectory = RdfMaker.mapDirectory + "/" + cell.getStringCellValue().split("FORM VERSION")[0].toLowerCase().trim();
							formVersionFound = true;
							headerRow = k;
						}
						if (formVersionFound && (cellNum == universityCellNum - 1 && k == headerRow + 1) || cell.getStringCellValue().matches("v\\d+")) {
							if (!cell.getStringCellValue().equals("")) {
								RdfMaker.mapDirectory = RdfMaker.mapDirectory + "_" + cell.getStringCellValue().toLowerCase();
								break outer;
							}
						}
						cellNum++;
					}
					k++;
				}
			}
			Map<String, String> rowConfigMap = RowConfiguration.getRowInfoMap(RdfMaker.mapDirectory, sheet.getSheetName());
			startRow = Integer.parseInt(rowConfigMap.get("startrow"));
			rowheadStart = Integer.parseInt(rowConfigMap.get("rowheadstart"));
			order = rowConfigMap.get("order");
			String strGlobalColumns = rowConfigMap.get("globalcolumnsorderinexcel");
			String strGlobalColumnsOrder = rowConfigMap.get("globalcolumnsorderintoCSV");
			/* to fetch the globalcolumns and globalvalues */
			if (strGlobalColumns != null && !globalColumns) {
				globalColumns = true;
				globalColumnsAry = strGlobalColumns.split("#");
				strGlobalColumnsOrderAry = strGlobalColumnsOrder.split("#");
				globalColumnsHash = new HashMap<String, String>();
			}
			if (!order.toLowerCase().contains(sheet.getSheetName().toLowerCase())) {
				continue;
			}
			DefaultTableModel tableModel = new DefaultTableModel(rowcount + 1, colcount + 4);
			for (int row = Configure.baseRow; row < rowcount; row++) {
				tableModel.setValueAt(String.valueOf(row + 1), row, 0);
			}
			for (int row = Configure.baseRow; row < rowcount; row++)
				for (int col = Configure.baseCol; col < colcount + 1; col++)
					tableModel.setValueAt(new String(""), row, col);
			Iterator<Row> rowIter = sheet.rowIterator();
			while (rowIter.hasNext()) {
				Row row = rowIter.next();
				Iterator<Cell> cellIter = row.cellIterator();
				while (cellIter.hasNext()) {
					Cell cell = cellIter.next();
					int rowNum = row.getRowNum();
					int colNum = cell.getColumnIndex();
				}
				break;
			}
			if (globalColumns && !sheet.getSheetName().equalsIgnoreCase("lab")) {
				tableModel.setColumnCount(tableModel.getColumnCount() + strGlobalColumnsOrderAry.length + 1);
			}
			/* if type is not filled then ignore row */
			/*
			 * outer: while (k <= endRow - 1) { Row row = sheet.getRow(k);
			 * Iterator<Cell> cellIter = row.cellIterator(); int cellNum = 0;
			 * while (cellIter.hasNext()) { Cell cell = cellIter.next(); if
			 * (cell.getStringCellValue().contains("TYPE")) { TypeCellNum =
			 * cellNum; break outer; }
			 * 
			 * if (k == startRow - 1) { if (cellNum == TypeCellNum) { //
			 * RdfMaker.university = // cell.getStringCellValue().toLowerCase();
			 * } }
			 * 
			 * 
			 * cellNum++; } k++; }
			 */
			int i = (int) startRow - 1;
			while (i <= endRow - 1) {
				Row row = sheet.getRow(i);
				if (row == null)
					break;
				if (ExcelUtils.isBlankRow(row)) {
					i++;
					continue;
				}
				Iterator<Cell> cellIter = row.cellIterator();
				int tempLoop = 0;
				// int cellNum = 0;
				boolean rowProcessed = false;
				while (cellIter.hasNext()) {
					if (tempLoop >= colcount) {
						break;
					}
					Cell cell = cellIter.next();
					if (sheet.getSheetName().equalsIgnoreCase("lab") && globalColumns) {
						if (tempLoop <= globalColumnsAry.length - 1) {
							globalColumnsHash.put(globalColumnsAry[tempLoop], cell.getStringCellValue());
						}
					}
					int rowNum = row.getRowNum();
					int colNum;
					if (globalColumns && rowheadStart > 0 && rowNum >= rowheadStart && globalColumnsAry[0] != null && !sheet.getSheetName().equalsIgnoreCase("lab")) {
						colNum = cell.getColumnIndex() + strGlobalColumnsOrderAry.length;
					} else {
						colNum = cell.getColumnIndex();
					}
					addCell(tableModel, cell, rowNum, colNum);
					tempLoop++;
				}
				/* If globalcolumsn is configured then add those values to csv */
				if (globalColumns && globalColumnsAry[0] != null && !sheet.getSheetName().equalsIgnoreCase("lab")) {
					if (i == rowheadStart && globalColumnsAry.length > 0) {
						int y = 0;
						for (String s : globalColumnsAry) {
							addCell(tableModel, s, i, y);
							y++;
						}
					} else if (i > rowheadStart && globalColumnsHash != null) {
						int y = 0;
						for (String strColumn : strGlobalColumnsOrderAry) {
							addCell(tableModel, globalColumnsHash.get(strColumn), i, y);
							y++;
						}
					}
				}
				i++;
			}
			tableModelMap.put(sheet.getSheetName(), tableModel);
		//	System.out.println(tableModel.getDataVector().toString());
		}
		return tableModelMap;
	}
	private void addCell(DefaultTableModel tableModel, Cell cell, int rowNum, int colNum) {
		try {
			tableModel.setValueAt(cell.getStringCellValue() + "", rowNum, colNum + Configure.baseCol);
		} catch (ArrayIndexOutOfBoundsException e) {
			throw e;
		} catch (Exception e) {
			tableModel.setValueAt((int) cell.getNumericCellValue() + "", rowNum, colNum + Configure.baseCol);
		}
	}
	private void addCell(DefaultTableModel tableModel, final String cellValue, final int rowNum, final int colNum) {
		tableModel.setValueAt(cellValue, rowNum, colNum + Configure.baseCol);
	}
	private String toURI(final String base, final String localname) {
		if (base.endsWith("/"))
			return base + localname;
		else
			return base + "#" + localname;
	}
	/**
	 * get instance URI from the returned xml
	 * 
	 * @param xmlString
	 * @return
	 */
	public static String[] getInstanceURI(final String xmlString) {
		if (xmlString != null) {
			java.util.regex.Pattern instancePattern = java.util.regex.Pattern.compile("<uri>([^<]*?)</uri>");
			java.util.regex.Matcher match = instancePattern.matcher(xmlString);
			String[] instanceStr = null;
			while (match.find()) {
				int count = match.groupCount();
				instanceStr = new String[count];
				for (int i = 1; i <= count; i++) {
					instanceStr[i - 1] = match.group(i);
				}
			}
			return instanceStr;
		} else {
			return null;
		}
	}
	public String[] getLabelAndRootURI(Model tempModel, int row, Rdf123Expression rdf123Exp) throws Exception {
		StmtIterator stmtIterator = tempModel.listStatements();
		String[] retString = new String[2];
		while (stmtIterator.hasNext()) {
			Statement stmtMap = stmtIterator.nextStatement();
			Resource subjectMap = stmtMap.getSubject();
			Property predicateMap = stmtMap.getPredicate();
			RDFNode objectMap = stmtMap.getObject();
			if (predicateMap.getURI().equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#type")) {
				retString[1] = objectMap.toString();
			}
			if (predicateMap.getURI().equals("http://www.w3.org/2000/01/rdf-schema#label")) {
				Literal objectLiteral = (Literal) objectMap;
				String result = evaluateExpression(rdf123Exp, row, objectLiteral.getString());
				retString[0] = result;
			}
		}
		return retString;
	}
	public String getLabelBySubjectExpression(Model tempModel, int row, Rdf123Expression rdf123Exp, String subjectExpression) throws Exception {
		StmtIterator stmtIterator = tempModel.listStatements();
		String retString = new String();
		while (stmtIterator.hasNext()) {
			Statement stmtMap = stmtIterator.nextStatement();
			Resource subjectMap = stmtMap.getSubject();
			Property predicateMap = stmtMap.getPredicate();
			RDFNode objectMap = stmtMap.getObject();
			if (subjectExpression.equals(subjectMap.toString()) && predicateMap.getURI().equals("http://www.w3.org/2000/01/rdf-schema#label")) {
				Literal objectLiteral = (Literal) objectMap;
				String result = evaluateExpression(rdf123Exp, row, objectLiteral.getString());
				retString = result;
			}
		}
		return retString;
	}
	public String getObjectFromModelBySubjectAndType(Model rdfModel, String subjectExpression) {
		StmtIterator stmtIterator = rdfModel.listStatements();
		while (stmtIterator.hasNext()) {
			Statement stmtMap = stmtIterator.nextStatement();
			Resource subjectMap = stmtMap.getSubject();
			Property predicateMap = stmtMap.getPredicate();
			RDFNode objectMap = stmtMap.getObject();
			if (subjectMap.toString().equals(subjectExpression) && predicateMap.getURI().equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#type")) {
				return objectMap.toString();
			}
		}
		return null;
	}
	public String getTypeFromModelByObject(Model rdfModel, String objectExpression) {
		StmtIterator stmtIterator = rdfModel.listStatements();
		while (stmtIterator.hasNext()) {
			Statement stmtMap = stmtIterator.nextStatement();
			Resource subjectMap = stmtMap.getSubject();
			Property predicateMap = stmtMap.getPredicate();
			RDFNode objectMap = stmtMap.getObject();
			if (objectMap.toString().equals(objectExpression)) {
				return predicateMap.toString();
			}
		}
		return null;
	}
}
