/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.interim.cores;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OldFileUtils {
    private static final Log logger = LogFactory.getLog(OldFileUtils.class);

    public static List<File> getAllFiles(File inputDir) throws FileNotFoundException {
        OldFileUtils.validateDirectory(inputDir, false);
        ArrayList<File> files = new ArrayList<File>();
        List<File> filesAndDirs = Arrays.asList(inputDir.listFiles());
        for (File file : filesAndDirs) {
            files.add(file);
            if (file.isFile()) continue;
            List<File> deeperList = OldFileUtils.getAllFiles(file);
            files.addAll(deeperList);
        }
        return files;
    }

    public static void validateDirectory(String dirString, boolean create) throws FileNotFoundException {
        File dir = new File(dirString);
        OldFileUtils.validateDirectory(dir, create);
    }

    public static void validateDirectory(File dir, boolean create) throws FileNotFoundException {
        if (dir == null) {
            throw new IllegalArgumentException("Directory should not be null.");
        }
        if (!dir.exists()) {
            if (create) {
                if (!dir.mkdir()) {
                    throw new IllegalArgumentException("Failed to create directory: " + dir);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Creating directory: " + dir));
                }
            } else {
                throw new FileNotFoundException("Directory does not exist: " + dir);
            }
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("Is not a directory: " + dir);
        }
        if (!dir.canRead()) {
            throw new IllegalArgumentException("Directory cannot be read: " + dir);
        }
    }
}

