/**
 * eagle-i Project
 * Harvard University
 * Jan 19, 2010
 */
package org.eaglei.datatools.interim.cores;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.eaglei.datatools.interim.cores.Mapping.MappingType;
import org.eaglei.datatools.interim.cores.Mapping.SourceType;
import org.eaglei.model.EagleIOntConstants;
import static org.eaglei.datatools.model.DataToolsOntConstants.*;

/**
 * @author Daniela Bourges-Waldegg
 *
 */
public final class Cores3Mappings {
	
	public static final int LAB_FIRST_ROW = 17;
	public static final int INSTRUMENT_FIRST_ROW = 336;
	public static final int PROTOCOL_FIRST_ROW = 168;
	public static final int SOFTWARE_FIRST_ROW = 43;
	public static final int SERVICE_FIRST_ROW = 3;
	public static final int ADDITIONAL_FIRST_ROW = 3;
	

	
	public static final Mapping LAB_MAP = new Mapping(MappingType.CLASS, SourceType.TAB,
			"LAB", EAGLE_I_URI, "ERO_0000001");
	public static final Mapping INSTRUMENT_MAP = new Mapping(MappingType.CLASS, SourceType.TAB,
			"INSTRUMENT", EAGLE_I_URI, "ERO_0000004");
	public static final Mapping PROTOCOL_MAP = new Mapping(MappingType.CLASS, SourceType.TAB,
			"PROTOCOL", EAGLE_I_URI, "ERO_0000007");
	public static final Mapping SOFTWARE_MAP = new Mapping(MappingType.CLASS, SourceType.TAB,
			"SOFTWARE", EAGLE_I_URI, "ERO_0000071");
	public static final Mapping SERVICE_MAP = new Mapping(MappingType.CLASS, SourceType.TAB,
			"SERVICE", EAGLE_I_URI, "ERO_0000005");
	public static final Mapping ADDITIONAL_MAP = new Mapping(MappingType.CLASS, SourceType.TAB,
			"ADDITIONAL_RESOURCES", EAGLE_I_DT_URI, "TopLevelTermRequest");
	
	//common mappings
	public static final Mapping rnavName = new Mapping("RNAV_NAME", DC_URI, "creator", FOAF_PERSON);
	public static final Mapping extraData = new Mapping("EXTRA_DATA", EAGLE_I_DT_URI, "extra_data");
	public static final Mapping rnavsComments = new Mapping("RNAVS_COMMENTS", RDFS_URI, "comment");
	public static final Mapping curatorsComments = new Mapping("CURATORS_COMMENTS", EAGLE_I_URI, "IAO_0000232");
	public static final Mapping capturedWith = new Mapping("ANNOTATION_FORM_VERSION", EAGLE_I_DT_URI, "captured_with");
	
	
	static {
		//Lab
		LAB_MAP.addMapping(rnavName);
		LAB_MAP.addMapping("UNIVERSITY", EAGLE_I_URI, "ERO_0000066", EI_UNIVERSITY);
		LAB_MAP.addMapping("LAB_NAME", RDFS_URI, "label");
		LAB_MAP.addMapping("LAB_TYPE", RDF_URI, "type");
		LAB_MAP.addMapping("PI_NAME", EAGLE_I_URI, "ERO_0000022", FOAF_PERSON);
		LAB_MAP.addMapping("LAB_CONTACT_NAME", EAGLE_I_URI, "ERO_0000021", FOAF_PERSON);
		LAB_MAP.addMapping("LAB_CONTACT_PHONE_NUMBER", EAGLE_I_URI, "ERO_0000051");
		LAB_MAP.addMapping("LAB_CONTACT_EMAIL", EAGLE_I_URI, "ERO_0000041");
		LAB_MAP.addMapping("LAB_URL", EAGLE_I_URI, "ERO_0000047");
		LAB_MAP.addMapping("LAB_MAILING_ADDRESS", EAGLE_I_URI, "ERO_0000040");
		LAB_MAP.addMapping("LAB_DELIVERY_ADDRESS",EAGLE_I_URI,"ERO_0000055");
		LAB_MAP.addMapping("LAB_AFFILIATION",EAGLE_I_URI, "ERO_0000066", OBI_ORGANIZATION);
		LAB_MAP.addMapping("LAB_INVENTORY_SYSTEM", EAGLE_I_URI, "ERO_0000053");
		LAB_MAP.addMapping("LAB_INVENTORY_DATA_FORMAT", EAGLE_I_URI, "ERO_0000054");
		LAB_MAP.addMapping("LAB_DOCUMENTATION_FILE", EAGLE_I_URI, "ERO_0000068");
		LAB_MAP.addMapping(extraData);
		LAB_MAP.addMapping(rnavsComments);
		LAB_MAP.addMapping("LAB_CONCERNS", EAGLE_I_DT_URI, "lab_concerns");
		LAB_MAP.addMapping("LAB_SUGGESTIONS", EAGLE_I_URI, "lab_suggestions");
		LAB_MAP.addMapping(curatorsComments);
		LAB_MAP.addMapping(capturedWith);
		//Instrument
		INSTRUMENT_MAP.addMapping("LAB_NAME", RO_URI, "located_in", EI_LAB);
		INSTRUMENT_MAP.addMapping(rnavName);
		INSTRUMENT_MAP.addMapping("INSTRUMENT_LABEL", RDFS_URI, "label");
		INSTRUMENT_MAP.addMapping("INSTRUMENT_TYPE", RDF_URI, "type");
		INSTRUMENT_MAP.addMapping("INSTRUMENT_TERM_REQUEST", EAGLE_I_DT_URI, "has_term_request", DT_TERM_REQUEST);
		INSTRUMENT_MAP.addMapping("INSTRUMENT_MANUFACTURER", EAGLE_I_URI, "ERO_0000034", OBI_ORGANIZATION);
		INSTRUMENT_MAP.addMapping("INSTRUMENT_MODEL_NAME_ANDOR_NUMBER", EAGLE_I_URI, "ERO_0000050");
		INSTRUMENT_MAP.addMapping("INSTRUMENT_YEAR_FIRST_USED", EAGLE_I_URI, "ERO_0000067");
		INSTRUMENT_MAP.addMapping("INSTITUTION_INTERNAL_INSTRUMENT_INVENTORY_NUMBER", EAGLE_I_URI, "ERO_0000044");
		INSTRUMENT_MAP.addMapping("MANUFACTURER_URL", EAGLE_I_URI, "ERO_0000047");
		INSTRUMENT_MAP.addMapping(extraData);
		INSTRUMENT_MAP.addMapping(rnavsComments);
		INSTRUMENT_MAP.addMapping(curatorsComments);
		INSTRUMENT_MAP.addMapping(capturedWith);		
		//Protocol		
		PROTOCOL_MAP.addMapping("LAB_NAME", RO_URI, "located_in", EI_LAB);
		PROTOCOL_MAP.addMapping(rnavName);
		PROTOCOL_MAP.addMapping("PROTOCOL_LABEL", RDFS_URI, "label");
		PROTOCOL_MAP.addMapping("PROTOCOL_TYPE", RDF_URI, "type");
		PROTOCOL_MAP.addMapping("PROTOCOL_TERM_REQUEST", EAGLE_I_DT_URI, "has_term_request", DT_TERM_REQUEST);
		PROTOCOL_MAP.addMapping("PROTOCOL_DOCUMENTATION_URL", EAGLE_I_URI, "ERO_0000047");
		PROTOCOL_MAP.addMapping("PROTOCOL_DOCUMENTATION_FILE", EAGLE_I_URI, "ERO_0000068");
		PROTOCOL_MAP.addMapping("PROTOCOL_SUBJECT", EAGLE_I_URI, "ERO_0000234");
		PROTOCOL_MAP.addMapping("INSTRUMENT_SPECIFIED_BY_PROTOCOL", EAGLE_I_URI, "ERO_0000038", EI_INSTRUMENT);
		PROTOCOL_MAP.addMapping(extraData);
		PROTOCOL_MAP.addMapping(rnavsComments);
		PROTOCOL_MAP.addMapping(curatorsComments);
		PROTOCOL_MAP.addMapping(capturedWith);
		//Software
		SOFTWARE_MAP.addMapping("LAB_NAME", RO_URI, "located_in", EI_LAB);
		SOFTWARE_MAP.addMapping(rnavName);
		SOFTWARE_MAP.addMapping("SOFTWARE_NAME", RDFS_URI, "label");
		SOFTWARE_MAP.addMapping("VERSION", EAGLE_I_URI, "ERO_0000072");
		SOFTWARE_MAP.addMapping("INPUT_DATA", EAGLE_I_URI, "ERO_0000076", SW_DATA);
		SOFTWARE_MAP.addMapping("INPUT DATA TERM REQUEST", EAGLE_I_DT_URI, "has_term_request", DT_TERM_REQUEST);
		SOFTWARE_MAP.addMapping("DATA_PROCESSING_OBJECTIVE", EAGLE_I_URI, "ERO_0000078", OBI_OBJECTIVE);
		SOFTWARE_MAP.addMapping("DATA PROCESSING OBJECTIVE TERM REQUEST", EAGLE_I_DT_URI, "has_term_request", DT_TERM_REQUEST);
		SOFTWARE_MAP.addMapping("MANUFACTURER", EAGLE_I_URI, "ERO_0000034", OBI_ORGANIZATION);
		SOFTWARE_MAP.addMapping("OPERATING_SYSTEM", EAGLE_I_URI, "ERO_0000073");
		SOFTWARE_MAP.addMapping("SOFTWARE_URL", EAGLE_I_URI, "ERO_0000047");
		SOFTWARE_MAP.addMapping("SOFTWARE_DOCUMENTATION_FILE", EAGLE_I_URI,"ERO_0000068");
		SOFTWARE_MAP.addMapping(extraData);
		SOFTWARE_MAP.addMapping(rnavsComments);
		SOFTWARE_MAP.addMapping(curatorsComments);
		SOFTWARE_MAP.addMapping(capturedWith);		
		//Service
		SERVICE_MAP.addMapping("LAB_NAME", RO_URI, "located_in", EI_LAB);
		SERVICE_MAP.addMapping(rnavName);
		SERVICE_MAP.addMapping("SERVICE_LABEL", RDFS_URI, "label");
		SERVICE_MAP.addMapping("SERVICE_CONTACT_NAME", EAGLE_I_URI, "ERO_0000021", FOAF_PERSON);
		SERVICE_MAP.addMapping("SERVICE_PHONE_NUMBER", EAGLE_I_URI, "ERO_0000051");
		SERVICE_MAP.addMapping("SERVICE_URL", EAGLE_I_URI, "ERO_0000047");
		SERVICE_MAP.addMapping("SERVICE_DOCUMENTATION_FILE", EAGLE_I_URI, "ERO_0000068");
		SERVICE_MAP.addMapping("SERVICE_EMAIL_ADDRESS", EAGLE_I_URI, "ERO_0000041");
		SERVICE_MAP.addMapping("SERVICE_RESTRICTION_GEOGRAPHIC", EAGLE_I_URI, "ERO_0000046");
		SERVICE_MAP.addMapping("SERVICE_RESTRICTION_OTHER", EAGLE_I_URI, "ERO_0000045");
		SERVICE_MAP.addMapping("INSTRUMENT_USED_BY_SERVICE", EAGLE_I_URI, "ERO_0000029", EI_INSTRUMENT);
		SERVICE_MAP.addMapping("SOFTWARE_USED_BY_SERVICE", EAGLE_I_URI, "ERO_0000029", EI_SOFTWARE);
		SERVICE_MAP.addMapping(extraData);
		SERVICE_MAP.addMapping(rnavsComments);
		SERVICE_MAP.addMapping(curatorsComments);
		SERVICE_MAP.addMapping(capturedWith);	
		//Additional resources
		ADDITIONAL_MAP.addMapping("LAB_NAME", RO_URI, "located_in", EI_LAB);
		ADDITIONAL_MAP.addMapping(rnavName);
		ADDITIONAL_MAP.addMapping("RESOURCE_NAME", RDFS_URI, "label");
		ADDITIONAL_MAP.addMapping("RESOURCE_TYPE", EAGLE_I_DT_URI, "has_term_request", DT_TOP_TERM_REQUEST);
		ADDITIONAL_MAP.addMapping("RESOURCE_URL", EAGLE_I_URI, "ERO_0000047");
		ADDITIONAL_MAP.addMapping("RESOURCE_FILE", EAGLE_I_URI, "ERO_0000068");
		
	}
	
	//A few lookup tables
	public static final Map<String, Integer> FIRST_ROWS;
	static {
		final HashMap<String, Integer> map = new HashMap<String, Integer>();
		map.put(LAB_MAP.getSourceID(), Integer.valueOf(LAB_FIRST_ROW));
		map.put(INSTRUMENT_MAP.getSourceID(), Integer.valueOf(INSTRUMENT_FIRST_ROW));
		map.put(SOFTWARE_MAP.getSourceID(), Integer.valueOf(SOFTWARE_FIRST_ROW));
		map.put(PROTOCOL_MAP.getSourceID(), Integer.valueOf(PROTOCOL_FIRST_ROW));
		map.put(SERVICE_MAP.getSourceID(), Integer.valueOf(SERVICE_FIRST_ROW));
		map.put(ADDITIONAL_MAP.getSourceID(), Integer.valueOf(ADDITIONAL_FIRST_ROW));
		FIRST_ROWS = map;
	}
	
	public static final Map<String, Mapping> MAPPINGS;
	static {
		final HashMap<String, Mapping> map = new HashMap<String, Mapping>();
		map.put(LAB_MAP.getSourceID(), LAB_MAP);
		map.put(INSTRUMENT_MAP.getSourceID(), INSTRUMENT_MAP);
		map.put(PROTOCOL_MAP.getSourceID(), PROTOCOL_MAP);
		map.put(SOFTWARE_MAP.getSourceID(), SOFTWARE_MAP);
		map.put(SERVICE_MAP.getSourceID(), SERVICE_MAP);
		map.put(ADDITIONAL_MAP.getSourceID(), ADDITIONAL_MAP);
		MAPPINGS = map;
	}
	
}
