/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.jena;

import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Selector;
import com.hp.hpl.jena.rdf.model.SimpleSelector;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.datatools.jena.MetadataConstants;
import org.eaglei.datatools.model.DataToolsEIOntModel;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIDatatypeProperty;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIObjectProperty;
import org.eaglei.model.EIProperty;
import org.eaglei.model.EIURI;

public class EIInstanceFactory {
    private static final Log logger = LogFactory.getLog(EIInstanceFactory.class);
    private static final boolean isDebugEnabled = logger.isDebugEnabled();
    public static final EIInstanceFactory INSTANCE = new EIInstanceFactory();

    public static EIInstanceFactory getInstance() {
        return INSTANCE;
    }

    private EIInstanceFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String serialize(EIInstance instance, String lang) {
        if (instance == null) {
            return null;
        }
        Model model = this.convertToJenaModel(instance);
        StringWriter sw = new StringWriter();
        try {
            model.write((Writer)sw, lang);
            String s = sw.toString();
            sw.flush();
            String string = s;
            return string;
        }
        finally {
            try {
                if (sw != null) {
                    sw.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public Model convertToJenaModel(EIInstance instance) {
        Resource valueResource;
        Set values;
        Property p;
        if (instance == null) {
            return null;
        }
        Model model = ModelFactory.createDefaultModel();
        Resource resourceInstance = model.createResource(instance.getInstanceURI().toString());
        Resource eiType = model.createResource(instance.getInstanceType().getURI().toString());
        model.add(model.createStatement(resourceInstance, RDF.type, (RDFNode)eiType));
        model.add(model.createStatement(resourceInstance, RDFS.label, instance.getInstanceLabel()));
        List otherEITypes = instance.getOtherEITypes();
        if (otherEITypes != null) {
            for (EIEntity t : otherEITypes) {
                Resource typeResource = model.createResource(t.getURI().toString());
                model.add(model.createStatement(resourceInstance, RDF.type, (RDFNode)typeResource));
            }
        }
        Map dataProps = instance.getDatatypeProperties();
        Map objectProps = instance.getObjectProperties();
        Map literalProps = instance.getNonOntologyLiteralProperties();
        Map resourceProps = instance.getNonOntologyResourceProperties();
        Map roResourceProps = instance.getReadOnlyResourceProperties();
        Map roLiteralProps = instance.getReadOnlyLiteralProperties();
        for (Map.Entry entry : dataProps.entrySet()) {
            p = model.createProperty(((EIEntity)entry.getKey()).getURI().toString());
            values = (Set)entry.getValue();
            for (String value : values) {
                if (value == null || value.length() <= 0) continue;
                model.add(model.createStatement(resourceInstance, p, value));
            }
        }
        for (Map.Entry entry : objectProps.entrySet()) {
            p = model.createProperty(((EIEntity)entry.getKey()).getURI().toString());
            values = (Set)entry.getValue();
            if (values == null) continue;
            for (String value : values) {
                if (value == null || value.toString().length() <= 0) continue;
                valueResource = model.createResource(value.toString());
                model.add(model.createStatement(resourceInstance, p, (RDFNode)valueResource));
            }
        }
        for (Map.Entry entry : literalProps.entrySet()) {
            p = model.createProperty(((EIEntity)entry.getKey()).getURI().toString());
            values = (Set)entry.getValue();
            if (values == null) continue;
            for (String value : values) {
                if (value == null || value.length() <= 0) continue;
                model.add(model.createStatement(resourceInstance, p, value));
            }
        }
        for (Map.Entry entry : resourceProps.entrySet()) {
            p = model.createProperty(((EIEntity)entry.getKey()).getURI().toString());
            values = (Set)entry.getValue();
            for (String value : values) {
                if (value == null || value.toString().length() <= 0) continue;
                valueResource = model.createResource(value.toString());
                model.add(model.createStatement(resourceInstance, p, (RDFNode)valueResource));
            }
        }
        for (Map.Entry entry : roLiteralProps.entrySet()) {
            p = model.createProperty(((EIEntity)entry.getKey()).getURI().toString());
            if (entry.getValue() == null || ((String)entry.getValue()).length() <= 0) continue;
            model.add(model.createStatement(resourceInstance, p, (String)entry.getValue()));
        }
        for (Map.Entry entry : roResourceProps.entrySet()) {
            p = model.createProperty(((EIEntity)entry.getKey()).getURI().toString());
            if (entry.getValue() == null || ((EIURI)entry.getValue()).toString().length() <= 0) continue;
            Resource value = model.createResource(((EIURI)entry.getValue()).toString());
            model.add(model.createStatement(resourceInstance, p, (RDFNode)value));
        }
        return model;
    }

    public EIInstance create(EIURI instanceUri, String rdf, String lang) {
        if (instanceUri == null || instanceUri.toString().length() == 0 || rdf == null || rdf.length() == 0) {
            return null;
        }
        Model model = ModelFactory.createDefaultModel();
        model.read((Reader)new StringReader(rdf), null, lang);
        return this.create(instanceUri, model);
    }

    public EIInstance createEmpty(EIURI typeUri, EIEntity instanceEntity) {
        if (instanceEntity == null) {
            return null;
        }
        EIClass instanceClass = DataToolsEIOntModel.INSTANCE.getClass(typeUri);
        if (instanceClass == null) {
            return null;
        }
        String label = instanceClass.getEntity().getLabel();
        instanceClass.getEntity().setLabel(this.capitalizeFirst(label));
        EIInstance ei = EIInstance.create((EIEntity)instanceClass.getEntity(), (EIEntity)instanceEntity);
        ei.setInstanceClass(instanceClass);
        return ei;
    }

    public EIInstance create(EIURI instanceUri, Model model) {
        if (instanceUri == null || model == null) {
            if (isDebugEnabled) {
                logger.debug((Object)"null parameters; no EIInstance was created");
            }
            return null;
        }
        Resource subject = model.getResource(instanceUri.toString());
        if (!model.contains(subject, null, (RDFNode)null)) {
            if (isDebugEnabled) {
                logger.debug((Object)"model doesn't contain subject; no EIInstance was created");
            }
            return null;
        }
        List<EIClass> eiClasses = this.getEIClasses(model, subject);
        if (eiClasses == null) {
            if (isDebugEnabled) {
                logger.debug((Object)"No eagle-i types found in the model");
            }
            return null;
        }
        EIClass instanceClass = eiClasses.get(0);
        eiClasses.remove(0);
        String instanceClassUri = instanceClass.getEntity().getURI().toString();
        Statement labelStatement = subject.getProperty(RDFS.label);
        if (labelStatement == null) {
            if (isDebugEnabled) {
                logger.debug((Object)"RDFS Label is not set for instance");
            }
            return null;
        }
        String instanceLabel = labelStatement.getString();
        if (isDebugEnabled) {
            logger.debug((Object)("Creating an instance of class: " + instanceClass.getEntity().toString() + " with URI: " + instanceUri + " and label: " + instanceLabel));
        }
        EIEntity instanceEntity = EIEntity.create((EIURI)instanceUri, (String)instanceLabel);
        EIInstance ei = EIInstance.create((EIEntity)instanceClass.getEntity(), (EIEntity)instanceEntity);
        ei.setInstanceClass(instanceClass);
        if (!eiClasses.isEmpty()) {
            ArrayList<EIEntity> eiTypes = new ArrayList<EIEntity>(eiClasses.size());
            for (EIClass c : eiClasses) {
                eiTypes.add(c.getEntity());
            }
            ei.setOtherEITypes(eiTypes);
        }
        StmtIterator iter = model.listStatements(subject, null, (RDFNode)null);
        if (isDebugEnabled) {
            logger.debug((Object)("Searching for statements with subject: " + instanceUri.toString() + " of class: " + instanceClass.getEntity() + " and label: " + instanceLabel));
        }
        while (iter.hasNext()) {
            Statement statement = iter.nextStatement();
            Property predicate = statement.getPredicate();
            if (predicate.equals(RDFS.label)) continue;
            EIURI propertyUri = EIURI.create((String)predicate.getURI());
            RDFNode o = statement.getObject();
            if (predicate.equals(RDF.type) && o.isResource() && instanceClassUri.equals(((Resource)o).getURI()) || predicate.equals(RDF.type) && o.isResource() && this.containsUri(eiClasses, ((Resource)o).getURI())) continue;
            EIProperty p = this.getEIOntProperty(instanceClass.getEntity().getURI(), propertyUri);
            if (p != null) {
                this.addEIProperty(ei, p, propertyUri, o);
                continue;
            }
            this.addNonEIProperty(ei, predicate, propertyUri, o);
        }
        return ei;
    }

    public List<EIInstance> create(Model model) {
        if (model == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<EIInstance> instances = new ArrayList<EIInstance>();
        Set subjects = model.listSubjects().toSet();
        for (Resource r : subjects) {
            Model results = model.query((Selector)new SimpleSelector(r, null, (RDFNode)null));
            EIInstance ei = this.create(EIURI.create((String)r.getURI()), results);
            if (ei == null) continue;
            instances.add(ei);
        }
        return instances;
    }

    public List<EIInstance> create(ResultSet resultSet) {
        if (resultSet == null) {
            return Collections.EMPTY_LIST;
        }
        HashMap<EIURI, EIInstance> instances = new HashMap<EIURI, EIInstance>();
        ArrayList<EIInstance> instanceList = new ArrayList<EIInstance>();
        while (resultSet.hasNext()) {
            EIInstance ei;
            QuerySolution qs = resultSet.next();
            if (!qs.contains("s") || !qs.contains("t") || !qs.contains("l")) continue;
            EIURI instanceUri = EIURI.create((String)qs.getResource("s").getURI());
            EIURI instanceType = EIURI.create((String)qs.getResource("t").getURI());
            String label = qs.getLiteral("l").getString();
            if (DataToolsEIOntModel.INSTANCE.getClass(instanceType) == null) continue;
            if (!instances.containsKey(instanceUri)) {
                ei = this.createEmpty(instanceType, EIEntity.create((EIURI)instanceUri, (String)label));
                instances.put(instanceUri, ei);
                instanceList.add(ei);
                if (isDebugEnabled) {
                    logger.debug((Object)("Creating new EIInstance: " + ei));
                }
            } else {
                ei = (EIInstance)instances.get(instanceUri);
                ei.addEIType(EIEntity.create((EIURI)instanceType, (String)""));
                if (isDebugEnabled) {
                    logger.debug((Object)("Adding type: " + instanceType + " to existing EIInstance :" + ei));
                }
            }
            if (qs.contains("own")) {
                EIURI owner = EIURI.create((String)qs.getResource("own").getURI());
                ei.setWFOwner(owner);
            }
            if (qs.contains("state")) {
                EIURI state = EIURI.create((String)qs.getResource("state").getURI());
                ei.setWFState(state);
            }
            if (!qs.contains("date")) continue;
            String date = qs.getLiteral("date").getString();
            ei.setCreationDate(date);
        }
        return instanceList;
    }

    private EIProperty getEIOntProperty(EIURI instanceClassUri, EIURI propertyUri) {
        if (instanceClassUri == null || propertyUri == null) {
            return null;
        }
        List properties = DataToolsEIOntModel.INSTANCE.getProperties(instanceClassUri);
        if (properties == null || properties.isEmpty()) {
            return null;
        }
        for (EIProperty p : properties) {
            EIURI propUri = p.getEntity().getURI();
            if (!propUri.equals((Object)propertyUri)) continue;
            return p;
        }
        return null;
    }

    private List<EIClass> getEIClasses(Model model, Resource subject) {
        List typeStatements = model.listStatements(subject, RDF.type, (RDFNode)((Resource)null)).toList();
        if (typeStatements == null || typeStatements.isEmpty()) {
            return null;
        }
        ArrayList<EIClass> eiClasses = new ArrayList<EIClass>();
        for (Statement st : typeStatements) {
            Resource type = (Resource)st.getObject();
            EIURI typeUri = EIURI.create((String)type.getURI());
            EIClass eiClass = DataToolsEIOntModel.INSTANCE.getClass(typeUri);
            if (eiClass == null) continue;
            eiClasses.add(eiClass);
        }
        return eiClasses.isEmpty() ? null : eiClasses;
    }

    private void addEIProperty(EIInstance ei, EIProperty p, EIURI propertyUri, RDFNode o) {
        String preferredLabel = DataToolsEIOntModel.INSTANCE.getPreferredLabel(propertyUri);
        EIEntity propEntity = EIEntity.create((EIURI)propertyUri, (String)this.capitalizeFirst(preferredLabel));
        if (p instanceof EIDatatypeProperty) {
            if (o.isLiteral()) {
                String value = o.toString();
                if (isDebugEnabled) {
                    logger.debug((Object)("adding property: [" + propertyUri + "] with literal value : [" + value + "] "));
                }
                ei.addDatattypeProperty(propEntity, value);
            } else {
                if (isDebugEnabled) {
                    logger.debug((Object)("property: [" + propertyUri + "] found in ontology but value is not literal; adding as non-ontology property "));
                }
                ei.addNonOntologyResourceProperty(propEntity, EIURI.create((String)((Resource)o).getURI()));
            }
        } else if (p instanceof EIObjectProperty) {
            if (o.isResource()) {
                EIURI objectUri = EIURI.create((String)((Resource)o).getURI());
                if (isDebugEnabled) {
                    logger.debug((Object)("adding property: [" + propertyUri + "] with object value : [" + objectUri + "] "));
                }
                ei.addObjectProperty(propEntity, objectUri);
                ei.setRangeList(propEntity, ((EIObjectProperty)p).getRangeList());
            } else {
                if (isDebugEnabled) {
                    logger.debug((Object)("property: [" + propertyUri + "] found in ontology but value is not resource; adding as non-ontology property "));
                }
                ei.addNonOntologyLiteralProperty(propEntity, o.toString());
            }
        }
    }

    private void addNonEIProperty(EIInstance ei, Property predicate, EIURI propertyUri, RDFNode o) {
        EIEntity propEntity;
        if (isDebugEnabled) {
            logger.debug((Object)("Property not found in ontology; we'll still add it: " + propertyUri));
        }
        if (MetadataConstants.readOnlyResources.containsKey(propertyUri)) {
            propEntity = MetadataConstants.readOnlyResources.get(propertyUri);
        } else if (MetadataConstants.readOnlyLiterals.containsKey(propertyUri)) {
            propEntity = MetadataConstants.readOnlyLiterals.get(propertyUri);
        } else {
            String predicateLabel = predicate.getLocalName();
            propEntity = EIEntity.create((EIURI)propertyUri, (String)predicateLabel);
        }
        if (o.isLiteral()) {
            if (MetadataConstants.readOnlyLiterals.containsKey(propertyUri)) {
                ei.setReadOnlyLiteralProperty(propEntity, o.toString());
            } else {
                ei.addNonOntologyLiteralProperty(propEntity, o.toString());
            }
        } else if (o.isResource()) {
            if (MetadataConstants.readOnlyResources.containsKey(propertyUri)) {
                ei.setReadOnlyResourceProperty(propEntity, EIURI.create((String)((Resource)o).getURI()));
            } else {
                ei.addNonOntologyResourceProperty(propEntity, EIURI.create((String)((Resource)o).getURI()));
            }
        } else if (isDebugEnabled) {
            logger.debug((Object)("Could not add property " + propertyUri));
        }
    }

    private boolean containsUri(List<EIClass> eiClasses, String uri) {
        if (eiClasses == null || uri == null) {
            return false;
        }
        for (EIClass eiClass : eiClasses) {
            if (!uri.equalsIgnoreCase(eiClass.getEntity().getURI().toString())) continue;
            return true;
        }
        return false;
    }

    private String capitalizeFirst(String s) {
        char first = s.charAt(0);
        String S = Character.toUpperCase(first) + s.substring(1);
        return S;
    }
}

