/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.interim.cores;

import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.datatools.interim.cores.Mapping;
import org.eaglei.datatools.interim.cores.UniversityConstants;

public class Cores3Model {
    private static final Log logger = LogFactory.getLog(Cores3Model.class);
    private Model model;
    private final OntModel ontModel;
    private String university;
    private final Property directType;

    public Cores3Model(OntModel datatoolsJenaOntModel) {
        this.ontModel = datatoolsJenaOntModel;
        this.model = ModelFactory.createDefaultModel();
        this.model.setNsPrefix("eagle-i", "http://purl.obolibrary.org/obo/");
        this.model.setNsPrefix("eagle-i-dt-ont", "http://eagle-i.org/ont/datatools/1.0/");
        this.directType = this.model.createProperty("http://purl.obolibrary.org/obo/directType");
    }

    public void createResourceInstance(Mapping mapping, Map<String, String> columns) {
        if (this.university == null) {
            this.university = UniversityConstants.EAGLE_I_SITES.get(columns.get("UNIVERSITY"));
        }
        Resource resourceInstance = this.createInstance();
        this.setSubclassesAndProperties(mapping, resourceInstance, columns);
    }

    public Model getModel() {
        return this.model;
    }

    private Resource createInstance(String classUri) {
        Resource r = this.createInstance();
        this.setType(r, classUri);
        return r;
    }

    private Resource createInstance() {
        String uri = "http://" + this.university + ".data.eagle-i.org/i/" + "INSTANCE_" + UUID.randomUUID().toString();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Creating resource with URI= " + uri));
        }
        Resource resourceInstance = this.model.createResource(uri);
        return resourceInstance;
    }

    private void setType(Resource r, String classUri) {
        OntClass resourceClass = this.ontModel.getOntClass(classUri);
        if (resourceClass != null) {
            this.model.add(this.model.createStatement(r, RDF.type, (RDFNode)resourceClass));
        } else {
            this.model.add(this.model.createStatement(r, RDF.type, (RDFNode)this.model.createResource(classUri)));
        }
    }

    private void setDirectType(Resource r, String classUri) {
        OntClass resourceClass = this.ontModel.getOntClass(classUri);
        if (resourceClass != null) {
            this.model.add(this.model.createStatement(r, this.directType, (RDFNode)resourceClass));
        }
    }

    private void setSubclassesAndProperties(Mapping mapping, Resource resourceInstance, Map<String, String> columns) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Resource of class: " + mapping.getTargetUri()));
        }
        OntClass resourceClass = this.ontModel.getOntClass(mapping.getTargetUri());
        for (Map.Entry<String, String> entry : columns.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            String targetUri = mapping.getTargetUri(key);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Processing column: " + key + ", for property: " + targetUri + " with value: " + value));
            }
            if (targetUri == null) {
                Property p = this.model.createProperty("http://eagle-i.org/ont/unknown/", key.toLowerCase());
                this.model.add(this.model.createStatement(resourceInstance, p, value));
                continue;
            }
            if (RDF.type.getURI().equals(targetUri)) {
                OntClass subclass = this.findSubclass(resourceClass, value, false);
                if (subclass != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Setting subtype to: " + subclass.getURI()));
                    }
                    this.model.add(this.model.createStatement(resourceInstance, RDF.type, (RDFNode)subclass));
                    continue;
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("A subclass of " + resourceClass.getLabel(null) + " with label " + value + " was not found in the eagle-i ontology. Doing nothing"));
                continue;
            }
            if (RDFS.label.getURI().equals(targetUri)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Setting label to: " + value));
                }
                this.model.add(this.model.createStatement(resourceInstance, RDFS.label, value));
                continue;
            }
            OntProperty o = this.ontModel.getOntProperty(targetUri);
            if (o == null) continue;
            String[] values = value.split(";");
            if (o.isDatatypeProperty() || o.isAnnotationProperty()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Processing Datatype/Annotation property");
                }
                for (String v : values) {
                    this.model.add(this.model.createStatement(resourceInstance, (Property)o, v.trim()));
                }
                continue;
            }
            if (o.isObjectProperty()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Processing Object property");
                }
                String t = mapping.getTargetRangeURI(key);
                logger.debug((Object)("URI= " + t));
                OntClass or = this.ontModel.getOntClass(t);
                for (String v : values) {
                    Resource r = this.findInstanceByLabel(or.getURI(), v.trim());
                    if (r == null) {
                        r = this.createInstance(or.getURI());
                        this.model.add(this.model.createStatement(r, RDFS.label, v.trim()));
                    }
                    this.model.add(this.model.createStatement(resourceInstance, (Property)o, (RDFNode)r));
                }
                continue;
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)"Property is not defined in OWL");
        }
        if (resourceInstance.getProperty(RDF.type) == null && resourceClass != null) {
            this.setType(resourceInstance, resourceClass.getURI());
            if (resourceInstance.getProperty(RDFS.label) == null) {
                this.setTypeAsLabel(resourceInstance, resourceClass);
            }
        }
    }

    private OntClass findSubclass(OntClass resourceClass, String subclassLabel, boolean direct) {
        if (subclassLabel == null) {
            return null;
        }
        ExtendedIterator extIt = resourceClass.listSubClasses(direct);
        while (extIt.hasNext()) {
            OntClass subclass = (OntClass)extIt.next();
            if (!subclassLabel.equalsIgnoreCase(subclass.getLabel(null))) continue;
            return subclass;
        }
        return null;
    }

    private void connectToType(Resource r, String rootClassUri, String propertyUri, String subclassLabel) {
        OntClass rootClass = this.ontModel.getOntClass(rootClassUri);
        this.connectToType(r, rootClass, propertyUri, subclassLabel);
    }

    private void connectToType(Resource r, OntClass rootClass, String propertyUri, String subclassLabel) {
        if (subclassLabel != null) {
            OntProperty op = this.ontModel.getOntProperty(propertyUri);
            OntClass subclass = this.findSubclass(rootClass, subclassLabel, false);
            if (subclass != null) {
                this.model.add(this.model.createStatement(r, (Property)op, (RDFNode)subclass));
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("A subclass of " + rootClass.getLabel(null) + " with label " + subclassLabel + " was not found in the eagle-i ontology. Creating a resource in unclassified namespace."));
                }
                Resource ur = this.model.createResource("http://eagle-i.org/ont/unknown/" + subclassLabel.replaceAll("\\s{1,}", "_"));
                this.model.add(this.model.createStatement(ur, RDF.type, (RDFNode)rootClass));
                this.model.add(this.model.createStatement(ur, this.directType, (RDFNode)rootClass));
                this.model.add(this.model.createStatement(ur, RDFS.label, subclassLabel));
                this.model.add(this.model.createStatement(r, (Property)op, (RDFNode)ur));
            }
        }
    }

    private Resource findInstanceByLabel(String targetClass, String targetLabel) {
        ResIterator it = this.model.listResourcesWithProperty(RDF.type, (RDFNode)this.ontModel.getOntClass(targetClass));
        while (it.hasNext()) {
            Resource tr = (Resource)it.next();
            String label = tr.getProperty(RDFS.label).getString();
            if (!label.equalsIgnoreCase(targetLabel)) continue;
            return tr;
        }
        return null;
    }

    private void connectToInstance(Resource r, String targetClassUri, String propertyUri, String targetLabel) {
        OntProperty p = this.ontModel.getOntProperty(propertyUri);
        Resource tr = this.findInstanceByLabel(targetClassUri, targetLabel);
        if (tr != null) {
            this.model.add(this.model.createStatement(r, (Property)p, (RDFNode)tr));
        } else {
            if (p == null) {
                p = this.model.createProperty(propertyUri);
            }
            tr = this.createInstance(targetClassUri);
            this.model.add(this.model.createStatement(tr, RDFS.label, targetLabel));
            this.model.add(this.model.createStatement(r, (Property)p, (RDFNode)tr));
        }
    }

    private void materializeTypes(Resource resourceInstance, OntClass ontClass) {
        ExtendedIterator extIt = ontClass.listSuperClasses();
        while (extIt.hasNext()) {
            OntClass parent = (OntClass)extIt.next();
            if (parent.getURI() == null || parent.getURI().equals(OWL.Thing.getURI()) || parent.getURI().equals(RDFS.Resource.getURI())) continue;
            this.model.add(this.model.createStatement(resourceInstance, RDF.type, (RDFNode)parent));
        }
    }

    private void setTypeAsLabel(Resource resourceInstance, OntClass ontClass) {
        if (resourceInstance.getProperty(RDFS.label) == null) {
            this.model.add(this.model.createStatement(resourceInstance, RDFS.label, ontClass.getLabel(null)));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Label is empty; setting it to type label instead");
            }
        }
    }
}

