/**
 * 
 */
package org.eaglei.datatools.client.rpc;

import java.io.Serializable;
import java.util.List;

import org.eaglei.datatools.client.status.ClientSideRepositoryException;
import org.eaglei.model.EIInstanceMinimal;
import org.eaglei.model.EIURI;
import org.eaglei.security.Session;

import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;

/**
 * @author "Sravan Cheriyala" Started Mar 17, 2011
 */
@RemoteServiceRelativePath("../datatools/managment")
public interface DataManagmentService extends RemoteService {

	// TODO:way too many arguments need to minimize the args
	public List<EIInstanceMinimal> getResourcesToRepair(EIURI typeURI, EIURI predicateURI, String objectString, Boolean isObjectLiteral) throws ClientSideRepositoryException;
	
	public List<EIInstanceMinimal> getResourcesToRepairByRegex(EIURI typeURI, EIURI predicateURI, String regex) throws ClientSideRepositoryException;

	public Integer replaceObject(EIURI typeURI, EIURI predicateURI, String oldObjectString, String newObjectString, Boolean isObjectLiteral) throws ClientSideRepositoryException;

	public Integer replacePredicate(EIURI typeURI, EIURI oldPredicateURI,  EIURI newPredicateURI,String objectString, Boolean isObjectLiteral) throws ClientSideRepositoryException;

	// FIX:really too many args
	public Integer replaceObjectAndPredicate(EIURI typeURI, EIURI oldPredicateURI, EIURI newPredicateURI, String oldObjectString, String newObjectString, Boolean isObjectLiteral) throws ClientSideRepositoryException;

	public Integer deleteTriple(EIURI typeURI, EIURI predicateURI, String objectString, Boolean isObjectLiteral) throws ClientSideRepositoryException;
	
	public Integer replaceObjectByRegex(EIURI typeURI, EIURI predicateURI, String regex,String replaceRegex) throws ClientSideRepositoryException;
	
	public Session switchServer(String nodeName,String userName,String password);
	
	

}
