/**
 * 
 */
package org.eaglei.datatools.client.rpc;

import java.util.List;

import org.eaglei.datatools.client.status.ClientSideRepositoryException;
import org.eaglei.model.EIInstanceMinimal;
import org.eaglei.model.EIURI;
import org.eaglei.security.Session;

import com.google.gwt.user.client.rpc.AsyncCallback;

/**
 * @author "Sravan Cheriyala" Started Mar 17, 2011
 */
public interface DataManagmentServiceAsync {

	public void getResourcesToRepair(EIURI typeURI, EIURI predicateURI, String objectString, Boolean isObjectLiteral, AsyncCallback<List<EIInstanceMinimal>> callback);
	
	public void getResourcesToRepairByRegex(EIURI typeURI, EIURI predicateURI, String regex, AsyncCallback<List<EIInstanceMinimal>> callback) throws ClientSideRepositoryException;

	public void replaceObject(EIURI typeURI, EIURI predicateURI, String oldObjectString, String newObjectString, Boolean isObjectLiteral, AsyncCallback<Integer> callback) throws ClientSideRepositoryException;

	public void replacePredicate(EIURI typeURI, EIURI oldPredicateURI, EIURI newPredicateURI, String objectString, Boolean isObjectLiteral, AsyncCallback<Integer> callback) throws ClientSideRepositoryException;

	public void replaceObjectAndPredicate(EIURI typeURI, EIURI oldPredicateURI, EIURI newPredicateURI, String oldObjectString, String newObjectString, Boolean isObjectLiteral, AsyncCallback<Integer> callback) throws ClientSideRepositoryException;

	public void deleteTriple(EIURI typeURI, EIURI predicateURI, String objectString, Boolean isObjectLiteral, AsyncCallback<Integer> callback) throws ClientSideRepositoryException;

	public void replaceObjectByRegex(EIURI typeURI, EIURI predicateURI, String regex,String replaceRegex, AsyncCallback<Integer> callback) throws ClientSideRepositoryException;
	
	public void switchServer(String nodeName,String userName,String password, AsyncCallback<Integer> callback);

}
