package org.eaglei.datatools.client.rpc;

import java.util.List;

import org.eaglei.datatools.User;
import org.eaglei.datatools.WorkFlowTransition;
import org.eaglei.datatools.Workspace;
import org.eaglei.model.EIEntity;
import org.eaglei.security.Session;

import com.google.gwt.user.client.rpc.AsyncCallback;

public interface RepositorySecurityServiceAsync {
	
	public void login(String user, String password, AsyncCallback<User> callback); 

	public void logout(Session session, AsyncCallback callback); 

	public void whoami(Session session, AsyncCallback<User> callback); 

	public void isOnline(AsyncCallback callback); 
	
	public void getWorkspaces(Session session, AsyncCallback<List<Workspace>> callback); 
	
	public void listWorkFlowTransitions(Session session, EIEntity workspaceEntity, AsyncCallback<List<WorkFlowTransition>> callback); // WorkFlowProvider

}
