package org.eaglei.datatools.client.rpc;

import java.util.List;
import java.util.Map;

import org.eaglei.datatools.SortByProperties;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIInstanceMinimal;
import org.eaglei.model.EIProperty;
import org.eaglei.model.EIURI;
import org.eaglei.search.provider.AuthSearchRequest;
import org.eaglei.security.Session;

import com.google.gwt.user.client.rpc.AsyncCallback;

/**
 * The client side stub for the RPC service.
 */
public interface RepositoryToolsModelServiceAsync {
	/*
	 * query
	 */

	public void listResourcesForObjectPropertyValue(final Session session, final EIURI classUri, final EIURI provider, final EIURI state, final boolean onlyProvider, AsyncCallback< List<EIInstanceMinimal> > callback);// QueryProvider

	public void EIQuery(Session session, String query, AsyncCallback<List<EIInstanceMinimal>> callback); // QueryProvider

	public void retrieveLabel(Session session, EIURI uri, AsyncCallback<String> callback); // QueryProvider
	
	public void query(Session session, String sparql, AsyncCallback<String> callback); // QueryProvider


	/*
	 * instance functionality
	 */

	public void getNewInstanceID(Session session, int count, AsyncCallback<List<EIURI>> callback); // CrudProvider

	public void getEmptyEIInstance(Session session, EIURI classUri, EIEntity instanceEntity, AsyncCallback<EIInstance> asyncCallback); // CrudProvider

	public void getEmptyEIInstance(Session session, EIURI classUri, AsyncCallback<EIInstance> asyncCallback); // CrudProvider

	public void getOneInstance(Session session, EIURI instanceUri, boolean isExtended, AsyncCallback<EIInstance> callback);
	
	public void setReferencingResources(Session session, EIInstance instance, AsyncCallback<EIInstance> callback); // InstanceProvider

	public void getToken(Session session, EIInstance instance, AsyncCallback<String> callback); // CrudProvider

	public void getTokens(Session session, List<EIInstance> instances, AsyncCallback<Map<EIInstance, String>> callback); // CrudProvider

	public void updateInstance(Session session, EIInstance instance, String token, AsyncCallback callback); // CrudProvider

	public void updateInstances(Session session, Map<EIInstance, String> instancesWithTokens, AsyncCallback callback); // CrudProvider

	public void createInstance(Session session, EIInstance instance, EIEntity workspaceEntity, AsyncCallback callback); // CrudProvider

	public void createInstances(Session session, List<EIInstance> instances, EIEntity workspaceEntity, AsyncCallback callback); // CrudProvider

	public void deleteInstance(Session session, EIURI instanceUri, AsyncCallback callback); // CrudProvider

	public void deleteInstances(Session session, List<EIURI> instanceUris, AsyncCallback callback); // CrudProvider

	public void deepCopy(Session session, EIURI originalUri, AsyncCallback callback); // CrudProvider

	public void getModifiedDates(Session session, List<EIURI> uris, AsyncCallback<Map<EIURI, String>> callback);
	

	/* workflow API */
	public void claim(Session session, List<EIURI> uris, AsyncCallback<List<EIURI>> callback); // WorkFlowProvider

	public void release(Session session, List<EIURI> uris, AsyncCallback<List<EIURI>> callback); // WorkFlowProvider

	public void listResources(Session session, AuthSearchRequest queryRequest, SortByProperties orderBy, boolean isAscending, boolean strictOwnerFilter, AsyncCallback<List<EIInstanceMinimal>> callback);
	public void listResources(final Session session, final AuthSearchRequest queryRequest, final SortByProperties orderBy, final boolean isAscending, final boolean strictOwnerFilter, final boolean stubsOnly, AsyncCallback<List<EIInstanceMinimal>> callback);

	public void listReferencingResources(Session session, EIURI resourceUri, AuthSearchRequest queryRequest, SortByProperties orderBy, boolean strictOwnerFilter, AsyncCallback<List<EIInstanceMinimal>> callback);

	public void transition(Session session, List<EIURI> uris, EIEntity transitionEntity, AsyncCallback<List<EIURI>> callback); // WorkFlowProvider
	
	/* hybrid repository/ontology method(s) not found on provider */
	public void getRootSuperclassForInstanceUri(Session session, EIURI instanceUri, AsyncCallback<EIClass> callback);

	public void getClassAndSuperclassesForInstanceUri(Session session, EIURI instanceUri, AsyncCallback<List<EIClass>> callback);

	void getRootSuperClass(EIClass eclass, AsyncCallback<EIClass> callback);

	public void getAllEquivalentClasses(List<EIProperty> propertiesToPopulate, AsyncCallback<List<EIProperty>> asyncCallback);

	/*to check if the URI is ontology term or repository instance*/
	public void isModelClassURI(EIURI uri,AsyncCallback<Boolean> callback);
	
	/* datatools metadata */
	public void addLabToUser(Session session, EIURI labUri, AsyncCallback<Boolean> callback);

	

}
