package org.eaglei.datatools.client.ui;

import org.eaglei.model.EIInstance;
import org.eaglei.ui.gwt.instance.InstancePanel;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;

public abstract class DatatoolsInstancePanel extends InstancePanel {

	protected FormRedisplay redisplayCallbacks;
	protected ButtonsPanel buttonPanel;
  
	
	protected abstract void setButtonState();

	public DatatoolsInstancePanel(final EIInstance instance, final FormRedisplay redisplay) {
		redisplayCallbacks = redisplay;
		eiInstance = instance;
		initializeSpecifics();
	}
 
	@Override
	protected void initializeSpecifics() {
		buttonPanel = new ButtonsPanel( eiInstance, redisplayCallbacks );
		outerFormPanel.add( buttonPanel );
		buttonPanel.copyResourceButton.addClickHandler( new ClickHandler() {
			@Override
			public void onClick(final ClickEvent event) {
				redisplayCallbacks.drawAfterDuplicate( eiInstance );
			}
		} );

		setButtonState();

		super.initializeSpecifics();

	}

}
