package org.eaglei.datatools.client.ui;

import java.util.List;

import org.eaglei.datatools.SortByProperties;
import org.eaglei.datatools.client.AbstractEntryPoint;
import org.eaglei.datatools.client.ApplicationState;
import org.eaglei.datatools.client.QueryTokenObject.Mode;
import org.eaglei.datatools.client.logging.GWTLogger;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.rpc.RootAsyncCallback;
import org.eaglei.model.EIInstanceMinimal;
import org.eaglei.model.EIURI;
import org.eaglei.search.provider.AuthSearchRequest;

import com.google.gwt.user.client.Window;

public class MainController implements ApplicationStateChangeListener {

	public static final String DATATOOLS_FILTER = "DatatoolsFilter";
	public static final String DATATOOLS_CONTROLS = "DatatoolsControls";

	private static final GWTLogger log = GWTLogger.getLogger( "MainController" );

	public MainController() {
		ApplicationState.getInstance().addApplicationStateListener( this );
		onApplicationStateChange();
	}

	@Override
	public void onApplicationStateChange() {
		if ( !ApplicationState.getInstance().hasUser() ) {
			log.info( "no user!" );
			AbstractEntryPoint.clearDataPanel();
			return;
		}

		if ( Mode.isResourcesList( ApplicationState.getInstance().getMode() ) ) {
			drawResourcesListMode();
		} else if ( ApplicationState.getInstance().getMode() == Mode.workbench ) {
			drawWorkbench();
		} else if ( ApplicationState.getInstance().getMode() == Mode.view ) {
			drawView();
		} else if ( ApplicationState.getInstance().getMode() == Mode.edit ) {
			drawEdit();
		}
	}

	private void drawResourcesListMode() {
		/*
		 * if ( ApplicationState.getInstance().getMode() == Mode.resources ) { log.debug( "showing empty grid" ); AbstractEntryPoint.clearDataPanel(); AbstractEntryPoint.showData( new EIResourcesGrid() ); } else
		 */
		if ( ApplicationState.getInstance().getMode() == Mode.references ) {
			if ( ApplicationState.getInstance().hasInstance() ) {
				log.info( "showing references to " + ApplicationState.getInstance().getInstanceEntity().getLabel() );

				drawGrid();
			} else {
				log.warn( "trying to display references mode with no instance!" );
				Window.alert( "Trying to display references without a referrent!" ); // TODO: move to messages if we keep this
			}
		} else {
			drawGrid();
		}
	}

	protected void drawWorkbench() {
		AbstractEntryPoint.showWorkbench();
	}

	protected void drawGrid() {
		AbstractEntryPoint.clearDataPanel();
		if ( ApplicationState.getInstance().getMode() == Mode.resources ) {
			AbstractEntryPoint.showData( new EIResourcesGrid() );
			return;
		}

		if ( applicationShouldShowEmptyGrid() ) {
			AbstractEntryPoint.showData( new EIResourcesGrid() );
			return;
		}

		EIURI typeUri, WFStateUri, providerUri;
		if ( ApplicationState.getInstance().getMode() == Mode.filter ) {
			typeUri = ApplicationState.getInstance().getFilterTypeUri();
			WFStateUri = ApplicationState.getInstance().getFilterWorkflowUri();
			providerUri = ApplicationState.getInstance().getFilterResourceProviderUri();
			log.debug( "setting parameters for filter query: " + typeUri + ", " + WFStateUri + ", " + providerUri );
		} else {
			typeUri = ApplicationState.getInstance().getTypeUri();
			WFStateUri = EIURI.NULL_EIURI;
			providerUri = ApplicationState.getInstance().getResourceProviderUri();
			log.debug( "setting parameters for unfiltered query: " + typeUri + ", " + WFStateUri + ", " + providerUri );
		}
		AbstractEntryPoint.showGlasspane();
		final AuthSearchRequest request = new AuthSearchRequest();
		if ( ApplicationState.getInstance().isPaginated() ) {
			request.setPaginated( true );
			request.setStartIndex( ApplicationState.getInstance().getOffset() );
			request.setMaxResults( ApplicationState.getInstance().getLimit() );
		} else {
			request.setPaginated( false );
		}
		if ( ApplicationState.getInstance().getMode() == Mode.references ) {
			ClientRepositoryToolsManager.INSTANCE.listReferencingResources( ApplicationState.getInstance().getInstanceUri(), request, SortByProperties.getOrderBy( ApplicationState.getInstance().getSortBy() ), ApplicationState.getInstance()
					.isStrictlyFilteredByOwner(), getDisplayCallback() );
		} else {
			request.setType( typeUri );
			request.setWFState( WFStateUri );
			request.setLab( providerUri );
			final boolean requestStubs = ApplicationState.getInstance().getMode() == Mode.stubs;
			if ( requestStubs ) {
				log.debug( "requesting stubs; type is " + typeUri + "; instance is " + ApplicationState.getInstance().getInstanceUri() );
			}
			// TODO: the "true" in here is for isAscending; we were never really doing the correct stubs query because it was masked.
			ClientRepositoryToolsManager.INSTANCE
					.listResources( request, SortByProperties.getOrderBy( ApplicationState.getInstance().getSortBy() ), true, ApplicationState.getInstance().isStrictlyFilteredByOwner(), requestStubs, getDisplayCallback() );
		}
	}

	private boolean applicationShouldShowEmptyGrid() {
		return false;
	}

	private RootAsyncCallback<List<EIInstanceMinimal>> getDisplayCallback() {
		return new RootAsyncCallback<List<EIInstanceMinimal>>() {
			@Override
			public void onSuccess(final List<EIInstanceMinimal> result) {
				AbstractEntryPoint.hideGlasspane();
				final EIResourcesGrid grid = new EIResourcesGrid( result );
				AbstractEntryPoint.showData( grid );
			}

			@Override
			public void onFailure(Throwable caught) {
				AbstractEntryPoint.hideGlasspane();
				super.onFailure( caught );
			}
		};
	}

	protected void drawView() {
		log.debug( "viewing " + ApplicationState.getInstance().getInstanceEntity() );
		AbstractEntryPoint.clearDataPanel();
		AbstractEntryPoint.showData( FormsPanelFactory.generateViewForm( ApplicationState.getInstance().getInstanceUri() ) );
	}

	protected void drawEdit() {
		log.debug( "editing " + ApplicationState.getInstance().getInstanceEntity() );
		AbstractEntryPoint.clearDataPanel();
		if ( !ApplicationState.getInstance().hasInstance() ) {
			AbstractEntryPoint.showData( FormsPanelFactory.generateNewForm( ApplicationState.getInstance().getTypeEntity() ) );
		} else {
			AbstractEntryPoint.showData( FormsPanelFactory.generateEditForm( ApplicationState.getInstance().getInstanceUri() ) );
		}
	}

	public void onLogIn(final String username, final String userUri) {
		log.debug( "main controller logged in, calling on AppStateChange; mode = " + ApplicationState.getInstance().getMode() + "; type = " + ApplicationState.getInstance().getTypeEntity() );
		onApplicationStateChange();
	}

	public void onLogOut(boolean isSessionExpired) {
		onApplicationStateChange();
	}
}
