package org.eaglei.datatools.client.ui;

import java.util.Collection;
import java.util.Map;
import java.util.Set;

import org.eaglei.datatools.client.ui.widgets.EditWidgetCollection;
import org.eaglei.datatools.client.ui.widgets.TextAreaWidget;
import org.eaglei.datatools.client.ui.widgets.TextWidget;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;

import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Label;

public class NonOntlogyPropEditRenderer extends NonOntologyPropertiesRenderer {

	public NonOntlogyPropEditRenderer(EIInstance eiInstance, FlowPanel nonOntologyPanel) {
		super( eiInstance, nonOntologyPanel );
	}

	@Override
	protected void drawNonOntologyLiteralProperty(final EIEntity propertyEntity, final Set<String> propertyValues, final FlowPanel nonOntologyPanel) {
		if ( !propertyEntity.getURI().toString().equals( DatatoolsUIConstants.COMMENTS ) && !propertyEntity.getURI().toString().equals( DatatoolsUIConstants.CURATOR_NOTE ) ) {
			final EditWidgetCollection fields = new EditWidgetCollection( eiInstance, propertyEntity );
			nonOntologyPanel.add( fields );
			for (final String value : propertyValues) {
				fields.addWidget( TextWidget.makeNonOntologyTextWidget( eiInstance, propertyEntity, value ) );
			}
		}
	}

	@Override
	protected void drawNonOntologyResourceProperty(final EIEntity propertyEntity, final Set<EIEntity> propertyValues, final FlowPanel nonOntologyPanel) {
		final EditWidgetCollection fields = new EditWidgetCollection( eiInstance, propertyEntity );
		nonOntologyPanel.add( fields );
		for (final EIEntity value : propertyValues) {
			fields.addWidget( TextWidget.makeNonOntologyTextWidget( eiInstance, propertyEntity, value.getLabel() ) );
		}
	}
	
	
	@Override
	protected Collection<EIEntity> getNonOntologyLiteralPropEntities() {
		return eiInstance.getNonOntologyLiteralProperties().keySet();
	}

	@Override
	protected Collection<EIEntity> getNonOntologyResourcePropEntities() {
		return eiInstance.getNonOntologyResourceProperties().keySet();
	}

	@Override
	protected void drawExtraFields(final Map<EIEntity, Set<String>> nonOntologyLiteralProperties) {
		final Label commentOnComments = new Label( UIMessages.COMMENT_ON_COMMENTS );
		commentOnComments.setStyleName( "commentOnComments" );
		nonOntologyOuterPanel.add( commentOnComments );
		final EIEntity comments = EIEntity.create( DatatoolsUIConstants.COMMENTS, DatatoolsUIConstants.COMMENTS_LABEL );
		final EIEntity curatorComments = EIEntity.create( DatatoolsUIConstants.CURATOR_NOTE, DatatoolsUIConstants.CURATOR_LABEL );
		final String commentValue = nonOntologyLiteralProperties.containsKey( comments ) ? nonOntologyLiteralProperties.get( comments ).iterator().next() : null;
		final TextAreaWidget commentsArea = TextAreaWidget.makeNonOntologyTextArea( eiInstance, comments, "", false, commentValue );
		nonOntologyOuterPanel.add( commentsArea );
		final String curatorValue = nonOntologyLiteralProperties.containsKey( curatorComments ) ? nonOntologyLiteralProperties.get( curatorComments ).iterator().next() : null;
		final TextAreaWidget curatorArea = TextAreaWidget.makeNonOntologyTextArea( eiInstance, curatorComments, "", false, curatorValue );
		nonOntologyOuterPanel.add( curatorArea );
	}
	

	@Override
	protected void drawReferencedBy() {
		// TODO Auto-generated method stub
		
	}

}
