package org.eaglei.datatools.client.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.eaglei.datatools.client.ApplicationState;
import org.eaglei.datatools.client.QueryTokenObject.Mode;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIURI;
import org.eaglei.ui.gwt.instance.Renderer;
import org.eaglei.ui.gwt.instance.widgets.InstanceWidgetUtils;
import org.eaglei.ui.gwt.instance.widgets.LabelValuesWidget;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.DisclosurePanel;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;

public abstract class NonOntologyPropertiesRenderer implements Renderer {
	
	protected EIInstance eiInstance;
	protected FlowPanel nonOntologyOuterPanel;
	
	protected boolean shouldShowReadOnlyProperties = true; //TODO: IS this required???
	
	protected abstract void drawExtraFields(Map<EIEntity, Set<String>> nonOntologyLiteralProperties);
	
	protected abstract Collection<EIEntity> getNonOntologyLiteralPropEntities();

	protected abstract Collection<EIEntity> getNonOntologyResourcePropEntities();
	
	protected abstract void drawNonOntologyLiteralProperty(EIEntity propertyEntity, Set<String> propertyValues, FlowPanel nonOntologyPanel);

	protected abstract void drawNonOntologyResourceProperty(EIEntity propertyEntity, Set<EIEntity> propertyValues, FlowPanel nonOntologyPanel);
	
	public NonOntologyPropertiesRenderer(EIInstance eiInstance, FlowPanel nonOntologyOuterPanel ) {
		this.eiInstance = eiInstance;
		this.nonOntologyOuterPanel = nonOntologyOuterPanel;
		renderProperties();
	}

	@Override
	public void renderProperties() {
		final Map<EIEntity, Set<String>> instanceNonOntologyLiteralProperties = eiInstance.getNonOntologyLiteralProperties();
		drawExtraFields(instanceNonOntologyLiteralProperties);
		drawReferencedBy();
		drawAdminProperties();
	}
	
	protected void drawAdminProperties() { 
		final DisclosurePanel nonOntologyPanel = new DisclosurePanel( "Information for data curators" );

		final Map<EIEntity, Set<String>> instanceNonOntologyLiteralProperties = eiInstance.getNonOntologyLiteralProperties();
		final Map<EIEntity, Set<EIEntity>> instanceNonOntologyResourceProperties = eiInstance.getNonOntologyResourceProperties();
	
		final List<EIEntity> entityList = new ArrayList<EIEntity>();
		entityList.addAll( eiInstance.getReadOnlyLiteralProperties().keySet() );
		entityList.addAll( eiInstance.getReadOnlyResourceProperties().keySet() );
		entityList.addAll( instanceNonOntologyLiteralProperties.keySet() );
		entityList.addAll( instanceNonOntologyResourceProperties.keySet() );

		final FlowPanel innerPanel = new FlowPanel();
		createNonOntologyPanel( instanceNonOntologyLiteralProperties, instanceNonOntologyResourceProperties, innerPanel );

		nonOntologyPanel.add( innerPanel );
		nonOntologyPanel.setStyleName( "formPanelInside" );
		nonOntologyOuterPanel.add( nonOntologyPanel ); 
	}
	
	protected void createNonOntologyPanel(final Map<EIEntity, Set<String>> nonOntologyLiteralProperties, final Map<EIEntity, Set<EIEntity>> nonOntologyResourceProperties, final FlowPanel innerPanel) {
		
		final FlowPanel metaPanel = new FlowPanel();
		final FlowPanel otherPanel = new FlowPanel();
		designPanel( metaPanel, "Metadata properties:" );
		designPanel( otherPanel, "Other properties:" );

		final LabelValuesWidget eagleIUniqueId = new LabelValuesWidget( "eagle-i unique ID" );
		final Anchor id = new Anchor( eiInstance.getInstanceURI().toString(), eiInstance.getInstanceURI().toString(), "_blank" );
		eagleIUniqueId.add( id );
		innerPanel.add( eagleIUniqueId ); 
		if ( shouldShowReadOnlyProperties ) {
			innerPanel.add( metaPanel );
			innerPanel.add( otherPanel );

			final Map<EIEntity, String> readOnlyLiterals = eiInstance.getReadOnlyLiteralProperties();
			final Map<EIEntity, EIEntity> readOnlyResources = eiInstance.getReadOnlyResourceProperties();

			drawReadOnlyProperties( null, metaPanel, readOnlyLiterals, readOnlyResources );
		}

		final FlowPanel panelToUse = shouldShowReadOnlyProperties ? otherPanel : innerPanel;
		for (final EIEntity propEntity : nonOntologyLiteralProperties.keySet()) {
			drawNonOntologyLiteralProperty( propEntity, nonOntologyLiteralProperties.get( propEntity ), panelToUse );
		}

		for (final EIEntity propEntity : nonOntologyResourceProperties.keySet()) {
			drawNonOntologyResourceProperty( propEntity, nonOntologyResourceProperties.get( propEntity ), panelToUse );
		}
		
	}

	private void designPanel(final FlowPanel panel, final String header) {
		panel.setStyleName( "formPanel" );

		final Label propHeader = new Label( header );
		propHeader.setStyleName( "nonOntologyPropertyLabel" );
		panel.add( propHeader );
	}
	
	protected void drawReferencedBy() {
		final Anchor referencedBy = new Anchor( "Referenced by..." );
		referencedBy.addClickHandler( new ClickHandler() {

			@Override
			public void onClick(final ClickEvent arg0) {
				ApplicationState.getInstance().updateApplicationState( Mode.references, eiInstance.getEntity(), EIEntity.NULL_ENTITY, ApplicationState.getInstance().getResourceProviderEntity() );
			}

		} );
		final FlowPanel referencePanel = new FlowPanel();
		referencePanel.add( referencedBy );
		referencePanel.setStyleName("formPanelRow");
		referencedBy.setStyleName( "referencedBy" );
		nonOntologyOuterPanel.add( referencePanel );
	}
	
	private void drawReadOnlyProperties(final Map<EIEntity, String> labelMap, final FlowPanel metaPanel, final Map<EIEntity, String> readOnlyLiterals, final Map<EIEntity, EIEntity> readOnlyResources) {
		for (final EIEntity propEntity : readOnlyLiterals.keySet()) {
			drawReadOnlyLiteralProperty( propEntity, makeSetFromSingle( readOnlyLiterals.get( propEntity ) ), labelMap, metaPanel );
		}

		for (final EIEntity propEntity : readOnlyResources.keySet()) {
			drawReadOnlyResourceProperty( propEntity, makeSetFromSingleEntity( readOnlyResources.get( propEntity ) ), labelMap, metaPanel );
		}
	}
	
	protected HashSet<String> makeSetFromSingle(final String value) {
		return new HashSet<String>(Arrays.asList(new String[] { value }));
	}

	protected HashSet<EIURI> makeSetFromSingleURI(final EIURI value) {
		return new HashSet<EIURI>(Arrays.asList(new EIURI[] { value }));
	}

	protected HashSet<EIEntity> makeSetFromSingleEntity(final EIEntity value) {
		return new HashSet<EIEntity>(Arrays.asList(new EIEntity[] { value }));
	}

	protected Widget handleReadOnlyTextProperty(final String value) {
		if (value.startsWith("www") || value.startsWith("http")) {
			// For values that have external URIs
			return new Anchor(InstanceWidgetUtils.formatText(value), InstanceWidgetUtils.formatText(value), "_blank");
		} else {
			final HTML valueField = new HTML(InstanceWidgetUtils.formatText( InstanceWidgetUtils.insertBreaks( value )));
			valueField.setStyleName("formLabelValue");
			return valueField;
		}
	}

	protected void drawReadOnlyLiteralProperty(final EIEntity propertyEntity, final Set<String> propertyValues, final Map<EIEntity, String> labelMap, final FlowPanel nonOntologyPanel) {
		final String propLabel = (labelMap == null || labelMap.get(propertyEntity) == null || labelMap.get(propertyEntity).equals("")) ? propertyEntity.getLabel() : labelMap.get(propertyEntity);

		final LabelValuesWidget widget = new LabelValuesWidget(propLabel);
		for (final String value : propertyValues) {
			widget.add(handleReadOnlyTextProperty(value));
		}
		nonOntologyPanel.add(widget);
	}

	protected void drawReadOnlyResourceProperty(final EIEntity propertyEntity, final Set<EIEntity> propertyValues, final Map<EIEntity, String> labelMap, final FlowPanel nonOntologyPanel) {
		final String propLabel = (labelMap == null || labelMap.get(propertyEntity) == null || labelMap.get(propertyEntity).equals("")) ? propertyEntity.getLabel() : labelMap.get(propertyEntity);

		final LabelValuesWidget widget = new LabelValuesWidget(propLabel);
		for (final EIEntity propEntity : propertyValues) {
			if (propEntity != null && propEntity != EIEntity.NULL_ENTITY) {
				widget.add(handleReadOnlyTextProperty(propEntity.getLabel()));
			}
		}
		nonOntologyPanel.add(widget);
	}
	
}
