package org.eaglei.datatools.client.ui;

import com.google.gwt.dom.client.Element;

public class Validations {
	public static boolean ShouldNotBeEmpty(final String txt) {
		if ( txt.equals( "" ) ) {
			return false;
		} else {
			return true;
		}
	}

	public static boolean NumbersNotAllowed(final String txt) {
		if ( !txt.matches( "^[a-zA-Z\\s]*$" ) ) {
			return false;
		} else {
			return true;
		}
	}

	public static boolean TextNotAllowed(final String txt) {
		if ( !txt.matches( "^[\\d]+$" ) ) {
			return false;
		} else {
			return true;
		}
	}

	public static boolean OnlyPhoneFormat(final String txt) {
		if ( !txt.matches( "^[\\d\\-\\)\\(]+$" ) ) {
			return false;
		} else {
			return true;
		}
	}

	public static boolean OnlyNumbersAllowed(final String txt) {
		if ( !txt.matches( "^[\\d]+$" ) ) {
			return false;
		} else {
			return true;
		}
	}

	public static boolean SplChar_NotAllowed(final String txt) {
		if ( !txt.matches( "^[a-zA-Z\\d\\s]*$" ) ) {
			return false;
		} else {
			return true;
		}
	}

	public static boolean IsEmailBox(final String txt) {
		if ( !txt.matches( "^[a-zA-Z_\\d\\.]+?@[a-zA-Z_\\d\\-]+?\\.[a-zA-Z\\.]+$" ) ) {
			return false;
		} else {
			return true;
		}
	}

	public static boolean SpaceNotAllowed(final String txt) {
		if ( !txt.matches( "^[^\\s]*$" ) ) {
			return false;
		} else {
			return true;
		}
	}

	public static boolean not_EmptyandNumbersandSplChars(final String txt) {
		if ( !ShouldNotBeEmpty( txt ) && !NumbersNotAllowed( txt ) && SplChar_NotAllowed( txt ) ) {
			return false;
		} else {
			return true;
		}
	}

	public static boolean not_EmptyandSpaces(final String txt) {
		if ( !ShouldNotBeEmpty( txt ) && SpaceNotAllowed( txt ) ) {
			return false;
		} else {
			return true;
		}
	}

	public static boolean Emailnot_EmptyandSpaces(final String txt) {
		if ( !ShouldNotBeEmpty( txt ) && !IsEmailBox( txt ) && SpaceNotAllowed( txt ) ) {
			return false;
		} else {
			return true;
		}
	}

	public static boolean not_EmptyPhoneFormat(final String txt) {
		if ( !ShouldNotBeEmpty( txt ) && OnlyPhoneFormat( txt ) ) {
			return false;
		} else {
			return true;
		}
	}

	public static boolean EmptybutNot_NumbersandSplChars(final String txt) {
		if ( !NumbersNotAllowed( txt ) && !SplChar_NotAllowed( txt ) ) {
			return false;
		} else {
			return true;
		}
	}

	public static native void jsniPhoneValidation(Element p1)
	/*-{
		p=p1.value
		if(p.length==3){
		    //d10=p.indexOf('(')
		    pp=p;
		    d4=p.indexOf('(')
		    d5=p.indexOf(')')
		    if(d4==-1){
		        pp="("+pp;
		    }
		    if(d5==-1){
		        pp=pp+")";
		    }
		    //pp="("+pp+")";
		   p1.value="";
		  p1.value=pp;
		}
		if(p.length>3){
		    d1=p.indexOf('(')
		    d2=p.indexOf(')')
		    if (d2==-1){
		        l30=p.length;
		        p30=p.substring(0,4);
		        //alert(p30);
		        p30=p30+")"
		        p31=p.substring(4,l30);
		        pp=p30+p31;
		        //alert(p31);
		        p1.value="";
		        p1.value=pp;
		    }
		    }
		if(p.length>5){
		    p11=p.substring(d1+1,d2);
		    if(p11.length>3){
		    p12=p11;
		    l12=p12.length;
		    l15=p.length
		    //l12=l12-3
		    p13=p11.substring(0,3);
		    p14=p11.substring(3,l12);
		    p15=p.substring(d2+1,l15);
		    p1.value="";
		    pp="("+p13+")"+p14+p15;
		    p1.value=pp;
		    //obj1.value="";
		    //obj1.value=pp;
		    }
		    l16=p.length;
		    p16=p.substring(d2+1,l16);
		    l17=p16.length;
		    if(l17>3&&p16.indexOf('-')==-1){
		        p17=p.substring(d2+1,d2+4);
		        p18=p.substring(d2+4,l16);
		        p19=p.substring(0,d2+1);
		        //alert(p19);
		    pp=p19+p17+"-"+p18;
		    p1.value="";
		    p1.value=pp;
		    //obj1.value="";
		    //obj1.value=pp;
		    }
		}
		//}
	//	setTimeout(jsniPhoneValidation,100)
	}-*/;
}
