package org.eaglei.datatools.client.ui;

import org.eaglei.datatools.client.ApplicationState;
import org.eaglei.datatools.client.QueryTokenObject.Mode;
import org.eaglei.datatools.client.logging.GWTLogger;
import org.eaglei.model.EIInstance;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;

/**
 * Displays the Form for viewing. All the fields are disabled and no editing is possible.
 * 
 */
public class ViewFormsPanel extends DatatoolsInstancePanel {

	private static final GWTLogger log = GWTLogger.getLogger( "ViewFormsPanel" );

	public ViewFormsPanel(final EIInstance instance, final ViewFormRedisplay redisplay) {
		super( instance, redisplay ); 
		ontologyPropRenderer = new OntologyPropViewRenderer(eiInstance, ontologyPanel);
		renderer = new NonOntologyPropViewRenderer( eiInstance, nonOntologyOuterPanel );
		shouldShowReadOnlyProperties = true;
	}

	@Override
	protected void setButtonState() {
		buttonPanel.saveButton.setVisible( false );
		buttonPanel.copyResourceButton.setVisible( true );
		buttonPanel.cancelButton.setVisible( false );
		// buttonPanel.editButton.setVisible(true);
		buttonPanel.editButton.addClickHandler( new ClickHandler() {
			@Override
			public void onClick(final ClickEvent event) {
				ApplicationState.getInstance().setMode( Mode.edit ); // TODO: anything else we need to set here?
			}
		} );

	}
}
