package org.eaglei.datatools.client.ui.widgets;

import org.eaglei.datatools.client.ApplicationState;
import org.eaglei.datatools.client.QueryTokenObject.Mode;
import org.eaglei.datatools.client.logging.GWTLogger;
import org.eaglei.datatools.client.ui.ApplicationStateChangeListener;
import org.eaglei.datatools.client.ui.ResourceProvider;
import org.eaglei.model.EIEntity;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;

public class BreadcrumbWidget extends HorizontalPanel implements ApplicationStateChangeListener { // TODO: FlowPanel? Check with Seth

	private final Anchor workbenchLink;
	private Anchor providerLink;
	private Anchor resourcesLink;
	private EIEntity providerEntity = EIEntity.NULL_ENTITY;
	private final static String nextCrumb = "  >  ";

	private static final GWTLogger log = GWTLogger.getLogger( "BreadcrumbWidget" );

	public BreadcrumbWidget() {
		setStyleName("breadcrumb_container");

		workbenchLink = new Anchor( "Workbench" );
		workbenchLink.addClickHandler( new ClickHandler() {

			@Override
			public void onClick(ClickEvent event) {
				hideFollowing( workbenchLink );
				providerEntity = EIEntity.NULL_ENTITY;
				ApplicationState.getInstance().updateApplicationState( Mode.workbench, EIEntity.NULL_ENTITY, EIEntity.NULL_ENTITY, EIEntity.NULL_ENTITY );
			}
		} );
		add( workbenchLink );

		addNextCrumb();

		providerLink = new Anchor( "" );
		providerLink.setVisible( false );
		providerLink.setEnabled( false );
		providerLink.addClickHandler( new ClickHandler() {

			@Override
			public void onClick(ClickEvent event) {
				hideFollowing( providerLink );
				log.debug("updating resource provider to " + providerEntity);
				ApplicationState.getInstance().updateApplicationState( Mode.view, providerEntity, ResourceProvider.BASE_RESOURCE_CONTAINER, providerEntity );
			}
		} );
		add( providerLink );

		addNextCrumb();

		resourcesLink = new Anchor( "Resources" );
		resourcesLink.setVisible( false );
		resourcesLink.setEnabled( false );
		add( resourcesLink );
	}

	@Override
	public void onApplicationStateChange() {
		log.debug( "breadcrumb widget app state changed" );
		providerEntity = ApplicationState.getInstance().getResourceProviderEntity();
		if ( ApplicationState.getInstance().hasResourceProvider() ) {
			log.debug( "has lab" );
			providerLink.setText( ApplicationState.getInstance().getResourceProviderEntity().getLabel() );
			providerLink.setVisible( true );
			providerLink.setEnabled( true );
			showPrevious( providerLink );
			hideFollowing( providerLink );
		} else if ( ApplicationState.getInstance().getMode() == Mode.workbench ) {
			log.debug( "workbench mode" );
			workbenchLink.setVisible( true );
			hideFollowing( workbenchLink );
		} else { 
			log.debug( "no resource provider" );
			providerLink.setText( "" );
			providerLink.setVisible( false );
			providerLink.setEnabled( false );
			hideFollowing( providerLink );
		}

		if ( ( providerEntity != EIEntity.NULL_ENTITY ) && Mode.isResourcesList( ApplicationState.getInstance().getMode() ) ) {
			String label = ApplicationState.getInstance().getTypeEntity().equals( EIEntity.NULL_ENTITY ) ? "Resources" : ApplicationState.getInstance().getTypeEntity().getLabel();
			
			resourcesLink.setText( label );
			resourcesLink.setVisible( true );
			resourcesLink.setEnabled( true );
			showPrevious( resourcesLink );
		}
	}
	
	public void reset() {
		hideFollowing( workbenchLink );
		
		providerLink.setText( "" );
		providerLink.setVisible( false );
		providerLink.setEnabled( false );
		hideFollowing( providerLink );
		
		resourcesLink.setText("");
		resourcesLink.setVisible( false );
		resourcesLink.setEnabled( false );
		
	}

	private void addNextCrumb() {
		final Label nextWidgetLabel = new Label( nextCrumb );
		nextWidgetLabel.setStyleName("breadCrumbArrow");
		add( nextWidgetLabel );
		nextWidgetLabel.setVisible( false );
	}

	private void showPrevious(Anchor anchor) {
		if ( getWidgetIndex( anchor ) > 0 ) {
			getWidget( getWidgetIndex( anchor ) - 1 ).setVisible( true );
		}
	}

	private void hideFollowing(Anchor clickedAnchor) {
		int clickedWidgetIndex = getWidgetIndex( clickedAnchor );
		for (int i = clickedWidgetIndex + 1; i < getWidgetCount(); i++) {
			getWidget( i ).setVisible( false );
		}
	}
}
